<div class="card">
    <div class="card-header">
        <h3>Cadastro de Entrada de Pacientes:</h3>
    </div>
    <div class="card-body">
        <form action="" method="POST">
            <div class='row'>
                <div class="col-md-7">
                    <div class="row">
                        <div class='col-md-6'>
                            <b>Hospital</b>
                            <select name="hospitalid" id="" class="form-control">
                                <?php foreach ($hospitais as $item): ?>
                                    <option value="<?=$item->hospitalid?>"><?=$item->nomefantasia?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class='col-md-6'>
                            <b>Número Carteirinha / CPF:</b>
                            <input type="text" name='carteiracpf' required class='form-control'>
                        </div>
                        <div class='col-md-6'>
                            <b>Tipo de Paciente:</b>
                            <select name="tipo" id="tipo" class='form-control'>
                                <option value="Diag. Suspeito">Diag. Suspeito</option>
                                <option value="Diag. Confirmado">Diag. Confirmado</option>
                                <option value="Descartado">Descartado</option>
                            </select>
                        </div>
                        <div class='col-md-6'>
                            <b>Grupo de risco</b> <br>
                            <select name="gruporisco[]" required class="form-control select2" multiple id="gruporisco" style="width:100%">
                                <option value="Não">Não</option>
                                <option value="Diabético">Diabético</option>
                                <option value="Crônico">Crônico</option>
                                <option value="Hipertenso">Hipertenso</option>
                                <option value="Problemas Respiratórios">Problemas Respiratórios</option>
                            </select>
                        </div>
                        <div class='col-md-6' style="margin-top:1%">
                            <b>Local:</b>
                            <select name="local" id="local" class='form-control'>
                                <option value="UTI">UTI</option>
                                <option value="Enfermaria">Enfermaria</option>
                                <option value="Isolamento Domiciliar">Isolamento Domiciliar</option>
                            </select>
                        </div>
                        <div class='col-md-6' style="margin-top:1%"><br>
                            <b>Teste Colhido:</b>
                            <label class="switch">
                                <input type="checkbox" name="testecolhido">
                                <span class="slider2 round">
                                </span>
                            </label><br>
                            <b>Ventilação Mecânica:</b>
                            <label class="switch">
                                <input type="checkbox" name="ventilacao">
                                <span class="slider2 round">
                                </span>
                            </label>
                        </div>
                    </div>
                </div>
                <div class="col-md-5">
                    <div class="row">
                        <div class="col-md-12">
                            <b>Observação</b>
                            <textarea name="observacao" rows="4" id="observacao"class="form-control"></textarea>
                        </div>
                        <div class="col-md-9"><br>
                            <b>Houve Alta:</b>
                            <label class="switch">
                                <input type="checkbox" name="alta">
                                <span class="slider2 round">
                                </span>
                            </label>
                        </div>
                        <div class="col-md-3">
                            <br>
                            <button type='submit' class="btn btn-primary">Enviar</button>
                        </div>
                    </div>
                </div>
            </div>
            </form>
            <br>
            <br>
            <hr>
            <h3>Pacientes Cadastrados:</h3>
            <table class="table table-striped table-responsive datatable" id="datatable2" cellpadding="0" cellspacing="0">
                <thead>
                    <tr>
                        <th>Carteira / CPF</th>
                        <th>Condição</th>
                        <th>Grupo de Risco</th>
                        <th>Observação</th>
                        <th>Data Cadastro</th>
                        <th>Ventilação Mecânica</th>
                        <th>Teste Colhido</th>
                        <th>Houve Alta</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($pacientes as $item): ?>
                    <tr style="cursor:pointer" data-target="#modal" data-toggle="modal" target="_BLANK" href="<?=$this->request->getAttribute('base')?>/adm/dashboardcorona/edicaomodal/<?=$item->entradapacientesid?>">
                        <td style="white-space: nowrap; padding: 0;text-align:center;"><?=$item->carteiracpf?></td>
                        <td style="white-space: nowrap; padding: 0;text-align:center;"><?=$item->tipo?></td>
                        <td style="white-space: nowrap; padding: 0;text-align:center;"><?=$item->gruporisco ?? $item->gruporisco2?></td>
                        <td style="word-wrap: break-word;"><?=$item->observacao?></td>
                        <td style="white-space: nowrap; padding: 0;text-align:center;"><?=$this->Custom->formatDataHora($item->datacadastro)?></td>
                        <td style="white-space: nowrap; padding: 0;text-align:center;"><?=$this->Custom->toSimNao($item->ventilacao)?></td>
                        <td style="white-space: nowrap; padding: 0;text-align:center;"><?=$this->Custom->toSimNao($item->testecolhido)?></td>
                        <td style="white-space: nowrap; padding: 0;text-align:center;"><?=$this->Custom->toSimNao($item->alta)?></td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<script>
function reloadDatatable() {
    $('#datatable2').DataTable( 
            {
                language: {
                    url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
                    decimal: ",",
                    thousands: "."
                },
                dom: 'Bfrtip',
                buttons: [
                {
                    extend: 'copy',
                    text: 'Copiar',
                    footer: true
                },
                {
                    extend: 'print',
                    text: 'Imprimir',
                    footer: true
                },
                {
                    extend: 'excel',
                    filename: 'FlyMed',
                    text: 'Excel',
                    footer: true
                },
                {
                    extend: 'pdf',
            //Name the pdf
            filename: 'FlyMed Relação de Pacientes',
            text: 'PDF',
            orientation:'portrait',
            messageTop: 'Corps Teknologi - Analytics para Gestão Inteligente \n Emitido em: <?=Date('d/m/y h:i:s')?> \n Flymed',
            pageSize:'A4',
            footer: true
            }
            ],
            responsive: false,
            retrieve: false,
            destroy:true,
            paging : true,
            "pageLength":10,
            "order": [[ 1, "desc" ]],
            "scrollX" : true,
            fixedHeader: {
                header: false,
                footer: false
            },
			"initComplete": function() {
				window.dispatchEvent(new Event('resize'));
  			}
            } 
            );
}
$(document).ready(
        function() {
            $('#datatable2').DataTable( 
            {
                language: {
                    url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
                    decimal: ",",
                    thousands: "."
                },
                dom: 'Bfrtip',
                buttons: [
                {
                    extend: 'copy',
                    text: 'Copiar',
                    footer: true
                },
                {
                    extend: 'print',
                    text: 'Imprimir',
                    footer: true
                },
                {
                    extend: 'excel',
                    filename: 'FlyMed',
                    text: 'Excel',
                    footer: true
                },
                {
                    extend: 'pdf',
            //Name the pdf
            filename: 'FlyMed Relação de Pacientes',
            text: 'PDF',
            orientation:'portrait',
            messageTop: 'Corps Teknologi - Analytics para Gestão Inteligente \n Emitido em: <?=Date('d/m/y h:i:s')?> \n Flymed',
            pageSize:'A4',
            footer: true
            }
            ],
            responsive: false,
            retrieve: false,
            destroy:true,
            paging : true,
            "pageLength":10,
            "order": [[ 1, "desc" ]],
            "scrollX" : true,
            fixedHeader: {
                header: false,
                footer: false
            },
			"initComplete": function() {
				window.dispatchEvent(new Event('resize'));
  			}
            } 
            );}
        );

</script>
    
<style> 
/* The switch - the box around the slider */
.switch {
  position: relative;
  display: inline-block;
  width: 30px;
  height: 17px;
}

/* Hide default HTML checkbox */
.switch input {
  opacity: 0;
  width: 0;
  height: 0;
}

/* The slider */
.slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  -webkit-transition: .4s;
  transition: .4s;
}

.slider:before {
  position: absolute;
  content: "";
  height: 13px;
  width: 13px;
  left: 2px;
  bottom: 2px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;
}
/* The slider */
.slider2 {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  -webkit-transition: .4s;
  transition: .4s;
}

.slider2:before {
  position: absolute;
  content: "";
  height: 13px;
  width: 13px;
  left: 2px;
  bottom: 2px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;
}

input:checked + .slider {
  background-color: #2196F3;
}

input:focus + .slider {
  box-shadow: 0 0 1px #2196F3;
}

input:checked + .slider2 {
  background-color: #90EE90;
}

input:focus + .slider2 {
  box-shadow: 0 0 1px #90EE90;
}

input:checked + .slider:before {
  -webkit-transform: translateX(13px);
  -ms-transform: translateX(13px);
  transform: translateX(13px);
}

/* Rounded sliders */
.slider.round {
  border-radius: 17px;
}

.slider.round:before {
  border-radius: 50%;
} 
input:checked + .slider2:before {
  -webkit-transform: translateX(13px);
  -ms-transform: translateX(13px);
  transform: translateX(13px);
}

/* Rounded sliders */
.slider2.round {
  border-radius: 17px;
}

.slider2.round:before {
  border-radius: 50%;
} 
</style>