<div class="card">
    <div class="card-header">
        <h3>Central de Atendimentos</h3>
    </div>
    <div class="card-body">
        <ul class="nav nav-tabs"  role="tablist">
            <li class="nav-item">
                <a class="nav-link active" onclick="$('#phone').mask('(99) 999999999');$('#documento').mask('999.999.999-99');" id="base-tab1" data-toggle="tab" aria-controls="Atendimentos" href="#Atendimentos" role="tab" aria-selected="false">Atendimentos</a>
            </li>
            <li class="nav-item">
                <a class="nav-link " id="base-tab2" data-toggle="tab"  aria-controls="Painel" href="#Painel" role="tab" aria-selected="false" onclick="loadkanban()">Painel</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" id="base-tab3" data-toggle="tab" aria-controls="Acompanhamento" onclick="reloadTable()" href="#Acompanhamento" role="tab" aria-selected="false">Acompanhamento</a>
            </li><!--
            <li class="nav-item">
                <a class="nav-link" id="base-tab4" data-toggle="tab"  aria-controls="Hospital" onclick="setTimeout(window.dispatchEvent(new Event('resize')),200)" href="#Hospital" role="tab" aria-selected="false">Hospital</a>
            </li>-->
        </ul>
        <div class="tab-content">
            <div id="Atendimentos" class="tab-pane active">
                <br>
                <form action="" method="POST">
                    <div class="row">
                        <div class="col-md-3 mb-1">
                            <b>Data do Atendimento:</b>
                            <input type="date" required class="form-control" name="datahora_atendimento" value="<?=Date('Y-m-d')?>">
                        </div>
                        <div class="col-md-3 mb-1">
                            <b>Origem da Ligação:</b><br>
                            <table>
                                <tr>
                                    <td>Efetuado</td>
                                    <td><input type="radio" checked id="Efetuado" name="origem" value="Efetuado"></td>
                                </tr>
                                <tr>
                                    <td>Recebido</td>
                                    <td><input type="radio" id="Recebido" name="origem" value="Recebido"></td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-3 mb-1 mt-1">
                        </div>
                        <div class="col-md-3 mb-1"></div>
                        <div class="col-md-2">
                            <b>CPF:</b>
                            <input type="text" required id="documento" onfocusout="apiLiga()" name="documento" placeholder="000.000.000-00" class="form-control" style="margin-top:1%">
                        </div>
                        <div class="col-md-2">
                            <b>Telefone:</b>
                            <input type="text" id="phone" name="telefone" class="form-control" style="margin-top:1%" placeholder="(xx) xxxxxxxxx" onkeypress="this.mask('(99) 999999999')">    
                        </div>
                        <div class="col-md-2">
                            <b>Whatsapp?</b><br>
                            <label class="switch">
                                <input type="checkbox" name="wpp">
                                <span class="slider2 round">
                                </span>
                            </label>
                        </div>
                        <div class="col-md-2">
                            <b>Nascimento:</b>
                            <input type="date" placeholder="Dia/Mês/Ano" class="form-control" id="data_nascimento" name="data_nascimento" style="margin-top:1%">
                        </div>
                        <div class="col-md-4">
                            <b>Nome:</b>
                            <input type="text" class="form-control" id="nome" name="nome" style="margin-top:1%">
                        </div>
                        <div class="col-md-3 mt-1">
                            <b>Sexo:</b>
                            <select name="sexo" class="form-control" id="sexo">
                                <option value="Não Informado">Não Informado</option>
                                <option value="Masculino">Masculino</option>
                                <option value="Feminino">Feminino</option>
                            </select>
                        </div>
                        <div class="col-md-3 mt-1">
                            <b>Logradouro:</b>
                            <input type="text" class="form-control" id="logradouro" name="logradouro">
                        </div>
                        <div class="col-md-3 mt-1">
                            <b>Bairro:</b>
                            <input type="text" class="form-control" id="bairro" name="bairro">
                        </div>
                        <div class="col-md-3 mt-1">
                            <b>Cidade:</b>
                            <select name="cidade" class="form-control" id="cidade">
                                <?php foreach ($cidades as $cidade): ?>
                                <option value="<?=$cidade->id?>" <?=($cidade->nome == 'Natal') ? 'selected' : ''?>><?=$cidade->nome?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="col-md-12"><hr></div>
                        <div class="col-md-4">
                            <b>Data do Primeiro Sintoma:</b>
                            <input type="date" name="dataprimeirosintoma" class="form-control">
                        </div>
                        <div class="col-md-4">
                            <b>Último Tratamento:</b>
                            <select name="tratamento" id="tratamento" class="form-control">
                                <option value="Nenhum">Nenhum</option>
                                <option value="Quimioterapia">Quimioterapia</option>
                                <option value="Radioterapia">Radioterapia</option>
                                <option value="Cirurgia Oncológica">Cirurgia Oncológica</option>
                            </select>
                        </div>
                        <div class="col-md-4">
                            <b>Data do Último Tratamento:</b>
                            <input type="date" placeholder="Dia/Mês/Ano" name="datatratamento" class="form-control">
                        </div>
                        <div class="col-md-12"><hr></div>
                        <div class="col-md-6">
                            <b>Sintomas:</b>
                            <table>
                                <tbody>
                                    <tr>
                                        <td>Febre</td>
                                        <td>
                                            <label class="switch">
                                                <input type="checkbox" name="sintoma[]" value="Febre">
                                                <span class="slider2 round">
                                                </span>
                                            </label>
                                        </td>
                                        <td>&nbsp;&nbsp;&nbsp;</td>
                                        <td>Dor de Cabeça</td>
                                        <td>
                                            <label class="switch">
                                                <input type="checkbox" name="sintoma[]" value="Dor de Cabeça">
                                                <span class="slider2 round">
                                                </span>
                                            </label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Tosse</td>
                                        <td>
                                            <label class="switch">
                                                <input type="checkbox" name="sintoma[]" value="Tosse">
                                                <span class="slider2 round">
                                                </span>
                                            </label>
                                        </td>
                                        <td>&nbsp;&nbsp;&nbsp;</td>
                                        <td>Corisa</td>
                                        <td>
                                            <label class="switch">
                                                <input type="checkbox" name="sintoma[]" value="Corisa">
                                                <span class="slider2 round">
                                                </span>
                                            </label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Cansaço</td>
                                        <td>
                                            <label class="switch">
                                                <input type="checkbox" name="sintoma[]" value="Cansaço">
                                                <span class="slider2 round">
                                                </span>
                                            </label>
                                        </td>
                                        <td>&nbsp;&nbsp;&nbsp;</td>
                                        <td>Diarréia</td>
                                        <td>
                                            <label class="switch">
                                                <input type="checkbox" name="sintoma[]" value="Diarréia">
                                                <span class="slider2 round">
                                                </span>
                                            </label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Dor de Garganta</td>
                                        <td>
                                            <label class="switch">
                                                <input type="checkbox" name="sintoma[]"  value="Dor de Garganta">
                                                <span class="slider2 round">
                                                </span>
                                            </label>
                                        </td>
                                        <td>&nbsp;&nbsp;&nbsp;</td>
                                        <td>Congestão Nasal</td>
                                        <td>
                                            <label class="switch">
                                                <input type="checkbox" name="sintoma[]"  value="Congestão Nasal">
                                                <span class="slider2 round">
                                                </span>
                                            </label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Mialgia</td>
                                        <td>
                                            <label class="switch">
                                                <input type="checkbox" name="sintoma[]"  value="Mialgia">
                                                <span class="slider2 round">
                                                </span>
                                            </label>
                                        </td>
                                        <td>&nbsp;&nbsp;&nbsp;</td>
                                        <td>Artralgia</td>
                                        <td>
                                            <label class="switch">
                                                <input type="checkbox" name="sintoma[]"  value="Artralgia">
                                                <span class="slider2 round">
                                                </span>
                                            </label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Náusea/Vômitos</td>
                                        <td>
                                            <label class="switch">
                                                <input type="checkbox" name="sintoma[]" value="Náusea/Vômitos">
                                                <span class="slider2 round">
                                                </span>
                                            </label>
                                        </td>
                                        <td>&nbsp;&nbsp;&nbsp;</td>
                                        <td>Irritabilidade/Confusão</td>
                                        <td>
                                            <label class="switch">
                                                <input type="checkbox" name="sintoma[]" value="Irritabilidade/Confusão">
                                                <span class="slider2 round">
                                                </span>
                                            </label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Falta de Ar</td>
                                        <td>
                                            <label class="switch">
                                                <input type="checkbox" name="sintoma[]" value="Falta de Ar">
                                                <span class="slider2 round">
                                                </span>
                                            </label>
                                        </td>
                                        <td>&nbsp;&nbsp;&nbsp;</td>
                                        <td>Outros</td>
                                        <td>
                                            <label class="switch">
                                                <input type="checkbox" name="sintoma[]" value="Outros">
                                                <span class="slider2 round">
                                                </span>
                                            </label>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-12">
                                    <b>Observações:</b>
                                    <textarea class="form-control" style="margin-top:1%" name="observacao"></textarea>
                                </div>
                                <div class="col-md-5">
                                <b>Metástase Pulmonar</b><br>
                                    <label class="switch">
                                        <input type="checkbox" name="metastasepulmonar">
                                        <span class="slider2 round">
                                        </span>
                                    </label>
                                </div>
                                <div class="col-md-7">
                                    <b><?=$customlabel1?>:</b>
                                    <input type="text" name="tumorprimario" class="form-control">
                                </div>
                                <div class="col-md-12 mt-1"></div>
                                <div class="col-md-4">
                                    <b>Teste Colhido</b><br>
                                    <label class="switch">
                                        <input type="checkbox"  id="testecolhido" onclick="showhideCodigoteste(this)" name="testecolhido">
                                        <span class="slider2 round">
                                        </span>
                                    </label>
                                </div>
                                <div id="testecovid" style="display:none" class="col-md-8">
                                    <b>Código do Teste:</b>
                                    <input type="text" name="codigoteste" class="form-control">
                                </div>
                                <div class="col-md-4" id="covidpositivo" style="display:none">
                                    <b>Covid Positivo</b><br>
                                    <label class="switch">
                                        <input type="checkbox" name="covidpositivo" >
                                        <span class="slider2 round">
                                        </span>
                                    </label>
                                </div>
                                <div class="col-md-8" id="datateste" style="display:none" >
                                    <b>Data do Teste</b>
                                    <input type="date" class="form-control" name="datateste">
                                </div>
                            </div>

                        </div>
                        <div class="col-md-12"><hr></div><!--
                        <div class="col-md-12">
                            <b>CID-10:</b><br>
                            <select class="form-control select2"  name="cid" id="cid">
                                <?php foreach ($cids as $cid): ?>
                                <option value="<?=$cid->codigo?>" <?=($cid->codigo == 'B34.2') ? 'selected' : ''?>><?=$cid->codigo?> <?=$cid->nome?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>-->
                        <div class="col-md-12"><br></div>
                        <div class="col-md-5">
                            <b>Direcionamento:</b>
                            <textarea class="form-control" style="margin-top:1%" name="direcionamento"></textarea>
                        </div>
                        <div class="col-md-5">
                            <b>Local Direcionamento:</b>
                            <select name="hospitalid" id="hospitalid" style="margin-top:1%" class="form-control select2">
                                <option value="0">Isolamento</option>
                            <?php foreach ($hospitais as $hospital): ?>
                                <option value="<?=$hospital->hospitalid?>"><?=$hospital->nomefantasia?></option>
                            <?php endforeach; ?>
                            </select><br>
                            <div class="float-right mt-1"><button class="btn btn-primary">Enviar</button></div><!--
                            <a class="btn" href="https://api.whatsapp.com/send?1=pt_BR&phone=5584988162008&text=Olá%20Somos%20o%20FlyMed!" target="_BLANK" style="background-color:#1ad13f;color:white"><i class="fa fa-whatsapp" aria-hidden="true"></i> Enviar Whataspp</a>-->
                        </div>
                        <div class="col-md-2">
                            <b>Fim dos Sintomas</b><br>
                            <label class="switch">
                                <input type="checkbox" value="0" onclick="fimsintomas(this)" name="fimsintoma">
                                <span class="slider2 round">
                                </span>
                            </label><br>
                            <b>Alta</b><br>
                            <label class="switch">
                                <input type="checkbox" value="0" name="alta">
                                <span class="slider2 round">
                                </span>
                            </label><br>
                            <b>Óbito</b><br>
                            <label class="switch">
                                <input type="checkbox" value="0" name="obito">
                                <span class="slider2 round">
                                </span>
                            </label><br>
                        </div>
                    </div>
                </form>
            </div>
            <div id="Painel" class="tab-pane">
                <div id="kanbanatendimento"></div>
            </div>
            <div id="Acompanhamento" class="tab-pane"><br>
                <div class="row">
                    <div class="col-md-3 ">
                        <div class="w3-card w3-hover-shadow w3-center" title="Ligações Totais | Ligações de Pessoas Distintas" style="height:80px"><br>
                            <h5 style="color:#16D39A">Total de Ligações <br></h5>
                            <h6 style="color:#16D39A"><b><?=$this->Custom->toNumber($totalgeralligacoes)?> | <?=$this->Custom->toNumber($totalligacoes)?></b></h6>    
                        </div>
                    </div>
                    <div class="col-md-2 ">
                        <div class="w3-card w3-hover-shadow w3-center" style="height:80px"><br>
                            <h5 style="color:#000000">Suspeito (Leve)</h5>
                            <h6 style="color:#000000"><b><?=$covidleve?></b></h6>
                        </div>
                    </div>
                    <div class="col-md-2 ">
                        <div class="w3-card w3-hover-shadow w3-center" style="height:80px"><br>
                            <h5 style="color:#FF0000">Suspeito (Grave)</h5>
                            <h6 style="color:#FF0000"><b><?=$covidgrave?></b></h6>
                        </div>
                    </div>
                    <div class="col-md-2 ">
                        <div class="w3-card w3-hover-shadow w3-center" style="height:80px"><br>
                            <h5 style="color:#000000">Não Suspeito</h5>
                            <h6 style="color:#000000"><b><?=$naosuspeito?></b></h6>
                        </div>
                    </div>
                    <div class="col-md-3 ">
                        <div class="w3-card w3-hover-shadow w3-center" style="height:80px"><br>
                            <h5 style="color:#000000">Metástase Pulmonar</h5>
                            <h6 style="color:#000000"><b><?=$metastase?></b></h6>
                        </div>
                    </div>
                    <div class="col-md-12"><br></div>
                    <div class="col-md-12">
                        <table class="table table-striped table-responsive datatable" id="datatableatendimento" cellpadding="0" cellspacing="0">
                            <thead>
                                <tr>
                                    <th>Data Contato</th>
                                    <th>Paciente</th>
                                    <th>Telefone</th>
                                    <th>Data Primeiro Atendimento</th>
                                    <th>Ligações</th>
                                    <th>Local Direcionamento</th>
                                    <th>Encaminhamento</th>
                                    <th>Motivo</th>
                                    <th>Metástase Pulmonar</th>
                                    <th>Cidade</th>
                                    <th>Bairro</th>
                                    <th>Atendente</th>
                                </tr> 
                            </thead>
                            <tbody>
                            <?php foreach ($atendimentos as $item): ?>
                                <tr style="cursor:pointer" data-target="#modal" data-toggle="modal" target="_BLANK" href="<?=$this->request->getAttribute('base')?>/adm/telemedicina/modalhistoricopaciente/<?=$item->atendimentoid2?>">
                                    <td><?=$this->Custom->formatDataHora($item->datahora_atendimento)?></td>
                                    <td><?=$item->nome?></td>
                                    <td><?=$item->telefone?></td>
                                    <td><?=$this->Custom->formatDataHora($item->primeiroatendimento)?></td>
                                    <td><?=$item->ligacoes?></td>
                                    <td><?=($item->hospitalid == 0) ? 'Isolamento' : $this->Custom->get('Hospital','hospitalid',$item->hospitalid)->nomefantasia?></td>
                                    <td style="word-wrap: break-word;"><?=$item->direcionamento?></td>
                                    <td><?php if($item->motivo == 0) { echo '<span class="badge badge-success">Não Suspeito</span>';} else if ($item->motivo == 1) { echo '<span class="badge badge-warning">Susp. Leve</span>'; } else { echo '<span class="badge badge-danger">Susp. Grave</span>'; }?></td>
                                    <td><?php if($item->metastasepulmonar == 0) { echo '<span class="badge badge-success">Não</span>';} else { echo '<span class="badge badge-warning">Sim</span>'; }?></td>
                                    <td><?=$this->Custom->get('Cidade','id',$item->cidade)->nome?></td>
                                    <td><?=$item->bairro?></td>
                                    <td><?=$item->usuariocadastronome.' ('.$item->usuariocadastro.')'?></td>
                                </tr>
                            <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="col-md-12"><hr></div><!--
                    <div class="col-md-12">
                        <b>Direcionamento do Paciente</b>
                        <div id='direcionamentopaciente' class="echart-container"  style="width: 100%;text-align:center;min-height: 350px"></div>
                    </div>
                    <div class="col-md-12"><hr></div>
                    <div class="col-md-12">
                        <b>Dimensionamento Espacial COVID-19</b><br>
                        <div id="mapid" class="col-lg-12 col-md-12 col-sm-12 border-right-blue-grey border-right-lighten-5"></div>
                    </div>-->
                </div>
            </div>
            <div id="Hospital" class="tab-pane">
            </div>
        </div>
    </div>
</div>
<script>
    $(document).ready(function(){
        $("#phone").mask("(99) 999999999");
        $("#documento").mask("999.999.999-99");
        document.body.style.zoom = 0.9;
    });
    
    function showhideCodigoteste(who) {
        if (who.checked) {
            $('#testecovid').show();
            $('#covidpositivo').show();
            $('#datateste').show();
        } else {
            $('#testecovid').hide();
            $('#covidpositivo').hide();
            $('#datateste').hide();
        }
    }
function loadkanban(){
    var url =  encodeURI("kanbanatendimento");
    $('#loading').show();
    $('#kanbanatendimento').load("./telemedicina/"+url,function(){
        $('#loading').hide();
    });
}
    $('#datatableatendimento').DataTable( 
    {
        language: {
            url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
            decimal: ",",
            thousands: "."
        },
        dom: 'Bfrtip',
                buttons: [
                {
                    extend: 'copy',
                    text: 'Copiar',
                    footer: true
                },
                {
                    extend: 'print',
                    text: 'Imprimir',
                    footer: true
                },
                {
                    extend: 'excel',
                    filename: 'FlyMed',
                    text: 'Excel',
                    footer: true
                },
                {
                    extend: 'pdf',
            //Name the pdf
            filename: 'FlyMed Resumo Hospital',
            text: 'PDF',
            orientation:'landscape',
            title:'',
            messageTop: 'Corps Teknologi - Analytics para Gestão Inteligente \n Emitido em: <?=Date('d/m/y H:i:s')?> Por: <?=$usuario->nome?> \n Flymed - Central de Atendimentos \n Total de Registros: <?=count($atendimentos)?>',

            pageSize:'A4',
            footer: true
            }
            ],
    destroy: true,
    responsive: false,
    retrieve: false,
    paging : true,
    "pageLength":10,
    "scrollX" : false,
    fixedHeader: {
        header: false,
        footer: false
    },
    "initComplete": function() {
        window.dispatchEvent(new Event('resize'));
    }
    } 
    );
function reloadTable() {
    $('#datatableatendimento').DataTable( 
    {
        language: {
            url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
            decimal: ",",
            thousands: "."
        },
        dom: 'Bfrtip',
                buttons: [
                {
                    extend: 'copy',
                    text: 'Copiar',
                    footer: true
                },
                {
                    extend: 'print',
                    text: 'Imprimir',
                    footer: true
                },
                {
                    extend: 'excel',
                    filename: 'FlyMed',
                    text: 'Excel',
                    footer: true
                },
                {
                    extend: 'pdf',
                    filename: 'FlyMed Resumo Hospital',
                    text: 'PDF',
                    orientation:'landscape',
                    title:'',
                    messageTop: 'Corps Teknologi - Analytics para Gestão Inteligente \n Emitido em: <?=Date('d/m/y H:i:s')?> Por: <?=$usuario->nome?> \n Flymed - Central de Atendimentos \n Total de Registros: <?=count($atendimentos)?>',

                    pageSize:'A4',
                    footer: true
                }
            ],
    destroy: true,
    responsive: false,
    retrieve: false,
    paging : true,
    order:  [],
    "pageLength":10,
    "scrollX" : false,
    fixedHeader: {
        header: false,
        footer: false
    },
    "initComplete": function() {
        window.dispatchEvent(new Event('resize'));
    }
    } 
    );
}
    var myChart5 = echarts.init(document.getElementById('direcionamentopaciente'));
    option = {
    series: {
        type: 'sankey',
        layout: 'none',
        focusNodeAdjacency: 'allEdges',
        data: [{
            name: 'Central Teleatendimento'
        }, {
            name: 'UPA'
        }, {
            name: 'LIGA'
        }, {
            name: 'Isolamento Domiciliar'
        }],
        links: [{
            source: 'Central Teleatendimento',
            target: 'UPA',
            value: 3
        }, {
            source: 'Central Teleatendimento',
            target: 'LIGA',
            value: 5
        }, {
            source: 'Central Teleatendimento',
            target: 'Isolamento Domiciliar',
            value: 12
        }, {
            source: 'Isolamento Domiciliar',
            target: 'UPA',
            value: 4
        }]
    }
};


myChart5.setOption(option);


// Resize chart
// ------------------------------

$(function () {

// Resize chart on menu width change and window resize
$(window).on('resize', resize);
$(".menu-toggle").on('click', resize);

// Resize function
function resize() {
    setTimeout(function() {

        // Resize chart
        myChart5.resize();
    }, 200);
}
});
    var mymap = L.map('mapid').setView([ -5.808805, -35.231174], 8);
    const attribution = 
    '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors';
    const tileUrl = 'https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png';
    const tiles = L.tileLayer(tileUrl,{attribution});
    tiles.addTo(mymap);
    <?php $count = 0; foreach ($hospitais as $hospital) : ?>
        var circle = L.circle([<?=$hospital->latitude?>, <?=$hospital->longitude?>], {
            color: 'red',
            fillColor: '#f03',
            fillOpacity: 0.5,
            radius: 500+ <?=$count*10?>
        });
        circle.bindPopup("<?=$count?> Confirmados COVID-19."); <?php $count++;?>
        circle.addTo(mymap);
    //var marker = L.marker([<?=$hospital->latitude?>, <?=$hospital->longitude?>]).addTo(mymap);
    <?php endforeach; ?>
    reloadCharts();
    window.dispatchEvent(new Event('resize'));
    window.dispatchEvent(new Event('resize'));

    
    function fimsintomas(who) {
        var sintomas = document.getElementsByName('sintoma[]');
        for (var i = 0; i < sintomas.length; i++) {
            if (sintomas[i].checked) {
                alert('Atenção, Verifique os Sintomas do Paciente');
                who.checked = false;
                break;
            }
        }
    }
var debug;
function apiLiga(){
    let cpf = $('#documento').val()
    if (cpf.length == 14) {
        $.get( "<?=$this->request->getAttribute('base')?>/adm/telemedicina/apiTeleatendimento/"+cpf, function( data ) {
            if (data == null) {
                $('#data_nascimento').val('')
                $("#nome").val('')
                $("#bairro").val('')
                $("#logradouro").val('')
                $("#sexo")[0].options[0].selected = true
                Swal.fire({
                    icon: 'error',
                    title: 'Paciente Não Cadastrado',
                    text: 'Por favor, realize o cadastro manualmente'
                })
            } else {
                $('#data_nascimento').val(data.dataNascimento.split("T")[0])
                $("#nome").val(data.nomePaciente)
                $("#bairro").val(data.bairro)
                $("#logradouro").val(data.logradouro)
                for (let i = 0; i < $("#cidade")[0].options.length; i++) {
                    if ( $("#cidade")[0].options[i].innerText.toUpperCase() == data.cidade ) {
                        $("#cidade")[0].options[i].selected = true
                    }
                }
                if (data.sexo == 'F') {
                    $("#sexo")[0].options[2].selected = true
                } else if (data.sexo == 'M') {
                    $("#sexo")[0].options[1].selected = true
                } else {
                    $("#sexo")[0].options[0].selected = true
                }
            }
        });
    }
}
</script>

<script>
    $(document).ready(function() {
		$('tr[data-toggle="modal"]').on('click', function(e){
			$('.modal-body').html('<div style="text-align:center"><i class="fa fa-refresh fa-spin"></i></div>');
			e.preventDefault();
			$('#modal').modal('show').find('.modal-body').load($(this).attr('href'),function(responseText, textStatus, req){
			if (textStatus == "error") {
				alert('Sua consulta retornou um número muito grande de registros. Tente um período menor.');
				$('[data-dismiss="modal"]').click();
			}
		});
			$('#loading').hide();
		});
		
		$('button[data-dismiss="modal"]').on('click', function(e){
			$('.modal-body').html("");
		});
	});

    setTimeout(function() {
		$('tr[data-toggle="modal"]').on('click', function(e){
			$('.modal-body').html('<div style="text-align:center"><i class="fa fa-refresh fa-spin"></i></div>');
			e.preventDefault();
			$('#modal').modal('show').find('.modal-body').load($(this).attr('href'),function(responseText, textStatus, req){
			if (textStatus == "error") {
				alert('Sua consulta retornou um número muito grande de registros. Tente um período menor.');
				$('[data-dismiss="modal"]').click();
			}
		});
			$('#loading').hide();
		});
		
		$('button[data-dismiss="modal"]').on('click', function(e){
			$('.modal-body').html("");
		});
	},300);
</script>

    

