<div class="card">
    <div class="card-header">
        <h2>Editar Atendimento de <?=$pessoa->nome?></h2>
    </div>
    <div class="card-body">
    <?=$this->Form->create(null)?>
        <br>
        <div class="row">
            <div class="col-md-3 mb-1">
                <b>Data do Atendimento:</b>
                <input type="date" class="form-control" required name="datahora_atendimento" value="<?=$data_horaatendimento?>">
            </div>
            <div class="col-md-3 mb-1">
                <b>Origem da Ligação:</b><br>
                <table>
                    <tr>
                        <td>Efetuado</td>
                        <td><input <?=$atendimento->origemligacao == 'Efetuado' ? 'checked' : '' ?> type="radio" id="Efetuado" name="origem" value="Efetuado"></td>
                    </tr>
                    <tr>
                        <td>Recebido</td>
                        <td><input <?=$atendimento->origemligacao == 'Recebido' ? 'checked' : '' ?> type="radio" id="Recebido" name="origem" value="Recebido"></td>
                    </tr>
                </table>
            </div>
            <div class="col-md-6 mb-1"></div>
            <div class="col-md-2">
                <b>CPF:</b>
                <input type="text" required id="documento" value="<?=$pessoa->documento?>" name="documento" onfocusout="apiLiga()" class="form-control" style="margin-top:1%" >
            </div>
            <div class="col-md-2">
                <b>Telefone:</b> 
                <input type="text"  id="phone" value="<?=$pessoa->telefone?>" name="telefone" class="form-control" style="margin-top:1%" placeholder="(xx) xxxxxxxxx" onkeypress="this.mask('(99) 999999999')">    
            </div>
            <div class="col-md-2">
                <b>Whatsapp?</b><br>
                <label class="switch">
                    <input type="checkbox" <?=($atendimento->wpp) ? 'checked' : ''?> name="wpp" >
                    <span class="slider2 round">
                    </span>
                </label>
            </div>
            <input type="text" style="display:none" value="<?=$pessoa->pessoaid?>" name="pessoaid">
            <div class="col-md-2">
                <b>Nascimento:</b>
                <input type="date" class="form-control" id="data_nascimento" value="<?=$date?>" name="data_nascimento" style="margin-top:1%" >
            </div>
            <div class="col-md-4">
                <b>Nome:</b>
                <input type="text" class="form-control" id="nome" name="nome" value="<?=$pessoa->nome?>" style="margin-top:1%" >
            </div>
            <div class="col-md-3 mt-1">
                <b>Sexo:</b>
                <select name="sexo" class="form-control"  onclick="return false;" id="sexo" >
                    <option <?=($pessoa->sexo == "Não Informado") ? 'selected' : ''?> value="Não Informado">Não Informado</option>
                    <option <?=($pessoa->sexo == "Masculino") ? 'selected' : ''?> value="Masculino">Masculino</option>
                    <option <?=($pessoa->sexo == "Feminino") ? 'selected' : ''?> value="Feminino">Feminino</option>
                </select>
            </div>
            <div class="col-md-3 mt-1">
                <b>Logradouro:</b>
                <input type="text" class="form-control"  value="<?=$pessoa->logradouro?>" id="logradouro" name="logradouro">
            </div>
            <div class="col-md-3 mt-1">
                <b>Bairro:</b>
                <input  type="text"  onclick="return false;" class="form-control" id="bairro" value="<?=$pessoa->bairro?>" name="bairro">
            </div>
            <div class="col-md-3 mt-1">
                <b>Cidade:</b>
                <select  name="cidade"  onclick="return false;" class="form-control" id="cidade">
                    <?php foreach ($cidades as $cidade): ?>
                    <option value="<?=$cidade->id?>" <?=($cidade->nome == 'Natal') ? 'selected' : ''?>><?=$cidade->nome?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-md-12"><hr></div>
            <div class="col-md-4">
                <b>Data do Primeiro Sintoma:</b>
                <input type="date" name="dataprimeirosintoma" value="<?=($dateprimeirosintoma == '') ? '' : $dateprimeirosintoma?>" class="form-control">
            </div>
            <div class="col-md-4">
                <b>Último Tratamento:</b>
                <select name="tratamento" id="tratamento" class="form-control">
                    <option <?=($atendimento->tratamento == 'Nenhum') ? 'selected' : ''?> value="Nenhum">Nenhum</option>
                    <option <?=($atendimento->tratamento == 'Quimioterapia') ? 'selected' : ''?> value="Quimioterapia">Quimioterapia</option>
                    <option <?=($atendimento->tratamento == 'Radioterapia') ? 'selected' : ''?> value="Radioterapia">Radioterapia</option>
                    <option <?=($atendimento->tratamento == 'Cirurgia Oncológica') ? 'selected' : ''?> value="Cirurgia Oncológica">Cirurgia Oncológica</option>
                </select>
            </div>
            <div class="col-md-4">
                <b>Data do Último Tratamento:</b>
                <input type="date" value="<?=($datetratamento == '') ? '' : $datetratamento?>" name="datatratamento" class="form-control">
            </div>
            <div class="col-md-12"><hr></div>
            <div class="col-md-6">
                <b>Sintomas:</b>
                <table>
                    <tbody>
                        <tr>
                            <td>Febre</td>
                            <td>
                                <label class="switch">
                                    <input type="checkbox" name="sintoma[]" <?=in_array('Febre',$sintomaarray) ? 'checked' : ''?> value="Febre">
                                    <span class="slider2 round">
                                    </span>
                                </label>
                            </td>
                            <td>&nbsp;&nbsp;&nbsp;</td>
                            <td>Dor de Cabeça</td>
                            <td>
                                <label class="switch">
                                    <input type="checkbox" name="sintoma[]" <?=in_array('Dor de Cabeça',$sintomaarray) ? 'checked' : ''?> value="Dor de Cabeça">
                                    <span class="slider2 round">
                                    </span>
                                </label>
                            </td>
                        </tr>
                        <tr>
                            <td>Tosse</td>
                            <td>
                                <label class="switch">
                                    <input type="checkbox" name="sintoma[]" <?=in_array('Tosse',$sintomaarray) ? 'checked' : ''?> value="Tosse">
                                    <span class="slider2 round">
                                    </span>
                                </label>
                            </td>
                            <td>&nbsp;&nbsp;&nbsp;</td>
                            <td>Corisa</td>
                            <td>
                                <label class="switch">
                                    <input type="checkbox" name="sintoma[]" <?=in_array('Corisa',$sintomaarray) ? 'checked' : ''?> value="Corisa">
                                    <span class="slider2 round">
                                    </span>
                                </label>
                            </td>
                        </tr>
                        <tr>
                            <td>Cansaço</td>
                            <td>
                                <label class="switch">
                                    <input type="checkbox" name="sintoma[]" <?=in_array('Cansaço',$sintomaarray) ? 'checked' : ''?> value="Cansaço">
                                    <span class="slider2 round">
                                    </span>
                                </label>
                            </td>
                            <td>&nbsp;&nbsp;&nbsp;</td>
                            <td>Diarréia</td>
                            <td>
                                <label class="switch">
                                    <input type="checkbox" name="sintoma[]" <?=in_array('Diarréia',$sintomaarray) ? 'checked' : ''?> value="Diarréia">
                                    <span class="slider2 round">
                                    </span>
                                </label>
                            </td>
                        </tr>
                        <tr>
                            <td>Dor de Garganta</td>
                            <td>
                                <label class="switch">
                                    <input type="checkbox" name="sintoma[]" <?=in_array('Dor de Garganta',$sintomaarray) ? 'checked' : ''?> value="Dor de Garganta">
                                    <span class="slider2 round">
                                    </span>
                                </label>
                            </td>
                            <td>&nbsp;&nbsp;&nbsp;</td>
                            <td>Congestão Nasal</td>
                            <td>
                                <label class="switch">
                                    <input type="checkbox" name="sintoma[]" <?=in_array('Congestão Nasal',$sintomaarray) ? 'checked' : ''?> value="Congestão Nasal">
                                    <span class="slider2 round">
                                    </span>
                                </label>
                            </td>
                        </tr>
                        <tr>
                            <td>Mialgia</td>
                            <td>
                                <label class="switch">
                                    <input type="checkbox" name="sintoma[]" <?=in_array('Mialgia',$sintomaarray) ? 'checked' : ''?> value="Mialgia">
                                    <span class="slider2 round">
                                    </span>
                                </label>
                            </td>
                            <td>&nbsp;&nbsp;&nbsp;</td>
                            <td>Artralgia</td>
                            <td>
                                <label class="switch">
                                    <input type="checkbox" name="sintoma[]" <?=in_array('Artralgia',$sintomaarray) ? 'checked' : ''?> value="Artralgia">
                                    <span class="slider2 round">
                                    </span>
                                </label>
                            </td>
                        </tr>
                        <tr>
                            <td>Náusea/Vômitos</td>
                            <td>
                                <label class="switch">
                                    <input type="checkbox" name="sintoma[]" <?=in_array('Náusea/Vômitos',$sintomaarray) ? 'checked' : ''?> value="Náusea/Vômitos">
                                    <span class="slider2 round">
                                    </span>
                                </label>
                            </td>
                            <td>&nbsp;&nbsp;&nbsp;</td>
                            <td>Irritabilidade/Confusão</td>
                            <td>
                                <label class="switch">
                                    <input type="checkbox" name="sintoma[]" <?=in_array('Irritabilidade/Confusão',$sintomaarray) ? 'checked' : ''?> value="Irritabilidade/Confusão">
                                    <span class="slider2 round">
                                    </span>
                                </label>
                            </td>
                        </tr>
                        <tr>
                            <td>Falta de Ar</td>
                            <td>
                                <label class="switch">
                                    <input type="checkbox" name="sintoma[]"  <?=in_array('Falta de Ar',$sintomaarray) ? 'checked' : ''?> value="Falta de Ar">
                                    <span class="slider2 round">
                                    </span>
                                </label>
                            </td>
                            <td>&nbsp;&nbsp;&nbsp;</td>
                            <td>Outros</td>
                            <td>
                                <label class="switch">
                                    <input type="checkbox" name="sintoma[]"  <?=in_array('Outros',$sintomaarray) ? 'checked' : ''?> value="Outros">
                                    <span class="slider2 round">
                                    </span>
                                </label>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="col-md-6">
                <div class="row">
                    <div class="col-md-12">
                        <b>Observações:</b>
                        <textarea class="form-control" style="margin-top:1%" name="observacao"><?=$atendimento->observacao?></textarea>
                    </div>
                    <div class="col-md-5">
                    <b>Metástase Pulmonar</b><br>
                        <label class="switch">
                            <input type="checkbox" <?=($atendimento->metastasepulmonar) ? 'checked' : ''?> name="metastasepulmonar">
                            <span class="slider2 round">
                            </span>
                        </label>
                    </div>
                    <div class="col-md-7">
                        <b><?=$customlabel1?>:</b>
                        <input type="text" name="tumorprimario" value="<?=$atendimento->tumorprimario?>" class="form-control">
                    </div>
                    <div class="col-md-12 mt-1"></div>
                    <div class="col-md-4">
                        <b>Teste Colhido</b><br>
                        <label class="switch">
                            <input type="checkbox"  id="testecolhido" <?=$atendimento->testecolhido ? 'checked' : ''?> onclick="showhideCodigoteste(this)" name="testecolhido">
                            <span class="slider2 round">
                            </span>
                        </label>
                    </div>
                    <div id="testecovid" <?=($atendimento->testecolhido == 0) ? "style='display:none'" : ''?> class="col-md-8">
                        <b>Código do Teste:</b>
                        <input type="text" name="codigoteste" value="<?=$atendimento->codigoteste?>" class="form-control">
                    </div>
                    <div class="col-md-4" id="covidpositivo" <?=($atendimento->testecolhido == 0) ? "style='display:none'" : ''?>>
                        <b>Covid Positivo</b><br>
                        <label class="switch">
                            <input type="checkbox" <?=$atendimento->covidpositivo ? 'checked' : ''?> name="covidpositivo" >
                            <span class="slider2 round">
                            </span>
                        </label>
                    </div>
                    <div class="col-md-8" id="datateste" <?=($atendimento->testecolhido == 0) ? "style='display:none'" : ''?>>
                        <b>Data do Teste</b>
                        <input type="date" class="form-control" value="<?=$datateste?>" name="datateste">
                    </div>
                </div>
            </div>
            <div class="col-md-12"><hr></div>
            <div class="col-md-12"><br></div>
            <div class="col-md-5">
                <b>Direcionamento:</b>
                <textarea class="form-control" style="margin-top:1%" name="direcionamento"><?=$atendimento->direcionamento?></textarea>
            </div>
            <div class="col-md-5">
                <b>Local Direcionamento:</b>
                <select name="hospitalid" id="hospitalid" style="margin-top:1%" class="form-control select2insidemodal">
                    <option value="0">Isolamento</option>
                <?php foreach ($hospitais as $hospital): ?>
                    <option value="<?=$hospital->hospitalid?>" <?=$atendimento->hospitalid == $hospital->hospitalid ? 'selected' : ''?>><?=$hospital->nomefantasia?></option>
                <?php endforeach; ?>
                </select><br>
                <div class="float-right mt-1"><button class="btn btn-primary">Enviar</button></div>
            </div>
            <div class="col-md-2">
                <b>Fim dos Sintomas</b><br>
                <label class="switch">
                    <input type="checkbox" <?=($atendimento->fimsintoma) ? 'checked' : '' ?> onclick="fimsintomas(this)" value="0" name="fimsintoma">
                    <span class="slider2 round">
                    </span>
                </label><br>
                <b>Alta</b><br>
                <label class="switch">
                    <input type="checkbox" <?=$atendimento->alta == 1 ? 'checked' : ''?> name="alta">
                    <span class="slider2 round">
                    </span>
                </label><br>
                <b>Óbito</b><br>
                <label class="switch">
                    <input type="checkbox" <?=$atendimento->obito == 1 ? 'checked' : ''?> name="obito">
                    <span class="slider2 round">
                    </span>
                </label><br>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function(){
        $("#phone").mask("(99) 999999999");
        $("#documento").mask("999.999.999-99");
        $(".select2insidemodal").select2({
        dropdownParent: $("#modalbody")
        });
    });
    document.body.style.zoom = 0.8;


    function showhideCodigoteste(who) {
        if (who.checked) {
            $('#testecovid').show();
            $('#covidpositivo').show();
            $('#datateste').show();
        } else {
            $('#testecovid').hide();
            $('#covidpositivo').hide();
            $('#datateste').hide();
        }
    }
</script>

<style> 
/* The switch - the box around the slider */
.switch {
  position: relative;
  display: inline-block;
  width: 30px;
  height: 17px;
}

/* Hide default HTML checkbox */
.switch input {
  opacity: 0;
  width: 0;
  height: 0;
}

.slider2 {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  -webkit-transition: .4s;
  transition: .4s;
}

.slider2:before {
  position: absolute;
  content: "";
  height: 13px;
  width: 13px;
  left: 2px;
  bottom: 2px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;
}

input:checked + .slider {
  background-color: #2196F3;
}

input:focus + .slider {
  box-shadow: 0 0 1px #2196F3;
}

input:checked + .slider2 {
  background-color: #90EE90;
}

input:focus + .slider2 {
  box-shadow: 0 0 1px #90EE90;
}

input:checked + .slider:before {
  -webkit-transform: translateX(13px);
  -ms-transform: translateX(13px);
  transform: translateX(13px);
}

input:checked + .slider2:before {
  -webkit-transform: translateX(13px);
  -ms-transform: translateX(13px);
  transform: translateX(13px);
}

/* Rounded sliders */
.slider2.round {
  border-radius: 17px;
}

.slider2.round:before {
  border-radius: 50%;
} 
</style>

<script>
setTimeout(window.dispatchEvent(new Event('resize')),4000);
function fimsintomas(who) {
    var sintomas = document.getElementsByName('sintoma[]');
    for (var i = 0; i < sintomas.length; i++) {
        if (sintomas[i].checked) {
            alert('Atenção, Verifique os Sintomas do Paciente');
            who.checked = false;
            break;
        }
    }
}


function apiLiga(){
    let cpf = $('#documento').val()
    if (cpf.length == 14) {
        $.get( "<?=$this->request->getAttribute('base')?>/adm/telemedicina/apiTeleatendimento/"+cpf, function( data ) {
            if (data == null) {
                $('#data_nascimento').val('')
                $("#nome").val('')
                $("#bairro").val('')
                $("#logradouro").val('')
                $("#sexo")[0].options[0].selected = true
                Swal.fire({
                    icon: 'error',
                    title: 'Paciente Não Cadastrado',
                    text: 'Por favor, realize o cadastro manualmente'
                })
            } else {
                $('#data_nascimento').val(data.dataNascimento.split("T")[0])
                $("#nome").val(data.nomePaciente)
                $("#bairro").val(data.bairro)
                $("#logradouro").val(data.logradouro)
                for (let i = 0; i < $("#cidade")[0].options.length; i++) {
                    if ( $("#cidade")[0].options[i].innerText.toUpperCase() == data.cidade ) {
                        $("#cidade")[0].options[i].selected = true
                    }
                }
                if (data.sexo == 'F') {
                    $("#sexo")[0].options[2].selected = true
                } else if (data.sexo == 'M') {
                    $("#sexo")[0].options[1].selected = true
                } else {
                    $("#sexo")[0].options[0].selected = true
                }
            }
        });
    }
}
</script>