
<div class="card">
    <div class="card-header">
        <h2>Histórico do Paciente <?=$pessoa->nome?></h2><br>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-12">
                <table class="table table-striped table-responsive datatable" id="modalhistoricotable"  cellpadding="0" cellspacing="0">
                    <thead>
                        <tr>
                            <th>Data Contato</th>
                            <th>Telefone</th>
                            <th>Data Primeiro Atendimento</th>
                            <th>Ligações</th>
                            <th>Local Direcionamento</th>
                            <th>Encaminhamento</th>
                            <th>Motivo</th>
                            <th>Metástase Pulmonar</th>
                            <th>Cidade</th>
                            <th>Bairro</th>
                            <th>Atendente</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($resumo as $item): ?>
                        <tr style="padding: 0;text-align:center;">
                            <td><?=$this->Custom->formatDataHora($item->datahora_atendimento)?></td>
                            <td><?=$item->telefone?></td>
                            <td><?=$this->Custom->formatDataHora($item->primeiroatendimento)?></td>
                            <td><?=$item->ligacoes?></td>
                            <td><?=($item->hospitalid == 0) ? 'Isolamento' : $this->Custom->get('Hospital','hospitalid',$item->hospitalid)->nomefantasia?></td>
                            <td><?=$item->direcionamento?></td>
                            <td><?php if($item->motivo == 0) { echo '<span class="badge badge-success">Não Suspeito</span>';} else if ($item->motivo == 1) { echo '<span class="badge badge-warning">Susp. Leve</span>'; } else { echo '<span class="badge badge-danger">Susp. Grave</span>'; }?></td>
                            <td><?php if($item->metastasepulmonar == 0) { echo '<span class="badge badge-success">Não</span>';} else { echo '<span class="badge badge-warning">Sim</span>'; }?></td>
                            <td><?=$this->Custom->get('Cidade','id',$item->cidade)->nome?></td>
                            <td><?=$item->bairro?></td>
                            <td><?=$item->usuariocadastronome.' ('.$item->usuariocadastro.')'?></td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<script>
    $('#modalhistoricotable').DataTable( 
    {
        language: {
            url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
            decimal: ",",
            thousands: "."
        },
        dom: 'Bfrtip',
        buttons: [],
    responsive: false,
    retrieve: false,
    paging : true,
    order : [],
    destroy: true,
    "pageLength":10,
    "scrollX" : true,
    fixedHeader: {
        header: false,
        footer: false
    },
    "initComplete": function() {
        window.dispatchEvent(new Event('resize'));
    }
    } 
    );
</script>
