
<h2><?=$header?></h2><br>
<table class="table table-striped table-responsive datatable" id="cardtable"  cellpadding="0" cellspacing="0">
    <thead>
        <tr>
			<th>Data Contato</th>
			<th>Data Primeiro Atendimento</th>
			<th>Dias em Atendimento</th>
			<th>Qtd Atendimentos</th>
			<th>Paciente</th>
			<th>Telefone</th>
			<th>Local Direcionamento</th>
			<th>Encaminhamento</th>
			<th>Motivo</th>
			<th>Cidade</th>
			<th>Atendente</th>
			<th>Metastase Pulmonar</th>
			<th>Status Atual (Em atendimento, Alta, Óbito)</th>
        </tr>
    </thead>
    <tbody>
    <?php foreach ($resumo as $item): ?>
        <tr style="padding: 0;text-align:center;">
            <td><?=$item->paciente?></td>
            <td style="word-wrap: break-word;"><?=$item->reg_relato?></td>
        </tr>
    <?php endforeach; ?>
    </tbody>
</table>

<script>
    $('#cardtable').DataTable( 
    {
        language: {
            url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
            decimal: ",",
            thousands: "."
        },
        dom: 'Bfrtip',
                buttons: [
                {
                    extend: 'copy',
                    text: 'Copiar',
                    footer: true
                },
                {
                    extend: 'print',
                    text: 'Imprimir',
                    footer: true
                },
                {
                    extend: 'excel',
                    filename: 'FlyMed',
                    text: 'Excel',
                    footer: true
                },
                {
                    extend: 'pdf',
            //Name the pdf
            filename: 'FlyMed <?=$title?>',
            text: 'PDF',
            orientation:'landscape',
            messageTop: 'Corps Teknologi - Analytics para Gestão Inteligente \n Emitido em: <?=Date('d/m/y h:i:s')?> \n FlyMed - <?=$title?>',
            pageSize:'A4',
            footer: true
            }
            ],
    responsive: false,
    retrieve: false,
    order:[],
    paging : true,
    destroy: true,
    "pageLength":10,
    "scrollX" : false,
    fixedHeader: {
        header: false,
        footer: false
    },
    "initComplete": function() {
        window.dispatchEvent(new Event('resize'));
    }
    } 
    );
</script>