<style>
        .btn-circle {
            width: 30px;
            height: 30px;
            padding: 6px 0px;
            border-radius: 15px;
            text-align: center;
            font-size: 12px;
            line-height: 1.42857;
        }
      .centered {
        position: absolute;
        top: 40%;
        left: 50%;
        transform: translate(-50%, -50%);
      }

      /* .video-position {
        height: 100%;
        width: 100%;
      } */

      #video-chat-container {
        width: 100%;
      }
     
      #local-conferencia {
        position: absolute;
        height: 29%;
        width: 27%;
        top: 74%;
        left: 0px;
        z-index:100;
      }
      

      #remote-video {
        width: 100%;
        height: 90%;
        display:none;
        max-width: 826px;
        max-height: 544px;
      }
      .fundo-local::before {
        
        content: "Câmera ainda não iniciada";
        color: white;
        border-width: 0 0.3em 0.25em 0;
        height: 4em;
        top: 1.3em;
        left: 14rem;
        margin-top: 9em;
        width: 13.5em;
        position: absolute;
        
      }
      .opcao  {
        display:block !important;
        position: fixed;
        top: 55%;
      }
      .embed-responsive{
        background-color: black;
      }
      .card-body{
        padding:0 !important;
      }
      ::-webkit-scrollbar {
        width: 5px;
        }

        ::-webkit-scrollbar-track {
        width: 5px;
        background: #f5f5f5;
        }

        ::-webkit-scrollbar-thumb {
        width: 1em;
        background-color: #ddd;
        outline: 1px solid slategrey;
        border-radius: 1rem;
        }
        #chat{
            height: 500px;
            width: 100%;
            overflow-y: scroll;
        }
        .opcao-video{
            padding-top: 0.83rem !important;
            padding-bottom: 0.83rem !important;
            position: absolute;
            right: 0;
            bottom: 0px;
        }
        .btn-circle.btn-xl {
            width: 40px;
            height: 40px;
            padding: 4px 5px;
            border-radius: 31px;
            font-size: 19px;
            line-height: 1.33;
        }
        
    @media (min-width: 1600px){
        #local-conferencia {
            position: absolute;
            height: 31%;
            width: 25%;
            top: 70.4%;
            left: 0px;
            z-index: 100;
        }
        #remote-video {
            width: 87%;
            height: 89%;
            margin-left: 65px;
        }
      }
      
      @media (min-width: 540px) and (max-width: 1500px){
        #local-conferencia {
            position: absolute;
            height: 27%;
            width: 25%;
            top: 76%;
            left: 0px;
            z-index:100;
            
        }
        .opcao{
            top: 331px;
        }
        #chat {
            height: 265px;
        }
        
      }
      @media (max-width: 540px){
        #local-conferencia {
            position: absolute;
            height: 27%;
            width: 25%;
            top: 77.1%;
            left: 0px;
            z-index:100;
            
        }
        #remote-video {
            width: 100%;
            height: 99%;
            padding-top: 40px;
            padding-bottom: 40px;
        }
        #col-chat{
            margin-bottom: 2rem;
        }
        
      }
      @media only screen and (max-width: 700px) and (min-width: 300px){
        #local-conferencia {
            position: absolute;
            height: 29%;
            width: 27%;
            top: 75.8%;
            left: 0px;
            z-index: 100;
        }
        #chat{
            height: 331px;
        }
        #remote-video {
            width: 100%;
            height: 93%;
            max-height: 389px;
        }
        .px-4{
            padding-left: 0 !important;
        }
        .opcao{
            top: 33%;
        }
        #msg{
            width: 440.8px !important;
            height: 304.99px !important;
        }
      }
      
     
</style>
<div class="row">
    <?php if(isset($medico)){?>
        <span class="card-title">Médico: <?=$medico->nome?></span>&nbsp;&nbsp;
        <span class="card-title">Clínica: <?=$medico->nomefantasia?></span>&nbsp;&nbsp;
        <span class="card-title">Especialidade: <?=$medico->especialidade?></span>&nbsp;
    <?php }else if(isset($paciente)){ ?>
        <span class="card-title mt-1 mb-1">Paciente: <?=$paciente->nome?></span>
    <?php }?>
</div>
<br>
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-md-12 row" id="room-selection-container">
                <div class="col-md-6 fundo-local d-flex justify-content-center">
                    <div class="embed-responsive embed-responsive-16by9 " >
                        <video class="local" autoplay="autoplay" muted="muted"></video>
                        
                    </div>
                    <div class="opcao">
                        <button class="btn btn-dark btn-circle btn-xl para-video"><i class="fas fa-video-slash"></i></button>
                        <button class="btn btn-dark btn-circle btn-xl para-audio"><i class="fas fa-microphone-slash"></i></button>
                    </div>
                </div>
                <div class="col-md-6 pt-5">
                    <h5 class="text-uppercase font-weight-bold">Só um momento!</h5>
                    <h4 class="">Precisamos ter acesso a sua câmera(webcam) e microfone do seu dispositivo</h4>
                    <h5 class="">para que a consulta aconteça precisamos ter acessos de ambos</h5>
                    <button class="btn btn-primary" id="connect-button">Entrar na sala</button>
                </div>
            </div>
            <div id="video-chat-container" class="video-position col-md-12" style="display: none">
                <div class="row">
                    <div class="col-md-8 bg-black p-0">
                        <div style="z-index:100;" class="bg-gradient-x-grey-blue w-100 mt-auto d-flex justify-content-end position-absolute">
                            <button onclick="sairdaSala('<?=$url?>')" class="btn btn-danger">Sair</button>
                        </div>
                        <div style="width: 100%;height: 90%;" class="d-flex justify-content-center align-items-center" id="msg">
                            <h5 class="text-white">Aguarde o outro participante</h5>
                        </div>
                        <video id="remote-video" autoplay="autoplay"></video>
                        <video class="local" id="local-conferencia" autoplay="autoplay" muted="muted"></video>
                        <div class="bg-gradient-x-grey-blue w-75 ml-auto d-flex justify-content-center mb-auto opcao-video align-self-center">
                            <button class="btn btn-dark btn-circle btn-xl para-video"><i class="fas fa-video-slash"></i></button>
                            <button class="btn btn-dark btn-circle btn-xl para-audio"><i class="fas fa-microphone-slash"></i></button>
                        </div>
                    </div>
                    <div class="col-md-4 rounded-lg shadow px-1 mt-2" id="col-chat">
                        <!-- Chat Box-->
                        <div class="col-12">
                            <div id="chat">
                                <div class="px-4 py-1 chat-box bg-white">
                                    

                                   
                                </div>
                            </div>

                            <!-- Typing area -->
                            <form action="#" id="mensagem-form">
                                <div class="input-group">
                                <input id="mensagem" type="text" placeholder="Digite um mensagem" class="form-control rounded-0 border-0">
                                <div class="input-group-append">
                                    <button id="button-addon2" type="submit" class="btn btn-link"> <i class="fa fa-paper-plane"></i></button>
                                </div>
                                </div>
                            </form>
                        </div>
                    </div>
               </div>
            </div>
            <div style="display: none" id="error">
                <div class="">
                    
                </div>
            </div>
        </div>
    </div>
</div>
<script src="<?=$this->request->getAttribute('webroot')?>/novo/app-assets/vendors/socket.io/dist/socket.io.min.js"></script>
<script>
   


    // DOM elements.
    const roomSelectionContainer = document.getElementById('room-selection-container')
    const roomInput = document.getElementById('room-input')
    const connectButton = document.getElementById('connect-button')

    const videoChatContainer = document.getElementById('video-chat-container')
    const localVideoComponent = document.getElementsByClassName('local')
    const remoteVideoComponent = document.getElementById('remote-video')

    // Variables.
    const socket = io("https://telemedicina-chat.herokuapp.com/")
    const mediaConstraints = {
    audio: true,
    video: { width: { min: 1024, ideal: 1280, max: 1280 }, height: { min: 576, ideal: 720, max: 720 }, facingMode: {exact:"user"},frameRate: { ideal: 10, max: 25,min:0 } },
    }
    let localStream
    let remoteStream
    let isRoomCreator
    let rtcPeerConnection // Connection between the local device and the remote peer.
    let roomId
    let localconnected
    //Criar objeto que vai conter os parametros
    var paramArray = {};
    // Free public STUN servers provided by Google.
    const iceServers = {
    iceServers: [
        { urls: 'stun:stun.l.google.com:19302' },
        { urls: 'stun:stun1.l.google.com:19302' },
        { urls: 'stun:stun2.l.google.com:19302' },
        { urls: 'stun:stun3.l.google.com:19302' },
        { urls: 'stun:stun4.l.google.com:19302' },
    ],
    }

    // BUTTON LISTENER ============================================================
    connectButton.addEventListener('click', async (e) => {
        var result = await setLocalStream(mediaConstraints);
        if(result){
            joinRoom(paramArray['sala'])
        }
    })
    $(document).ready(function () {
        $('#chat').attr({scrollTop: $('#chat').attr('scrollHeight')});
        paramArray['sala'] = "<?=$sala?>";
        setLocalStream(mediaConstraints,false)
        $("#mensagem-form").off().submit((e) => {
            e.preventDefault();
            if($("#mensagem").val() != ""){
                var now = new Date;
            let mensagem = $("#mensagem").val();
            let hora = now.getHours() + ":" + now.getMinutes();
            let data = now.toLocaleString("pt-BR",{month:"short",day:"numeric"})
            socket.emit('chat_enviar', {mensagem,hora,data,roomId})
            setMensagem({mensagem,hora,data},false)
            $("#mensagem").val("");
            }
        })
        $(".para-video").click(async () =>{

            localStream.getTracks().forEach((track) => {
                if (track.kind === 'video') {
                    track.enabled = !track.enabled;
                    if(!track.enabled){
                        $(".para-video").addClass("btn-danger")
                        $(".para-video").removeClass("btn-dark")
                    }else{
                        $(".para-video").removeClass("btn-danger")
                        $(".para-video").addClass("btn-dark")
                    }
                }
            })
        });
        $(".para-audio").click(async () =>{
            localStream.getTracks().forEach((track) => {
                if (track.kind === 'audio') {
                    track.enabled = !track.enabled;
                    if(!track.enabled){
                        $(".para-audio").addClass("btn-danger")
                        $(".para-audio").removeClass("btn-dark")
                    }else{
                        $(".para-audio").removeClass("btn-danger")
                        $(".para-audio").addClass("btn-dark")
                    }
                }
            })

        });
    });
    // SOCKET EVENT CALLBACKS =====================================================
    socket.on('room_created', async () => {
        console.log('Socket event callback: room_created')
        <?php if(isset($is_paciente)) {?>
            $(".chat-box").append(` <!-- Reciever Message-->
                                    <div class="media ml-auto">
                                        <div class="media-body">
                                            <div class="bg-warning rounded py-1 px-3 mb-0">
                                            <p class="text-small mb-0 text-white">O médico já vai entrar na sala, por favor aguarde!</p>
                                            </div>
                                            <p class="small text-muted mb-0"><?=date("H:i")?>| <?=date("d/m")?></p>
                                        </div>
                                    </div>`)
        <?php }else{?>
            $(".chat-box").append(` <!-- Reciever Message-->
                                    <div class="media ml-auto">
                                        <div class="media-body">
                                            <div class="bg-warning rounded py-1 px-3 mb-0">
                                            <p class="text-small mb-0 text-white">O paciente já vai entrar na sala, por favor aguarde!</p>
                                            </div>
                                            <p class="small text-muted mb-0"><?=date("H:i")?>| <?=date("d/m")?></p>
                                        </div>
                                    </div>`)
            <?php }?>
        await setLocalStream(mediaConstraints)
        isRoomCreator = true
    })

    socket.on('room_joined', async () => {
        console.log('Socket event callback: room_joined')
        $("#remote-video").css("display","block");
        $("#msg").attr("style","display: none !important");
        socket.emit('start_call', roomId)
        await setLocalStream(mediaConstraints)
        isRoomCreator = true
    })
    socket.on('chat_receber', async (event) => {
        setMensagem(event,true);
    })

    socket.on('full_room', () => {
        console.log('Socket event callback: full_room')

        alert('The room is full, please try another one')
    })

    socket.on('start_call', async () => {
        console.log('Socket event callback: start_call')
        $("#remote-video").css("display","block");
        $("#msg").attr("style","display: none !important");
        if (isRoomCreator) {
            rtcPeerConnection = new RTCPeerConnection(iceServers)
            addLocalTracks(rtcPeerConnection)
            rtcPeerConnection.ontrack = setRemoteStream
            rtcPeerConnection.onicecandidate = sendIceCandidate
            rtcPeerConnection.onconnectionstatechange = setState
            console.log(rtcPeerConnection)
            await createOffer(rtcPeerConnection)
        }
    })

    socket.on('webrtc_offer', async (event) => {
        console.log('Socket event callback: webrtc_offer')
        if (isRoomCreator) {
            rtcPeerConnection = new RTCPeerConnection(iceServers)
            addLocalTracks(rtcPeerConnection)
            rtcPeerConnection.ontrack = setRemoteStream
            rtcPeerConnection.onicecandidate = sendIceCandidate
            rtcPeerConnection.onconnectionstatechange = setState
            rtcPeerConnection.setRemoteDescription(new RTCSessionDescription(event))
            await createAnswer(rtcPeerConnection)
        }
    })

    socket.on('webrtc_answer', (event) => {
        console.log('Socket event callback: webrtc_answer')

        try {
            rtcPeerConnection.setRemoteDescription(new RTCSessionDescription(event))
        } catch (error) {
            document.location.reload(true);
        }
    })

    socket.on('webrtc_ice_candidate', (event) => {
        console.log('Socket event callback: webrtc_ice_candidate')

        // ICE candidate configuration.
        var candidate = new RTCIceCandidate({
            sdpMLineIndex: event.label,
            candidate: event.candidate,
            sdpMid:event.id
        })
        if(rtcPeerConnection){
            rtcPeerConnection.addIceCandidate(candidate)
        }else{
            socket.emit('start_call',roomId)
        }
    })
    socket.on("exit_call",() =>{
        console.log('Socket event callback: exit_call')
        window.location.href = '<?=$url?>'
    })


    // FUNCTIONS ==================================================================
    function joinRoom(room) {

        if (room === '') {
            $("#room-selection-container").css("display","none")
            $("#error").css("display","block")
        } else {
            roomId = room

            socket.emit('join', room,(response)=>{

            })
            socket.on('connect', function() {

            });
            socket.on('disconnect', function(){
            });
            showVideoConference()
        }
    }

    function showVideoConference() {
        roomSelectionContainer.style = 'display: none'
        videoChatContainer.style = 'display: block'
    }

    async function setLocalStream(mediaConstraints,is_force = true) {
       if(!isRoomCreator){
            let stream
            try {
                stream = await navigator.mediaDevices.getUserMedia(mediaConstraints)
            } catch (error) {
                console.log("FATAL ERROR ",error)
                console.log(error.name)
                if(error.name == "NotAllowedError" && is_force){
                    await Swal.fire({
                    title: 'A permissão da câmera e microfone foi desautorizada, precisamos dela para consulta',
                    showDenyButton: true,
                    showCancelButton: false,
                    confirmButtonText: `Pedir permissão`,
                    denyButtonText: `Cancelar`,
                    }).then(async (result) => {
                        /* Read more about isConfirmed, isDenied below */
                        if (result.value) {
                        await Swal.fire({
                            title:"preciso que você aperte no cadeado é alterar as permissões",
                            imageUrl: '<?=$this->request->getAttribute('webroot')?>novo/img/permissao.png',
                            imageHeight: 500,
                            imageAlt: 'Permissão'
                            }).then(async (result) => {
                                // var resu = await setLocalStream(mediaConstraints,false)
                                // if(!resu){
                                //     await Swal.fire({
                                //     icon: 'error',
                                //     title: 'Oops...',
                                //     text: 'A consulta não pode iniciar até você autorizar a câmera(webcam) e microfone'
                                //     })
                                // }
                            })
                        
                        }
                    })
                    is_force = false;
                }
                if(error.name == "AbortError"){
                    await Swal.fire({
                    title: 'A permissão da câmera e microfone está sendo usado por outro aplicativo/programa, por favor feche o aplicativo/programa',
                    showDenyButton: false,
                    showCancelButton: false,
                    confirmButtonText: `OK`,
                    })
                    is_force = false;
                }
            }
            if(localStream === undefined){
                localStream = stream
                localVideoComponent[0].srcObject = stream
                localVideoComponent[1].srcObject = stream
                
            }
       }
       return is_force;
    }

    function addLocalTracks(rtcPeerConnection) {
        localStream.getTracks().forEach((track) => {
            localconnected = rtcPeerConnection.addTrack(track, localStream)
        })
    }

    async function createOffer(rtcPeerConnection) {
        let sessionDescription
        try {
            sessionDescription = await rtcPeerConnection.createOffer()
            rtcPeerConnection.setLocalDescription(sessionDescription)
        } catch (error) {
            console.error(error)
        }

        socket.emit('webrtc_offer', {
            type: 'webrtc_offer',
            sdp: sessionDescription,
            roomId,
        })
    }

    async function createAnswer(rtcPeerConnection) {
        let sessionDescription
        try {
            sessionDescription = await rtcPeerConnection.createAnswer()
            rtcPeerConnection.setLocalDescription(sessionDescription)
        } catch (error) {
            console.error(error)
        }

        socket.emit('webrtc_answer', {
            type: 'webrtc_answer',
            sdp: sessionDescription,
            roomId,
        })
    }

    function setState(event) {
        var mensagem = false;
        switch(rtcPeerConnection.connectionState) { 
            case "disconnected":
                $("#remote-video").attr("style","display: none !important");
                $("#msg").attr("style","display: ;width: 100%;height: 90%;");
                mensagem = true
            break;
            case "failed":
                $("#remote-video").attr("style","display: none !important");
                $("#msg").attr("style","display: ;width: 100%;height: 90%;");
            break;

        }
       if(mensagem){
        var today = new Date();
        var day = today.getUTCDate() +"/"+today.getMonth();
        var time = today.getHours() + ":"+today.getMinutes();
        <?php if(isset($is_paciente)) {?>
            $(".chat-box").append(` <!-- Reciever Message-->
                                    <div class="media ml-auto">
                                        <div class="media-body">
                                            <div class="bg-warning rounded py-1 px-3 mb-0">
                                            <p class="text-small mb-0 text-white">O médico está tendo dificuldade com a internet, por favor aguarde!</p>
                                            </div>
                                            <p class="small text-muted mb-0">${time} | ${day}</p>
                                        </div>
                                    </div>`)
        <?php }else{?>
            $(".chat-box").append(` <!-- Reciever Message-->
                                    <div class="media ml-auto">
                                        <div class="media-body">
                                            <div class="bg-warning rounded py-1 px-3 mb-0">
                                            <p class="text-small mb-0 text-white">O paciente está tendo dificuldade com a internet, por favor aguarde!</p>
                                            </div>
                                            <p class="small text-muted mb-0">${time} | ${day}</p>
                                        </div>
                                    </div>`)
            <?php }?>
            $('#chat').animate({scrollTop:$('#chat').children().height()}); 
       }
    }

    function setRemoteStream(event) {
        remoteVideoComponent.srcObject = event.streams[0]
        remoteStream = event.streams[0]
    }

        function sendIceCandidate(event) {
            if (event.candidate) {
                socket.emit('webrtc_ice_candidate', {
                roomId,
                label: event.candidate.sdpMLineIndex,
                candidate: event.candidate.candidate,
                id:event.candidate.sdpMid,
                full:event.candidate
                })
            }
        }
    function setMensagem(event,is_recebido) {
        if(is_recebido){
            $(".chat-box").append(`<!-- Sender Message-->
                                    <div class="media ml-auto">
                                        <div class="media-body">
                                            <div class="bg-light rounded py-1 px-3 mb-0">
                                            <p class="text-small mb-0 text-muted">`+event.mensagem+`</p>
                                            </div>
                                            <p class="small text-muted mb-0">`+event.hora+ `| `+event.data+`</p>
                                        </div>
                                    </div>`)
        }else{
            $(".chat-box").append(` <!-- Reciever Message-->
                                    <div class="media ml-auto">
                                        <div class="media-body">
                                            <div class="bg-primary rounded py-1 px-3 mb-0">
                                            <p class="text-small mb-0 text-white">`+event.mensagem+`</p>
                                            </div>
                                            <p class="small text-muted mb-0">`+event.hora+ `| `+event.data+`</p>
                                        </div>
                                    </div>`)
        }
        $('#chat').animate({scrollTop:$('#chat').children().height()}); 
    }
    async function sairdaSala(url) {
        <?php if(!isset($is_paciente)) {?>
        Swal.fire({
            title: 'Se sair vamos constar como consulta realizada',
            showCancelButton: true,
            confirmButtonText: `Sair`,
            cancelButtonText:"ficar"
            }).then(async (result) => {
                /* Read more about isConfirmed, isDenied below */
                console.log(result.value)
                if (result.value) {
                    await socket.emit('exit_call', {type: 'exit_call',roomId})
                    window.location.href = url;
                } 
            })
        <?php }else{?>
            window.location.replace(url)
        <?php }?>
    }
</script>
