<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Chamado $chamado
 */
?>

<div class="card">
<div class="card-header">
		<h3>Criar</h3>
		<div class="float-right">
			<?= $this->Html->link('&nbsp;<i class="fa fa-bars" aria-hidden="true"></i> Listar', ['action' => 'index'], ['class'=>'btn btn-primary','escape'=>false]) ?>
		</div>
</div>
	
<div class="card-body">
    <?= $this->Form->create($chamado) ?>
	
			<label>Empresa solicitante</label>
			<select name="idempresa" class="form-control">
				<?php 
					foreach($empresas as $empresa){
						echo '<option value="'.$empresa->idempresa.'">'.$empresa->nome.'</option>';
					}
				?>
			</select>
			
			<?=$this->Form->control('solicitante',['class'=>'form-control']);?>
	
			<label>Atendente</label>
			<select name="idusuario_atendimento" class="form-control">
				<option value="">Nenhum</option>
				<?php 
					foreach($usuarios as $usuario){
						$selected = ($idusuario_atendimento==$usuario->idusuario?"selected":"");
						// echo '<option value="'.$usuario->idusuario.'">'.$usuario->nome.'</option>';
						echo "<option value='".$usuario->idusuario."' $selected>".$usuario->nome."</option>";
					}
				?>
			</select>
        <?php
            echo $this->Form->control('assunto',['class'=>'form-control']);
			echo "<label>Descrição</label>";
            echo $this->Form->textarea('descricao',['class'=>'form-control','label'=>'Descrição']);
		?>
			<label>Tipo</label>
			<select name="tipo" class="form-control">
				<option>0 - Não classificado</option>
				<option>1 - Análise</option>
				<option>2 - Correção</option>
				<option>3 - Melhoria</option>
				<option>4 - Implantação</option>
				<option>5 - Projeto</option>
				<option>6 - Consulta de dados</option>
				<option>7 - Liberação de acesso</option>
				<option>8 - Intercorrência</option>
			</select>

			<label>Status</label>
			<select name="idchamadostatus" class="form-control">
				<?php 
					foreach($chamadostatus as $status){
						echo '<option value="'.$status->idchamadostatus.'">'.$status->idchamadostatus.' - '.$status->descricao.'</option>';
					}
				?>
			</select>
			
			<label>Prioridade</label>
			<select name="prioridade" class="form-control">
				<option>0 - Não classificado</option>
				<option>1 - Muito baixa: atendimento para mais de 15 dias</option>
				<option>2 - Baixa: atendimento em até 15 dias</option>
				<option>3 - Média: atendimento em até 7 dias</option>
				<option>4 - Alta : atendimento em até 3 dias</option>
				<option>5 - Emergencial : atendimento imediato</option>
			</select>
			
			<label>Complexidade</label>
			<select name="complexidade" class="form-control">
				<option>1</option>
				<option>2</option>
				<option>3</option>
				<option>5</option>
				<option>8</option>
				<option>15</option>
				<option>21</option>
			</select>

			
		<?php
            echo $this->Form->control('data_prevista', ['type'=>'text','class'=>'form-control col-md-3','label'=>'Data Prevista', 'value'=> date('d/m/Y'), 'data-mask'=>'00/00/0000']);
            echo "<br>";
            echo $this->Form->control('horasprevistas',['class'=>'form-control col-md-2','label'=>'Horas Previstas', 'data-mask'=>'00.00', 'data-mask-selectonfocus'=>'true']);
			echo $this->Form->control('idchamadopai',['class'=>'form-control','label'=>'Id Chamado Pai']);
			echo $this->Form->control('idglpi',['class'=>'form-control','label'=>'Id GLPI']);
        ?>
		<label>Projeto</label>
		<select name="idprojeto" class="form-control">
			<?php 
					echo '<option value="'.$projetos->idprojeto.'">'.$projetos->nome.'</option>';
			?>
		</select>

		<label>Produto</label>
		<select name="idproduto" class="form-control">
			<option value="">Nenhum</option>
			<?php 
				foreach($produtos as $produto){
					echo '<option value="'.$produto->idproduto.'">'.$produto->grupo .' | '. $produto->subgrupo .' | '. $produto->nome.'</option>';
				}
			?>
		</select>

	
    <br><br>
    <?= $this->Form->button(__('Enviar'),['class'=>'btn btn-primary']) ?>
    <?= $this->Form->end() ?>
</div>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.13.4/jquery.mask.min.js"></script>