<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Chamado $chamado
 */
?>
<div class="card">
<div class="card-header">
		<h3>Editar Chamado <?=$chamado->idchamado?></h3>
		<div class="float-right">
			<?= $this->Html->link('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar', ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?>
			<?= $this->Html->link('&nbsp;<i class="fa fa-bars" aria-hidden="true"></i> Listar', ['action' => 'index'], ['class'=>'btn btn-primary','escape'=>false]) ?>
			<?= $this->Html->link('&nbsp;<i class="fa fa-eye fa-2" aria-hidden="true"></i>  Ver', ['action' => 'view', $chamado->idchamado], ['class'=>'btn btn-primary','escape'=>false]) ?> 
		</div>
</div>
	
<div class="card-body">
    <?= $this->Form->create($chamado) ?>
		<label>Empresa</label>
		<select name="idempresa" class="form-control">
			<option value="">Nenhuma</option>
			<?php 
				$selected = "";
				foreach($empresas as $item){?>
				<?php if($item->idempresa == $chamado->idempresa){$selected = "selected";}else{$selected = "";}?>
				<option value="<?=$item->idempresa?>" <?=$selected?>><?=$item->nome?> - <?=$item->idempresa?></option>
			<?php } ?>
		</select>
		
		<?=$this->Form->control('solicitante',['class'=>'form-control']);?>
		
		<label>Atendente</label>
		<select name="idusuario_atendimento" class="form-control">
			<option value="">Nenhum</option>
			<?php 
				$selected = "";
				foreach($usuarios as $item){?>
				<?php if($item->idusuario == $chamado->idusuario_atendimento){$selected = "selected";}else{$selected = "";}?>
				<option value="<?=$item->idusuario?>" <?=$selected?>><?=$item->nome?> - <?=$item->idusuario?></option>
			<?php } ?>
		</select>
		
		<?php
            echo $this->Form->control('assunto',['class'=>'form-control']);
			echo "<label>Descrição</label>";
            echo $this->Form->textarea('descricao',['class'=>'form-control','label'=>'Descrição']);
			echo "<label>Justificativa</label>";
            echo $this->Form->textarea('justificativa',['class'=>'form-control']);
		?>
		<label>Tipo</label>
			<select name="tipo" class="form-control">
				<option <?php if($chamado->tipo == "0 - Não classificado"){echo "selected";}?>>0 - Não classificado</option>
				<option <?php if($chamado->tipo == "1 - Análise"){echo "selected";}?>>1 - Análise</option>
				<option <?php if($chamado->tipo == "2 - Correção"){echo "selected";}?>>2 - Correção</option>
				<option <?php if($chamado->tipo == "3 - Melhoria"){echo "selected";}?>>3 - Melhoria</option>
				<option <?php if($chamado->tipo == "4 - Implantação"){echo "selected";}?>>4 - Implantação</option>
				<option <?php if($chamado->tipo == "5 - Projeto"){echo "selected";}?>>5 - Projeto</option>
				<option <?php if($chamado->tipo == "6 - Consulta de dados"){echo "selected";}?>>6 - Consulta de dados</option>
				<option <?php if($chamado->tipo == "7 - Liberação de acesso"){echo "selected";}?>>7 - Liberação de acesso</option>
				<option <?php if($chamado->tipo == "8 - Intercorrência"){echo "selected";}?>>8 - Intercorrência</option>
			</select>
			
			<label>Status</label>
		<select name="idchamadostatus" class="form-control">
			<?php 
				$selected = "";
				foreach($chamadostatus as $item){?>
				<?php if($item->idchamadostatus == $chamado->idchamadostatus){$selected = "selected";}else{$selected = "";}?>
				<option value="<?=$item->idchamadostatus?>" <?=$selected?>><?=$item->idchamadostatus?> - <?=$item->descricao?></option>
			<?php } ?>
		</select>
			
			<label>Prioridade</label>
			<select name="prioridade" class="form-control">
				<option <?php if($chamado->prioridade == "0 - Não classificado"){echo "selected";}?>>0 - Não classificado</option>
				<option <?php if($chamado->prioridade == "1 - Muito baixa: atendimento para mais de 15 dias"){echo "selected";}?>>1 - Muito baixa: atendimento para mais de 15 dias</option>
				<option <?php if($chamado->prioridade == "2 - Baixa: atendimento em até 15 dias"){echo "selected";}?>>2 - Baixa: atendimento em até 15 dias</option>
				<option <?php if($chamado->prioridade == "3 - Média: atendimento em até 7 dias"){echo "selected";}?>>3 - Média: atendimento em até 7 dias</option>
				<option <?php if($chamado->prioridade == "4 - Alta : atendimento em até 3 dias"){echo "selected";}?>>4 - Alta : atendimento em até 3 dias</option>
				<option <?php if($chamado->prioridade == "5 - Emergencial : atendimento imediato"){echo "selected";}?>>5 - Emergencial : atendimento imediato</option>
			</select>
			
			<label>Complexidade</label>
			<select name="complexidade" class="form-control">
				<option <?php if($chamado->complexidade == "1"){echo "selected";}?>>1</option>
				<option <?php if($chamado->complexidade == "2"){echo "selected";}?>>2</option>
				<option <?php if($chamado->complexidade == "3"){echo "selected";}?>>3</option>
				<option <?php if($chamado->complexidade == "5"){echo "selected";}?>>5</option>
				<option <?php if($chamado->complexidade == "8"){echo "selected";}?>>8</option>
				<option <?php if($chamado->complexidade == "13"){echo "selected";}?>>13</option>
				<option <?php if($chamado->complexidade == "21"){echo "selected";}?>>21</option>
			</select>
			
			<br>
        <?php
            echo $this->Form->control('data_prevista', ['empty' => true]);
            echo $this->Form->control('horasprevistas',['class'=>'form-control col-md-3','label'=>'Horas Previstas']);
			echo $this->Form->control('idchamadopai',['class'=>'form-control','label'=>'Id Chamado Pai']);
			echo $this->Form->control('idglpi',['class'=>'form-control','label'=>'Id GLPI']);
        ?>
		<label>Projeto</label>
		<select name="idprojeto" class="form-control">
			<option value="">Nenhum</option>
			<?php 
				foreach($projetos as $item){
					$selected = ($chamado->idprojeto==$item->idprojeto)?"selected":"";
					echo "<option value='".$item->idprojeto."' $selected>".$item->nome."</option>";
				}
			?>
		</select>

		<label>Produto</label>
		<select name="idproduto" class="form-control">
			<option value="">Nenhum</option>
			<?php 
				foreach($produtos as $item){
					$selected = ($chamado->idproduto==$item->idproduto)?"selected":"";
					echo "<option value='".$item->idproduto."' $selected>".$item->grupo .' | '. $item->subgrupo .' | '. $item->nome."</option>";
				}
			?>
		</select>
		
	
    <br><br>
    <?= $this->Form->button(__('Enviar'),['class'=>'btn btn-primary']) ?>
    <?= $this->Form->end() ?>
</div>
</div>
