<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Chamado[]|\Cake\Collection\CollectionInterface $chamado
 */
?>
<style>
.scrolling-wrapper {
      display: flex;
      flex-wrap: nowrap;
      -webkit-overflow-scrolling: touch;
  }
.animate{
	transform: translate3d(0,0,0,);
	opacity: 0.5;
}

</style>


<div class="row">
	<div class="col-md-6" id="divaparecer"></div>
	<div class="col-md-12" id="divesconder" data-anime="left">
<div class="card">
<div class="card-header">
	<h3><?= __('Chamados') ?></h3>
	<div class="float-right">
		<button onclick="abrircriar()" type="button" class="btn btn-primary"><i class="fa fa-plus"></i> Criar</button>
		<?= $this->Html->link('&nbsp;<i class="fa fa-exclamation-triangle fa-2" aria-hidden="true"></i> Intercorrência', ['action' => 'intercorrencia'],['class'=>'btn btn-primary','escape'=>false]) ?>
	</div>
</div>
<div class="card-body">
	<form method="POST">
		<div class="row">

			<div class="col-md-2">
				<b>Atendente:</b>
				<select name="idusuario_atendimento" class="form-control">
					<option value="-1">.: TODOS :.</option>
					<?php
						foreach($usuarios as $usuario){
							$selected = ($idusuario_atendimento==$usuario->idusuario?"selected":"");
							echo "<option value='".$usuario->idusuario."' $selected>".$usuario->nome."</option>";
						}
					?>
				</select>
			</div>
			<div class="col-md-2">
				<b>Empresa:</b>
				<select name="idempresa" class="form-control">
					<option value="-1">.: TODOS :.</option>
					<?php
						foreach($empresas as $empresa){
							$selected = ($idempresa==$empresa->idempresa?"selected":"");
							echo "<option value='".$empresa->idempresa."' $selected>".$empresa->nome."</option>";
						}
					?>
				</select>
			</div>

			<div class="col-md-3">
				<b>Projeto:</b>
				<select name="idprojeto" class="form-control">
					<option value="-1">.: TODOS :.</option>
					<?php
						foreach($projetos as $projeto){
							$selected = ($idprojeto==$projeto->idprojeto?"selected":"");
							echo "<option value='".$projeto->idprojeto."' $selected>".$projeto->nome."</option>";
						}
					?>
				</select>
			</div>

			<div class="col-md-2">
				<b>Situação Projeto:</b>
				<select name="situacaoprojeto" class="form-control">
					<?php
							$selected = ($situacaoprojeto==$projeto->situacaoprojeto?"selected":"");
							echo "<option value='3 - Aprovado' $selected>"."Aprovado"."</option>";
							echo "<option value='' $selected>".".: TODOS :."."</option>";

					?>


				</select>
			</div>

			<div class="col-md-2">
				<b>Tipo Projeto:</b>
				<select name="tipoprojeto" class="form-control">
					<option value="" <?= ($tipoprojeto == '')? 'selected' :''?> >.: TODOS :.</option>
					<option value="SLA" <?= ($tipoprojeto == 'SLA')? 'selected' :''?> >SLA</option>
					<option value="SLR" <?= ($tipoprojeto == 'SLR')? 'selected' :''?> >SLR</option>

				</select>
			</div>

			<div class="col-md-1">
				<br>
				<button class="btn btn-primary" type="submit" >Enviar</button>
			</div>
		</div>
	</form>
	<br>
	<div class="row">
	<div style="overflow: auto;max-height:500px;">
	<div class="scrolling-wrapper">
		<div id="div1" class="col-md-3" style="background: rgb(242, 222, 222);padding-top:5px; min-width: 250px">
			<h5><a href="javascript:void(0);" onclick="ToggleBox();"><i class="fa fa-minus-square" aria-hidden="true"></i></a> Pendentes (<?=$totalpendentes?>)</h5>
			<ul style="font-size:10px;padding:0px">
			<?php foreach($pendentes as $chamadopainel){?>
			<hr>
				<div class="pull-right" style="margin-top: -10px;">
					<?= $this->Html->link('<i class="fa fa-arrow-right" aria-hidden="true"></i>', ['action' => 'planejado',$chamadopainel->idchamado],['class'=>'btn btn-primary btn-sm','escape'=>false]) ?>
						<div style="margin-top: 2px;"></div>
						<?= $this->Html->link('<i class="fa fa-times" aria-hidden="true"></i>', ['action' => 'cancelar',$chamadopainel->idchamado],['class'=>'btn btn-danger btn-sm','escape'=>false]) ?>
						<div style="margin-top: 2px;"></div>
                        <?= $this->Html->link('<i class="fa fa-pause" aria-hidden="true"></i>', ['action' => 'suspenso',$chamadopainel->idchamado],['class'=>'btn btn-warning btn-sm','escape'=>false]) ?>
						<div style="margin-top: 2px;"></div>
						<button onclick="addComent(<?=$chamadopainel->idchamado?>)" type="button" class="btn btn-sm" data-toggle="modal" data-target=".bs-example-modal-sm" style="background-color: #4287f5; color: #ffffff;"><i class="fa fa-comment" aria-hidden="true" style="font-size: 10px"></i></button>
				</div>
				<li title="<?=$chamadopainel->descricao?>" style="cursor:pointer" onclick="window.open('chamado/view/<?=$chamadopainel->idchamado?>')">
					<b>
						<?=$chamadopainel->idchamado?> -
						<?php
						$date=date_create($chamadopainel->data_criacao);
						echo date_format($date,"d/m/Y H:i:s");
						?>
					</b>
					<br>
					<b><?=$chamadopainel->assunto?></b>
					<br>
					Tipo: <?=$chamadopainel->tipo?>
					<br>
					Prioridade: <?=$chamadopainel->prioridade?>
					<br>
					Empresa: <?=($chamadopainel->idempresa)?$this->Custom->get('empresa','idempresa',$chamadopainel->idempresa)->nome:''?>
					<br>
					Atendente: <?=($chamadopainel->idusuario_atendimento)?$this->Custom->get('usuario','idusuario',$chamadopainel->idusuario_atendimento)->nome:''?>
					<br>
					Projeto: <?=($chamadopainel->idprojeto)?$this->Custom->get('projeto','idprojeto',$chamadopainel->idprojeto)->nome:''?>
				</li>
			<?php } ?>
			</ul>
		</div>
		<div id="div2" class="col-md-3" style="background: rgb(218, 206, 255);padding-top:5px; min-width: 250px">
			<h5><a href="javascript:void(0);" onclick="ToggleBox2();"><i class="fa fa-minus-square" aria-hidden="true"></i></a> Planejados (<?=$totalplanejados?>)</h5>
			<ul style="font-size:10px;padding:0px">
			<?php foreach($planejados as $chamadopainel){?>
			<hr>
				<div class="pull-right" style="margin-top: -10px;">
					<?= $this->Html->link('<i class="fa fa-arrow-right" aria-hidden="true"></i>', ['action' => 'ematendimento',$chamadopainel->idchamado],['class'=>'btn btn-primary btn-sm','escape'=>false]) ?>
						<div style="margin-top: 2px;"></div>
						<?= $this->Html->link('<i class="fa fa-arrow-left" aria-hidden="true"></i>', ['action' => 'pendente',$chamadopainel->idchamado],['class'=>'btn btn-primary btn-sm','escape'=>false]) ?>
						<div style="margin-top: 2px;"></div>
                        <?= $this->Html->link('<i class="fa fa-pause" aria-hidden="true"></i>', ['action' => 'suspenso',$chamadopainel->idchamado],['class'=>'btn btn-warning btn-sm','escape'=>false]) ?>
						<div style="margin-top: 2px;"></div>
						<?= $this->Html->link('<i class="fa fa-times" aria-hidden="true"></i>', ['action' => 'cancelar',$chamadopainel->idchamado],['class'=>'btn btn-danger btn-sm','escape'=>false]) ?>
						<div style="margin-top: 2px;"></div>
						<button onclick="addComent(<?=$chamadopainel->idchamado?>)" type="button" class="btn btn-sm" data-toggle="modal" data-target=".bs-example-modal-sm" style="background-color: #4287f5; color: #ffffff;"><i class="fa fa-comment" aria-hidden="true" style="font-size: 10px"></i></button>
				</div>
				<li title="<?=$chamadopainel->descricao?>" style="cursor:pointer" onclick="window.open('chamado/view/<?=$chamadopainel->idchamado?>')">
					<b>
						<?=$chamadopainel->idchamado?> -
						<?php
						$date=date_create($chamadopainel->data_criacao);
						echo date_format($date,"d/m/Y H:i:s");
						?>
					</b>
					<br>
					<b><?=$chamadopainel->assunto?></b>
					<br>
					Tipo: <?=$chamadopainel->tipo?>
					<br>
					Prioridade: <?=$chamadopainel->prioridade?>
					<br>
					Empresa: <?=($chamadopainel->idempresa)?$this->Custom->get('empresa','idempresa',$chamadopainel->idempresa)->nome:''?>
					<br>
					Atendente: <?=($chamadopainel->idusuario_atendimento)?$this->Custom->get('usuario','idusuario',$chamadopainel->idusuario_atendimento)->nome:''?>
					<br>
					Projeto: <?=($chamadopainel->idprojeto)?$this->Custom->get('projeto','idprojeto',$chamadopainel->idprojeto)->nome:''?>
				</li>
			<?php } ?>
			</ul>
		</div>
		<div id="div3" class="col-md-3" style="background: rgb(252, 248, 227);padding-top:5px; min-width: 250px">
			<h5><a href="javascript:void(0);" onclick="ToggleBox3();"><i class="fa fa-minus-square" aria-hidden="true"></i></a> Em Atendimento (<?=$totalematendimento?>)</h5>

			<ul style="font-size:10px;padding:0px">
				<?php foreach($ematendimento as $chamadopainel){?>
					<hr>
					<div class="pull-right" style="margin-top: -10px;">
					<?= $this->Html->link('<i class="fa fa-arrow-left" aria-hidden="true"></i>', ['action' => 'planejado',$chamadopainel->idchamado],['class'=>'btn btn-primary btn-sm','escape'=>false]) ?>
						<div style="margin-top: 2px;"></div>
						<?= $this->Html->link('<i class="fa fa-arrow-right" aria-hidden="true"></i>', ['action' => 'homologacao',$chamadopainel->idchamado],['class'=>'btn btn-primary btn-sm','escape'=>false]) ?>
						<div style="margin-top: 2px;"></div>
                        <?= $this->Html->link('<i class="fa fa-pause" aria-hidden="true"></i>', ['action' => 'suspenso',$chamadopainel->idchamado],['class'=>'btn btn-warning btn-sm','escape'=>false]) ?>
						<div style="margin-top: 2px;"></div>
						<?= $this->Html->link('<i class="fa fa-times" aria-hidden="true"></i>', ['action' => 'cancelar',$chamadopainel->idchamado],['class'=>'btn btn-danger btn-sm','escape'=>false]) ?>
						<div style="margin-top: 2px;"></div>
						<button onclick="addComent(<?=$chamadopainel->idchamado?>)" type="button" class="btn btn-sm" data-toggle="modal" data-target=".bs-example-modal-sm" style="background-color: #4287f5; color: #ffffff;"><i class="fa fa-comment" aria-hidden="true" style="font-size: 10px"></i></button>

					</div>
				<li title="<?=$chamadopainel->descricao?>" style="cursor:pointer" onclick="window.open('chamado/view/<?=$chamadopainel->idchamado?>')">
					<b>
						<?=$chamadopainel->idchamado?> -
						<?php
						$date=date_create($chamadopainel->data_criacao);
						echo date_format($date,"d/m/Y H:i:s");
						?>
					</b>
					<br>
					<!-- <div class="progress mt-1 mb-0" style="height: 12px;margin:0px !important">
						<div class="progress-bar bg-primary" role="progressbar" style="margin-right:5px; width: <?=$chamadopainel->percentual?>%" aria-valuenow="<?=$chamadopainel->percentual?>" aria-valuemin="0" aria-valuemax="100">
						<?=$chamadopainel->percentual?>%
						</div>
					</div> -->
					<b><?=$chamadopainel->assunto?></b>
					<br>
					Tipo: <?=$chamadopainel->tipo?>
					<br>
					Prioridade: <?=$chamadopainel->prioridade?>
					<br>
					Empresa: <?=($chamadopainel->idempresa)?$this->Custom->get('empresa','idempresa',$chamadopainel->idempresa)->nome:''?>
					<br>
					Atendente: <?=($chamadopainel->idusuario_atendimento)?$this->Custom->get('usuario','idusuario',$chamadopainel->idusuario_atendimento)->nome:''?>
					<br>
					Projeto: <?=($chamadopainel->idprojeto)?$this->Custom->get('projeto','idprojeto',$chamadopainel->idprojeto)->nome:''?>
				</li>
				<?php } ?>
			</ul>
		</div>

		<div id="div4" class="col-md-3" style="background: rgb(153, 243, 255);padding-top:5px; min-width: 250px">
			<h5><a href="javascript:void(0);" onclick="ToggleBox4();"><i class="fa fa-minus-square" aria-hidden="true"></i></a> Em Homologação (<?=$totalhomologacao?>)</h5>

			<ul style="font-size:10px;padding:0px">
				<?php foreach($homologacao as $chamadopainel){?>
					<hr>
					<div class="pull-right" style="margin-top: -10px;">
					<?= $this->Html->link('<i class="fa fa-arrow-left" aria-hidden="true"></i>', ['action' => 'ematendimento',$chamadopainel->idchamado],['class'=>'btn btn-primary btn-sm','escape'=>false]) ?>
						<div style="margin-top: 2px;"></div>
						<?= $this->Html->link('<i class="fa fa-arrow-right" aria-hidden="true"></i>', ['action' => 'entregue',$chamadopainel->idchamado],['class'=>'btn btn-primary btn-sm','escape'=>false]) ?>
						<div style="margin-top: 2px;"></div>
                        <?= $this->Html->link('<i class="fa fa-pause" aria-hidden="true"></i>', ['action' => 'suspenso',$chamadopainel->idchamado],['class'=>'btn btn-warning btn-sm','escape'=>false]) ?>
						<div style="margin-top: 2px;"></div>
						<?= $this->Html->link('<i class="fa fa-times" aria-hidden="true"></i>', ['action' => 'cancelar',$chamadopainel->idchamado],['class'=>'btn btn-danger btn-sm','escape'=>false]) ?>
						<div style="margin-top: 2px;"></div>
						<button onclick="addComent(<?=$chamadopainel->idchamado?>)" type="button" class="btn btn-sm" data-toggle="modal" data-target=".bs-example-modal-sm" style="background-color: #4287f5; color: #ffffff;"><i class="fa fa-comment" aria-hidden="true" style="font-size: 10px"></i></button>

					</div>
				<li title="<?=$chamadopainel->descricao?>" style="cursor:pointer" onclick="window.open('chamado/view/<?=$chamadopainel->idchamado?>')">
					<b>
						<?=$chamadopainel->idchamado?> -
						<?php
						$date=date_create($chamadopainel->data_criacao);
						echo date_format($date,"d/m/Y H:i:s");
						?>
					</b>
					<br>
					<b><?=$chamadopainel->assunto?></b>
					<br>
					Tipo: <?=$chamadopainel->tipo?>
					<br>
					Prioridade: <?=$chamadopainel->prioridade?>
					<br>
					Empresa: <?=($chamadopainel->idempresa)?$this->Custom->get('empresa','idempresa',$chamadopainel->idempresa)->nome:''?>
					<br>
					Atendente: <?=($chamadopainel->idusuario_atendimento)?$this->Custom->get('usuario','idusuario',$chamadopainel->idusuario_atendimento)->nome:''?>
					<br>
					Projeto: <?=($chamadopainel->idprojeto)?$this->Custom->get('projeto','idprojeto',$chamadopainel->idprojeto)->nome:''?>
				</li>
				<?php } ?>
			</ul>
		</div>
		<div id="div5" class="col-md-3" style="background:rgb(223, 240, 216);padding-top:5px; min-width: 250px">
			<h5><a href="javascript:void(0);" onclick="ToggleBox5();"><i class="fa fa-minus-square" aria-hidden="true"></i></a> Entregues (<?=$totalentregues?>)</h5>
			<ul style="font-size:10px;padding:0px">
			<?php foreach($entregues as $chamadopainel){?>
			<hr>
				<div class="pull-right" style="margin-top: -10px;">
					<?= $this->Html->link('<i class="fa fa-arrow-left" aria-hidden="true"></i>', ['action' => 'ematendimento',$chamadopainel->idchamado],['class'=>'btn btn-warning btn-sm','escape'=>false]) ?>
					<div style="margin-top: 2px;"></div>
						<?= $this->Html->link('<i class="fa fa-arrow-right" aria-hidden="true"></i>', ['action' => 'finalizado',$chamadopainel->idchamado],['class'=>'btn btn-primary btn-sm','escape'=>false]) ?>
						<div style="margin-top: 2px;"></div>

				</div>
				<li title="<?=$chamadopainel->descricao?>" style="cursor:pointer" onclick="window.open('chamado/view/<?=$chamadopainel->idchamado?>')">
					<b>
						<?=$chamadopainel->idchamado?> -
						<?php
						$date=date_create($chamadopainel->data_criacao);
						echo date_format($date,"d/m/Y H:i:s");
						?>
					</b>
					<br>
					<b><?=$chamadopainel->assunto?></b>
					<br>
					Tipo: <?=$chamadopainel->tipo?>
					<br>
					Prioridade: <?=$chamadopainel->prioridade?>
					<br>
					Empresa: <?=($chamadopainel->idempresa)?$this->Custom->get('empresa','idempresa',$chamadopainel->idempresa)->nome:''?>
					<br>
					Atendente: <?=($chamadopainel->idusuario_atendimento)?$this->Custom->get('usuario','idusuario',$chamadopainel->idusuario_atendimento)->nome:''?>
					<br>
					Projeto: <?=($chamadopainel->idprojeto)?$this->Custom->get('projeto','idprojeto',$chamadopainel->idprojeto)->nome:''?>
				</li>
			<?php } ?>
			</ul>
		</div>

		<div id="div8" class="col-md-3" style="background:rgb(195, 195, 195);padding-top:5px; min-width: 250px">
			<h5><a href="javascript:void(0);" onclick="ToggleBox8();"><i class="fa fa-minus-square" aria-hidden="true"></i></a> Finalizados (<?=$totalfinalizados?>)</h5>
			<ul style="font-size:10px;padding:0px">
			<?php foreach($finalizados as $chamadopainel){?>
			<hr>
				<div class="pull-right" style="margin-top: -10px;">


				</div>
				<li title="<?=$chamadopainel->descricao?>" style="cursor:pointer" onclick="window.open('chamado/view/<?=$chamadopainel->idchamado?>')">
					<b>
						<?=$chamadopainel->idchamado?> -
						<?php
						$date=date_create($chamadopainel->data_criacao);
						echo date_format($date,"d/m/Y H:i:s");
						?>
					</b>
					<br>
					<b><?=$chamadopainel->assunto?></b>
					<br>
					Tipo: <?=$chamadopainel->tipo?>
					<br>
					Prioridade: <?=$chamadopainel->prioridade?>
					<br>
					Empresa: <?=($chamadopainel->idempresa)?$this->Custom->get('empresa','idempresa',$chamadopainel->idempresa)->nome:''?>
					<br>
					Atendente: <?=($chamadopainel->idusuario_atendimento)?$this->Custom->get('usuario','idusuario',$chamadopainel->idusuario_atendimento)->nome:''?>
					<br>
					Projeto: <?=($chamadopainel->idprojeto)?$this->Custom->get('projeto','idprojeto',$chamadopainel->idprojeto)->nome:''?>
				</li>
			<?php } ?>
			</ul>
		</div>

		<div id="div6" class="col-md-3" style="background:rgb(255, 209, 153);padding-top:5px; min-width: 250px">
			<h5><a href="javascript:void(0);" onclick="ToggleBox6();"><i class="fa fa-minus-square" aria-hidden="true"></i></a> Suspensos (<?=$totalsuspensos?>)</h5>
			<ul style="font-size:10px;padding:0px">
			<?php foreach($suspensos as $chamadopainel){?>
			<hr>
				<div class="pull-right" style="margin-top: -10px;">
					<?= $this->Html->link('<i class="fa fa-arrow-left" aria-hidden="true"></i>', ['action' => 'ematendimento',$chamadopainel->idchamado],['class'=>'btn btn-warning btn-sm','escape'=>false]) ?>
					<div style="margin-top: 2px;"></div>
						<?= $this->Html->link('<i class="fa fa-times" aria-hidden="true"></i>', ['action' => 'cancelar',$chamadopainel->idchamado],['class'=>'btn btn-danger btn-sm','escape'=>false]) ?>

				</div>
				<li title="<?=$chamadopainel->descricao?>" style="cursor:pointer" onclick="window.open('chamado/view/<?=$chamadopainel->idchamado?>')">
					<b>
						<?=$chamadopainel->idchamado?> -
						<?php
						$date=date_create($chamadopainel->data_criacao);
						echo date_format($date,"d/m/Y H:i:s");
						?>
					</b>
					<br>
					<b><?=$chamadopainel->assunto?></b>
					<br>
					Tipo: <?=$chamadopainel->tipo?>
					<br>
					Prioridade: <?=$chamadopainel->prioridade?>
					<br>
					Empresa: <?=($chamadopainel->idempresa)?$this->Custom->get('empresa','idempresa',$chamadopainel->idempresa)->nome:''?>
					<br>
					Atendente: <?=($chamadopainel->idusuario_atendimento)?$this->Custom->get('usuario','idusuario',$chamadopainel->idusuario_atendimento)->nome:''?>
					<br>
					Projeto: <?=($chamadopainel->idprojeto)?$this->Custom->get('projeto','idprojeto',$chamadopainel->idprojeto)->nome:''?>
				</li>
			<?php } ?>
			</ul>
		</div>

		<div id="div7" class="col-md-3" style="background:rgb(255, 174, 162);padding-top:5px; min-width: 250px">
			<h5><a href="javascript:void(0);" onclick="ToggleBox7();"><i class="fa fa-minus-square" aria-hidden="true"></i></a> Cancelados (<?=$totalcancelados?>)</h5>
			<ul style="font-size:10px;padding:0px">
			<?php foreach($cancelados as $chamadopainel){?>
			<hr>
				<div class="pull-right" style="margin-top: -10px;">


				</div>
				<li title="<?=$chamadopainel->descricao?>" style="cursor:pointer" onclick="window.open('chamado/view/<?=$chamadopainel->idchamado?>')">
					<b>
						<?=$chamadopainel->idchamado?> -
						<?php
						$date=date_create($chamadopainel->data_criacao);
						echo date_format($date,"d/m/Y H:i:s");
						?>
					</b>
					<br>
					<b><?=$chamadopainel->assunto?></b>
					<br>
					Empresa: <?=($chamadopainel->idempresa)?$this->Custom->get('empresa','idempresa',$chamadopainel->idempresa)->nome:''?>
					<br>
					Atendente: <?=($chamadopainel->idusuario_atendimento)?$this->Custom->get('usuario','idusuario',$chamadopainel->idusuario_atendimento)->nome:''?>
					<br>
					Projeto: <?=($chamadopainel->idprojeto)?$this->Custom->get('projeto','idprojeto',$chamadopainel->idprojeto)->nome:''?>
				</li>
			<?php } ?>
			</ul>
		</div>

		<div class="modal fade bs-example-modal-sm" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
            <div class="modal-dialog modal-sm" role="document">
                <div class="modal-content">
                    <div style="margin:50px">
                        <form action="" method="POST" enctype="multipart/form-data">
                            <input type="hidden" name="chamadoidmodal" id="chamadoidmodal" value="" />
                            <textarea placeholder="observação" class="form-control" name="observacao" maxlength="8000"></textarea>
                            <div style="margin-top:5px; margin-bottom: 15px; ">
                                <a data-toggle="collapse" href="#collapseExample" aria-expanded="false" aria-controls="collapseExample">
                                    <i class="fa fa-plus-circle" aria-hidden="true"></i> <spam data-toggle="tooltip" data-placement="top" title="Campo expresso em horas. Ex.: 01.50 equivale a 01h:30m">Adicionar Horas Trabalhadas</spam>
                                </a>
                                <div class="collapse" id="collapseExample">
                                    <div class="well">
                                        <div class="form-group">
                                            <input type="text" name="horastrabalhadas" class="form-control col-md-6" data-mask="00.00" data-mask-selectonfocus="true" >
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <input type="hidden" name="MAX_FILE_SIZE" value="10485760" />
                                    <input name='arquivo' type='file'/>
                            <br><br>
                            <?= $this->Form->button(__('Cadastrar observação'),['class'=>'btn btn-primary']) ?>
                        </form>
                    </div>
                </div>
            </div>
        </div>

	</div>
	</div>
</div>
	<br><br>
	<h5>Últimos Chamados</h5>
    <table style="font-size:10px" class="table table-responsive table-striped datatable" cellpadding="0" cellspacing="0">
        <thead>
            <tr>
                <th scope="col">Cód</th>
				<th scope="col">Empresa</th>
				<th scope="col">Projeto</th>
                <th scope="col">Atendente</th>
                <th scope="col">Assunto</th>
                <th scope="col">Status</th>
                <!-- <th scope="col">Percentual</th> -->
				<th scope="col">Data Prevista</th>
				<th scope="col">Horas Previstas</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($chamado as $chamado): ?>
            <tr style="cursor:pointer" onclick="window.open('chamado/view/<?=$chamado->idchamado?>')">
                <td><?= $this->Number->format($chamado->idchamado) ?></td>
                <td><?php
					if(strlen($chamado->idempresa) > 0){
						echo $chamado->idempresa." - ".$this->Custom->get('empresa','idempresa',$chamado->idempresa)->nome;
					}
				?></td>
				<td><?php
					if(strlen($chamado->idprojeto) > 0){
						echo $chamado->idprojeto." - ".$this->Custom->get('projeto','idprojeto',$chamado->idprojeto)->nome;
					}
				?></td>
				<td><?php
					if(strlen($chamado->idusuario_atendimento) > 0){
						echo $chamado->idusuario_atendimento." - ".$this->Custom->get('usuario','idusuario',$chamado->idusuario_atendimento)->nome;
					}
				?></td>
                <td><?= h($chamado->assunto) ?></td>
                <td><?php
                    if(strlen($chamado->idchamadostatus) > 0){
                        echo $chamado->idchamadostatus." - ".$this->Custom->get('chamadostatus','idchamadostatus',$chamado->idchamadostatus)->descricao;
                    }
                ?></td>
                <!-- <td><?= $chamado->percentual ?>%</td> -->
                <td><?= h($chamado->data_prevista) ?></td>
                <td><?= h($chamado->horasprevistas) ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
</div>
</div>
</div>


<script>

	function addComent(id) {
  	 $('#chamadoidmodal').val(id);
	}
</script>

<script>
	function abrircriar(){
	// $("#divesconder").fadeTo("slow", 0.5);
	$("#divesconder").css({"opacity": 0, "transform": "translate3d(100px, 0, 0)", "transition": ".3s"});
	setTimeout(function() {
  	$('#divesconder').attr('class', 'col-md-6 animate');
	}, 100);
		setTimeout(function() {
  	$('#divesconder').removeAttr('style');
	}, 300);

    $('#divaparecer').load("./chamado/add",function(){
       $('#divaparecer').hide().fadeIn('slow');
    });

	}
</script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.13.4/jquery.mask.min.js"></script>

<script>
setTimeout(function() {
	$(".datatable").DataTable({
		"order": [[ 0, "desc" ]],
		responsive: false,
		retrieve: false,
		paging : true,
		scroll : false,
		searching: true,
		fixedHeader: {
		  header: true,
		  footer: false
		},
		language: {
				url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
				decimal: ",",
				thousands: "."
			},
			buttons: [
				{
				  extend: 'copy',
				  text: 'Copiar'
				},
				{
				  extend: 'print',
				  text: 'Imprimir',
				  messageTop: 'Relatório: ',
				},
				{
				  extend: 'excel',
				  text: 'Excel',
				  messageTop: 'Relatório:',
				},
				{
				  extend: 'pdf',
				  text: 'PDF',
				  messageTop: 'Relatório: ',
				}
			],
			dom: 'Bfrtip'
	});
}, 500);
$('.datatable td').css('padding','3px');
</script>

<script>
    function ToggleBox()
    {
        $("#div1").slideToggle("slow");

    }

    function ToggleBox2()
    {
        $("#div2").slideToggle("slow");
    }

    function ToggleBox3()
    {
        $("#div3").slideToggle("slow");
    }

    function ToggleBox4()
    {
        $("#div4").slideToggle("slow");
    }

    function ToggleBox5()
    {
        $("#div5").slideToggle("slow");
    }

    function ToggleBox6()
    {
        $("#div6").slideToggle("slow");
    }

    function ToggleBox7()
    {
        $("#div7").slideToggle("slow");
    }

    function ToggleBox8()
    {
        $("#div8").slideToggle("slow");
    }

</script>

