<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Chamado $chamado
 */
?>
<div class="card">
<div class="card-header">
    <div class="float-left">
        <h5><i class="fa fa-clock-o" aria-hidden="true"></i> <b><?=$chamado->horasprevistas ? $chamado->horasprevistas : "0.00" ?></b> Horas previstas</h5>
       <?php if($totalhoras == 0){?>
        <h5><i class="fa fa-clock-o" aria-hidden="true"></i> <b><?=$totalhoras?></b> Horas trabalhadas</h5>
       <?php }elseif($totalhoras <= $chamado->horasprevistas){?>
        <h5 style="color: #1fbf37"><i class="fa fa-clock-o" aria-hidden="true"></i> <b><?=$totalhoras?></b> Horas trabalhadas</h5>
        <?php }else{?>
            <h5 style="color: #e34e29"><i class="fa fa-clock-o" aria-hidden="true"></i> <b><?=$totalhoras?></b> Horas trabalhadas</h5>
         <?php } ?>

    </div>
	<div class="float-right">
        <?php
        $session = $this->request->session();
        $idperfil = $session->read('login.usuario')->idperfil;

        if( $idperfil == 16){
     ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar', ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?>
        <?= $this->Html->link('&nbsp;<i class="fa fa-bars" aria-hidden="true"></i> Listar', ['action' => 'suporte'], ['class'=>'btn btn-primary','escape'=>false]) ?>
         <?php } elseif ($idperfil == 17) { ?>
        <?= $this->Html->link('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar', ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?>
        <?= $this->Html->link('&nbsp;<i class="fa fa-bars" aria-hidden="true"></i> Listar', ['action' => 'suporteavancado'], ['class'=>'btn btn-primary','escape'=>false]) ?>
         <?php } else { ?>
        <?= $this->Html->link('&nbsp;<i class="fa fa-plus-circle fa-2" aria-hidden="true"></i> Chamado Filho', ['action' => 'addchamadofilho', $chamado->idchamado],['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-bars" aria-hidden="true"></i> Listar', ['action' => 'index'], ['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-edit fa-2" aria-hidden="true"></i>  Editar', ['action' => 'edit', $chamado->idchamado], ['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Form->postLink('&nbsp;<i class="fa fa-trash fa-2" aria-hidden="true"></i>  Deletar', ['action' => 'delete', $chamado->idchamado], ['confirm' => __('Deseja deletar # {0}?', $chamado->idchamado),'class'=>'btn btn-primary', 'escape'=>false]) ?>
        <?php }  ?>
	</div>
</div>
<div class="card-body">



	<div class="row">
	<div class="col-md-6">
	<h4>Chamado <?= h($chamado->idchamado) ?></h4>

    <table class="table-responsive table">
		<tr><td>
            <b><?= __('Empresa') ?></b><br>
            <?php
					if(strlen($chamado->idempresa) > 0){
						echo $chamado->idempresa." - ".$this->Custom->get('empresa','idempresa',$chamado->idempresa)->nome;
					}
				?>
        </td></tr>
		<tr><td>
            <b><?= __('Solicitante') ?></b><br>
            <?= h($chamado->solicitante) ?>
        </td></tr>
		<tr><td>
            <b><?= __('Atendente') ?></b><br>
            <?php
					if(strlen($chamado->idusuario_atendimento) > 0){
						echo $chamado->idusuario_atendimento." - ".$this->Custom->get('usuario','idusuario',$chamado->idusuario_atendimento)->nome;
					}
				?>
        </td></tr>
        <tr><td>
            <b><?= __('Assunto') ?></b><br>
            <?= h($chamado->assunto) ?>
        </td></tr>
        <tr><td>
            <b><?= __('Descrição') ?></b><br>
            <?= $this->Custom->textoLink(nl2br($chamado->descricao) )?>
        </td></tr>
        <tr><td>
            <b><?= __('Justificativa') ?></b><br>
            <?= $this->Custom->textoLink(nl2br($chamado->justificativa)) ?>
        </td></tr>
        <tr><td>
            <b><?= __('Tipo') ?></b><br>
            <?= h($chamado->tipo) ?>
        </td></tr>
        <tr><td>
            <b><?= __('Status') ?></b><br>
            <?php
                    if(strlen($chamado->idchamadostatus) > 0){
                        echo $chamado->idchamadostatus." - ".$this->Custom->get('chamadostatus','idchamadostatus',$chamado->idchamadostatus)->descricao;
                    }
                ?>
        </td></tr>
        <tr><td>
            <b><?= __('Complexidade') ?></b><br>
            <?= h($chamado->complexidade) ?>
        </td></tr>
        <tr><td>
            <b><?= __('Prioridade') ?></b><br>
            <?= h($chamado->prioridade) ?>
        </td></tr>
        <tr><td>
            <b><?= __('Usuario Criação') ?></b><br>
            <?php
					if(strlen($chamado->idusuario_criacao) > 0){
						echo $this->Custom->get('usuario','idusuario',$chamado->idusuario_criacao)->nome;
					}
				?>

        </td></tr>
        <tr><td>
            <b><?= __('Data Criação') ?></b><br>
            <?= h($chamado->data_criacao) ?>
        </td></tr>
        <tr><td>
            <b><?= __('Data Prevista') ?></b><br>
            <?= h($chamado->data_prevista) ?>
        </td></tr>
        <tr><td>
            <b><?= __('Data Fechamento') ?></b><br>
            <?= h($chamado->data_fechamento) ?>
        </td></tr>
		<tr><td >
			<b><?= __('Id Chamado Pai') ?></b><br>
            <a target="_BLANK" href="<?=$chamado->idchamadopai?>"><?= ($chamado->idchamadopai) ?></a>
        </td></tr>
        <tr><td >
            <b><?= __('Id GLPI') ?></b><br>
            <a target="_BLANK" href="https://aps.verdanadesk.com/front/ticket.form.php?id=<?=$chamado->idglpi?>"><?= ($chamado->idglpi) ?></a>
        </td></tr>
		<tr><td>
            <b><?= __('Projeto') ?></b><br>
            <?= ($chamado->idprojeto)?$this->Custom->get('projeto','idprojeto',$chamado->idprojeto)->nome:'' ?>
        </td></tr>
        <tr><td>
            <b><?= __('Produto') ?></b><br>
            <?= ($chamado->idproduto)?$this->Custom->get('produto','idproduto',$chamado->idproduto)->nome:'' ?>
        </td></tr>
    </table>
	</div>

	<div class="col-md-6" style="overflow-y: auto; height: 950px;">



            <div class="" id="tarefas">
                <div style="text-align:center"><i class="fa fa-refresh fa-spin"></i></div>
            </div>



	<h4>Observações</h4>

    <form action="" method="POST" enctype="multipart/form-data">
        <textarea placeholder="observação" class="form-control" name="observacao" maxlength="8000"></textarea>
          <?php
            $session = $this->request->session();
            $idperfil = $session->read('login.usuario')->idperfil;

            if( $idperfil != 16){
        ?>
        <div style="margin-top:5px; margin-bottom: 15px; ">
            <a data-toggle="collapse" href="#collapseExample" aria-expanded="false" aria-controls="collapseExample">
              <i class="fa fa-plus-circle" aria-hidden="true"></i> <spam data-toggle="tooltip" data-placement="top" title="Campo expresso em horas. Ex.: 01h:30m equivale a 01.50h">Adicionar Horas Trabalhadas</spam>
            </a>
            <div class="collapse" id="collapseExample">
              <div class="well">
                <div class="form-group">
                <input type="text" name="horastrabalhadas" class="form-control col-md-6" data-mask="00.00" data-mask-selectonfocus="true" >
                </div>
              </div>
            </div>
        </div>
        <?php }  ?>
        <?php if( $idperfil == 16){ echo '<br>'; }?>
        <input type="hidden" name="MAX_FILE_SIZE" value="10485760" />
                <input name='arquivo' type='file'/>
        <br><br>
        <?= $this->Form->button(__('Cadastrar observação'),['class'=>'btn btn-primary']) ?>
    </form>

    <br><br>

	<table class="table-responsive table">
		<?php foreach($chamadoobs as $item){?>
			<tr>
				<td style="text-align:justify">
					<i class="fa fa-user"></i><b> <?=$this->Custom->get('usuario','idusuario',$item->idusuario)->nome?></b><br>
					<?=$item->data_criacao?>
					<br>
                    <i class="fa fa-comment"></i>
                    <?=$this->Custom->textoLink(nl2br($item->observacao."<br>"))?>


                    <?php if($item->horastrabalhadas > 0){
                        echo $item->horastrabalhadas . " Horas trabalhadas<br>";
                     } ?>

                    <?php
                        $tmp = explode(".",$item->arquivo);
                        $extensao = end($tmp);
                            if(strlen($item->arquivo)>0 && (in_array($extensao, ['jpg','jpeg','png','gif','JPG','JPEG','PNG','GIF']))){ ;?>
                                <a target="_BLANK" href="<?=$this->request->base?>/../arquivos/flygestor/<?=$chamado->idchamado.'/'.$item->arquivo?>">
                                <img style="width:100%" src="<?=$this->request->base?>/../arquivos/flygestor/<?=$chamado->idchamado.'/'.$item->arquivo?>">
                            <i class="fa fa-download" aria-hidden="true"></i> <span><i><?=$item->arquivo?><i></span></a><br>
                                <?php } else if (strlen($item->arquivo)>0){ ?>
                                   <a target="_BLANK" href="<?=$this->request->base?>/../arquivos/flygestor/<?=$chamado->idchamado.'/'.$item->arquivo?>">
                                <i class="fa fa-download" aria-hidden="true"></i> <span><i><?=$item->arquivo?><i></span></a> <br>
                                <?php } ?>


				</td>
                <?php if($item->log != 1){ ?>
				<td>
					<?= $this->Html->link('&nbsp;<i class="fa fa-edit fa-2" aria-hidden="true"></i>', ['controller'=>'chamadoobs','action' => 'edit', $item->idchamadoobs], ['class'=>'btn btn-primary btn-sm','escape'=>false]) ?>
					<?= $this->Form->postLink('&nbsp;<i class="fa fa-trash fa-2" aria-hidden="true"></i>', ['controller'=>'chamadoobs','action' => 'delete', $item->idchamadoobs], ['confirm' => __('Deseja deletar # {0}?', $item->idchamadoobs),'class'=>'btn btn-danger btn-sm', 'escape'=>false]) ?>
				</td>
                <?php } ?>
			</tr>
		<?php } ?>
	</table>


	</div>
	</div>

    <br><br>
<div class="row">
    <div class="col-md-12">
    <h5>Chamados Filhos</h5>
    <table style="font-size:10px" class="table table-responsive table-striped" cellpadding="0" cellspacing="0">
        <thead>
            <tr>
                <th scope="col">Cód</th>
                <th scope="col">Atendente</th>
                <th scope="col">Assunto</th>
                <th scope="col">Status</th>
                <th scope="col">Percentual</th>
                <th scope="col">Data Prevista</th>
                <th scope="col">Horas Previstas</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($chamadosfilhos as $chamado): ?>
            <tr style="cursor:pointer" onclick="window.open('<?=$chamado->idchamado?>')">
                <td><?= $this->Number->format($chamado->idchamado) ?></td>
                <td><?php
                    if(strlen($chamado->idusuario_atendimento) > 0){
                        echo $chamado->idusuario_atendimento." - ".$this->Custom->get('usuario','idusuario',$chamado->idusuario_atendimento)->nome;
                    }
                ?></td>
                <td><?= h($chamado->assunto) ?></td>
                <td><?= h($chamado->status) ?></td>
                <td><?= $chamado->percentual ?>%</td>
                <td><?= h($chamado->data_prevista) ?></td>
                <td><?= h($chamado->horasprevistas) ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
</div>
</div>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.13.4/jquery.mask.min.js"></script>


<script>

function abrepainel(url,painel,time){
    setTimeout(function(){
        $('#'+painel).load(url,function(responseText, textStatus, req){
            if (textStatus == "error") {
                alert('Sua consulta retornou um número muito grande de registros. Tente um período menor.');
                $('[data-dismiss="modal"]').click();
            }
        });
    }, time);
}

abrepainel('<?=$this->request->base?>/controladoria/todo/index/<?=$chamado->idchamado?>','tarefas',200);
</script>
