<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Empresa $empresa
 */
?>
<div class="card">
<div class="card-header">
	<h3>Empresa <?= h($empresa->idempresa) ?></h3>
	<div class="float-right">
		<?= $this->Html->link('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar', ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-bars" aria-hidden="true"></i> Listar', ['action' => 'index'], ['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-eye fa-2" aria-hidden="true"></i>  Ver', ['action' => 'view', $empresa->idempresa], ['class'=>'btn btn-primary','escape'=>false]) ?> 
		<?= $this->Form->postLink('&nbsp;<i class="fa fa-trash fa-2" aria-hidden="true"></i>  Deletar', ['action' => 'delete', $empresa->idempresa], ['confirm' => __('Deseja deletar # {0}?', $empresa->idempresa),'class'=>'btn btn-primary', 'escape'=>false]) ?>
	</div>
</div>
<div class="card-body">
    <?= $this->Form->create($empresa) ?>
        <?php
            echo $this->Form->control('nome',['class'=>'form-control']);
            echo $this->Form->control('razaosocial',['class'=>'form-control']);
            echo $this->Form->control('logo',['class'=>'form-control']);
            echo $this->Form->control('cnpj',['class'=>'form-control']);
            echo $this->Form->control('cidade',['class'=>'form-control']);
            echo $this->Form->control('estado',['class'=>'form-control']);
            ?>
			<label>ERP</label>
			<select name="erp" class="form-control">
				<option value="" disabled>Escolha o ERP </option>
				<?php 
					$selected = "";
					foreach($erps as $erp){ ?>
					<?php if($empresa->erp == $erp->chave){$selected = "selected";}else{$selected = "";}?>
					<option value="<?=$erp->chave?>" <?=$selected?>><?=$erp->nome?></option>
				<?php } ?>
			</select>
			<?php
            echo $this->Custom->selectSimNao('ativo',$empresa->ativo,true);
            echo $this->Form->control('conexao_ip',['class'=>'form-control']);
            echo $this->Form->control('conexao_porta',['class'=>'form-control']);
            echo $this->Form->control('conexao_key',['class'=>'form-control']);
            echo $this->Form->control('conexao_path',['class'=>'form-control']);
            echo $this->Form->control('bancoerp',['class'=>'form-control']);
            echo $this->Form->control('bancoerp_usuario',['class'=>'form-control']);
            echo $this->Form->control('bancoerp_senha',['class'=>'form-control']);
            echo $this->Form->control('bancoerp_host',['class'=>'form-control']);
            echo $this->Form->control('bancoerp_porta',['class'=>'form-control']);
            echo $this->Form->control('bancoflygestor',['class'=>'form-control']);
            echo $this->Form->control('bancoflygestor_usuario',['class'=>'form-control']);
            echo $this->Form->control('bancoflygestor_senha',['class'=>'form-control']);
            echo $this->Form->control('bancoflygestor_porta',['class'=>'form-control']);
            echo $this->Form->control('bancoflygestor_host',['class'=>'form-control']);
        ?>
	<br><br>
    <?= $this->Form->button(__('Enviar'),['class'=>'btn btn-primary']) ?>
    <?= $this->Form->end() ?>
</div>
</div>
