<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Empresa[]|\Cake\Collection\CollectionInterface $empresa
 */
?>
<div class="card">
<div class="card-header">
	<h3>Empresas (<?=count($empresa->toArray())?>)</h3>
	<div class="float-right">
		<?= $this->Html->link('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar', ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?>
        <?= $this->Html->link('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar (Rápido)', ['action' => 'addempresarapido'],['class'=>'btn btn-primary','escape'=>false]) ?>
	</div>
</div>
<div class="card-body">
    <table class="table table-responsive table-striped datatable" cellpadding="0" cellspacing="0">
        <thead>
            <tr>
                <th scope="col"></th>
                <th scope="col">Empresa</th>
                <th scope="col">ERP</th>
                <th scope="col">Conexão</th>
                <th scope="col">Banco Flygestor</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($empresa as $empresa): ?>
            <tr >
                <td><a class="btn btn-primary btn-sm" target="_blank" href="empresa/view/<?=$empresa->idempresa?>">
					<i class="fa fa-eye"></i> Ver
				</td>
                <td style="white-space:nowrap"><?= h($empresa->nome).' ('.$empresa->idempresa.')' ?></td>
                <td><?= h($empresa->erp) ?></td>
                <td><?= h($empresa->conexao_ip).'/'.$empresa->conexao_path ?></td>
                <td><?= h($empresa->bancoflygestor) ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
</div>
<script>
	$('td').css('padding','5px');
</script>

<script>
setTimeout(function() {
	$(".datatable").DataTable({
		"order": [[ 0, "desc" ]],
		responsive: false,
		retrieve: false,
		paging : false,
		scroll : false,
		searching: true,
		fixedHeader: {
		  header: true,
		  footer: false
		},
		language: {
				url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
				decimal: ",",
				thousands: "."
			},
			buttons: [
				{
				  extend: 'copy',
				  text: 'Copiar'
				},
				{
				  extend: 'print',
				  text: 'Imprimir',
				  messageTop: 'Relatório: ',
				},
				{
				  extend: 'excel',
				  text: 'Excel',
				  messageTop: 'Relatório:',
				},
				{
				  extend: 'pdf',
				  text: 'PDF',
				  messageTop: 'Relatório: ',
				}
			],
			dom: 'Bfrtip'
	});
}, 500);
$('.datatable td').css('padding','3px');
</script>
