<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Empresa $empresa
 */
?>
<div class="card">
<div class="card-header">
	<h3>Empresa <?= h($empresa->idempresa) ?></h3>
	<div class="float-right">
		<?= $this->Html->link('&nbsp;<i class="fa fa-user fa-2" aria-hidden="true"></i> Criar Usuário', ['controller'=>'usuario','action' => 'add', $empresa->idempresa],['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-database fa-2" aria-hidden="true"></i>  SQL', ['action' => 'script', $empresa->idempresa], ['class'=>'btn btn-primary','escape'=>false]) ?> 
		<?= $this->Html->link('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar', ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-bars" aria-hidden="true"></i> Listar', ['action' => 'index'], ['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-edit fa-2" aria-hidden="true"></i>  Editar', ['action' => 'edit', $empresa->idempresa], ['class'=>'btn btn-primary','escape'=>false]) ?> 
		<?= $this->Form->postLink('&nbsp;<i class="fa fa-trash fa-2" aria-hidden="true"></i>  Deletar', ['action' => 'delete', $empresa->idempresa], ['confirm' => __('Deseja deletar # {0}?', $empresa->idempresa),'class'=>'btn btn-primary', 'escape'=>false]) ?>
	</div>
</div>
<div class="card-body">
	<ul class="nav nav-tabs nav-top-border no-hover-bg nav-justified">
		<li class="nav-item">
			<a class="nav-link active" id="" data-toggle="tab" href="#tab1" aria-controls="aba1" aria-expanded="true">
				<i class="fa fa-building"></i> Empresa
			</a>
		</li>
		<li class="nav-item">
			<a class="nav-link" id="" data-toggle="tab" href="#tab2" aria-controls="aba2" aria-expanded="false">
				<i class="fa fa-users"></i> Usuários (<?=count($usuarios->toArray())?>)
			</a>
		</li>
		<li class="nav-item">
			<a class="nav-link" id="" data-toggle="tab" href="#tab3" aria-controls="aba3" aria-expanded="false">
				<i class="fa fa-edit"></i> Observações
			</a>
		</li>
	</ul>
	<div class="tab-content px-1 pt-1">
		<div role="tabpanel" class="tab-pane active in" id="tab1" aria-labelledby="aba1" aria-expanded="true">
			<table class="vertical-table table-responsive table">
				<tr>
					<th scope="row"><?= __('Nome') ?></th>
					<td><?= h($empresa->nome) ?></td>
				</tr>
				<tr>
					<th scope="row"><?= __('Razão Social') ?></th>
					<td><?= h($empresa->razaosocial) ?></td>
				</tr>
				<tr>
					<th scope="row"><?= __('Logo') ?></th>
					<td><?= h($empresa->logo) ?></td>
				</tr>
				<tr>
					<th scope="row"><?= __('CNPJ') ?></th>
					<td><?= h($empresa->cnpj) ?></td>
				</tr>
				<tr>
					<th scope="row"><?= __('Cidade/UF') ?></th>
					<td><?=$empresa->cidade.'/'.$empresa->estado?></td>
				</tr>
				<tr>
					<th scope="row"><?= __('ERP') ?></th>
					<td><?= h($empresa->erp) ?></td>
				</tr>
				<tr>
					<th scope="row"><?= __('Conexao') ?></th>
					<td><?=$empresa->conexao_ip.':'.$empresa->conexao_porta.'/'.$empresa->conexao_path ?></td>
				</tr>
				<tr>
					<th scope="row"><?= __('Banco ERP') ?></th>
					<td><?= h($empresa->bancoerp) ?></td>
				</tr>
				<tr>
					<th scope="row"><?= __('Banco Flygestor') ?></th>
					<td><?= h($empresa->bancoflygestor) ?></td>
				</tr>
				<tr>
					<th scope="row"><?= __('Ativo') ?></th>
					<td><?= $this->Custom->toSimNao($empresa->ativo) ?></td>
				</tr>
				<tr>
					<th scope="row"><?= __('Data Criação') ?></th>
					<td><?= h($empresa->data_criacao) ?></td>
				</tr>
			</table>
			<br><br>
			<h3>Responsáveis</h3>
			<br><br>
			<table class="table table-responsive table-striped" cellpadding="0" cellspacing="0">
				<thead>
					<tr>
						<th></th>
						<th >Nome</th>
						<th>Telefone</th>
						<th>Email</th>
					</tr>
				</thead>

				<tbody>
					<?php foreach($usuariosresponsaveis as $usuario){ ?>
					<tr>
						<td><a class="btn btn-primary btn-sm" target="_blank" href="../../usuario/view/<?=$usuario->idusuario?>">
					<i class="fa fa-eye"></i> Ver
				</td>
						<td><?= h($usuario->nome)?></td>
						<td><?= h($usuario->telefone)?></td>
						<td><?= h($usuario->email)?></td>
					<?php }?>
					</tr>
				</tbody>
			</table>
		</div>
		<div class="tab-pane" id="tab2" role="tab2" aria-labelledby="aba2" aria-expanded="false">
			<table class="table-responsive table table-striped">
				<tr>
					<th>Cód.</th>
					<th>CPF</th>
					<th>Nome</th>
					<th>Perfil</th>
					<th></th>
				</tr>
				<?php foreach($usuarios as $usuario){ ?>
					<tr>
						<td><?=$usuario->idusuario?></td>
						<td><?=$usuario->cpf?></td>
						<td><?=$usuario->nome?></td>
						<td><?=$this->Custom->get('perfil','idperfil',$usuario->idperfil)->descricao?></td>
						<td>
							<a target="_BLANK" href="../../usuario/view/<?=$usuario->idusuario?>" class="btn btn-primary">
								<i class="fa fa-eye fa-2" aria-hidden="true"></i> Ver
							</a>
						
							<?php
							if($usuario->idempresa != 1)
							echo $this->Html->link('&nbsp;<i class="fa fa-exchange fa-2" aria-hidden="true"></i> Logar', ['controller'=>'usuario','action' => 'login', $usuario->idusuario],['class'=>'btn btn-primary','escape'=>false]) ?>
						</td>
					</tr>
				<?php } ?>
			</table>
		</div>
		<div class="tab-pane" id="tab3" role="tab3" aria-labelledby="aba3" aria-expanded="false">
			<table class="vertical-table table-responsive table">
				<?php foreach($empresaobs as $empresaobs){?>
					<tr>
						<th>
							<?=$this->Custom->get('usuario','idusuario',$empresaobs->idusuario)->nome?>
							<br>
							<?= $this->Html->link('&nbsp;<i class="fa fa-edit fa-2" aria-hidden="true"></i>', ['controller'=>'empresaobs','action' => 'edit', $empresaobs->empresaobsid], ['class'=>'btn btn-primary','escape'=>false]) ?> 
							<?= $this->Form->postLink('&nbsp;<i class="fa fa-trash fa-2" aria-hidden="true"></i>', ['controller'=>'empresaobs','action' => 'delete', $empresaobs->empresaobsid], ['confirm' => __('Deseja deletar # {0}?', $empresaobs->empresaobsid),'class'=>'btn btn-danger', 'escape'=>false]) ?>
						</th>
						<td>
						<?=$empresaobs->data_criacao?>
						<br>
						<?= $this->Custom->textoLink(str_replace(PHP_EOL,'<br>',$empresaobs->observacao));?></td>
					</tr>
				<?php } ?>
			</table>
			<form action="" method="POST">
				<textarea placeholder="observação" class="form-control" name="observacao" maxlength="8000"></textarea>
				<br>
				<?= $this->Form->button(__('enviar'),['class'=>'btn btn-primary']) ?>
			</form>
		</div>
	</div>
</div>
</div>
