<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Empresaob $empresaob
 */
?>
<div class="card">
<div class="card-header">
	<h3>Empresaob <?= h($empresaob->empresaobsid) ?></h3>
	<div class="float-right">
		<?= $this->Html->link('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar', ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-bars" aria-hidden="true"></i> Listar', ['action' => 'index'], ['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-edit fa-2" aria-hidden="true"></i>  Editar', ['action' => 'edit', $empresaob->empresaobsid], ['class'=>'btn btn-primary','escape'=>false]) ?> 
		<?= $this->Form->postLink('&nbsp;<i class="fa fa-trash fa-2" aria-hidden="true"></i>  Deletar', ['action' => 'delete', $empresaob->empresaobsid], ['confirm' => __('Deseja deletar # {0}?', $empresaob->empresaobsid),'class'=>'btn btn-primary', 'escape'=>false]) ?>
	</div>
</div>
<div class="card-body">
    <table class="vertical-table table-responsive table">
        <tr>
            <th scope="row"><?= __('Observacao') ?></th>
            <td><?= h($empresaob->observacao) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Empresaobsid') ?></th>
            <td><?= $this->Number->format($empresaob->empresaobsid) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Idempresa') ?></th>
            <td><?= $this->Number->format($empresaob->idempresa) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Idusuario') ?></th>
            <td><?= $this->Number->format($empresaob->idusuario) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Data Criacao') ?></th>
            <td><?= h($empresaob->data_criacao) ?></td>
        </tr>
    </table>
</div>
</div>
