<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Erp[]|\Cake\Collection\CollectionInterface $erp
 */
?>
<div class="card">
<div class="card-header">
	<h3><?= __('Erp') ?></h3>
	<div class="float-right">
		<?= $this->Html->link(__('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar'), ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?></li>
	</div>
</div>
<div class="card-body">
    <table class="table table-responsive table-striped" cellpadding="0" cellspacing="0">
        <thead>
            <tr>
                <th scope="col">Id</th>
                <th scope="col"><?= $this->Paginator->sort('chave') ?></th>
                <th scope="col"><?= $this->Paginator->sort('nome') ?></th>
                <th scope="col"><?= $this->Paginator->sort('ativo') ?></th>
                <th scope="col">Data Criação</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($erp as $erp): ?>
            <tr style="cursor:pointer" onclick="window.location.href='erp/view/<?=$erp->iderp?>'">
                <td><?= $this->Number->format($erp->iderp) ?></td>
                <td><?= h($erp->chave) ?></td>
                <td><?= h($erp->nome) ?></td>
                <td><?= $this->Custom->toSimNao($erp->ativo) ?></td>
                <td><?= h($erp->data_criacao) ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('primeiro')) ?>
            <?= $this->Paginator->prev('< ' . __('anterior')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('próximo') . ' >') ?>
            <?= $this->Paginator->last(__('último') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(['format' => __('Página {{page}} de {{pages}}, mostrando {{current}} registros(s) de total {{count}}')]) ?></p>
    </div>
</div>
</div>
