<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Erp $erp
 */
?>
<div class="card">
<div class="card-header">
	<h3>Erp <?= h($erp->iderp) ?></h3>
	<div class="float-right">
		<?= $this->Html->link('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar', ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-bars" aria-hidden="true"></i> Listar', ['action' => 'index'], ['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-edit fa-2" aria-hidden="true"></i>  Editar', ['action' => 'edit', $erp->iderp], ['class'=>'btn btn-primary','escape'=>false]) ?> 
		<?= $this->Form->postLink('&nbsp;<i class="fa fa-trash fa-2" aria-hidden="true"></i>  Deletar', ['action' => 'delete', $erp->iderp], ['confirm' => __('Deseja deletar # {0}?', $erp->iderp),'class'=>'btn btn-primary', 'escape'=>false]) ?>
	</div>
</div>
<div class="card-body">
    <table class="vertical-table table-responsive table">
        <tr>
            <th scope="row"><?= __('Chave') ?></th>
            <td><?= h($erp->chave) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Nome') ?></th>
            <td><?= h($erp->nome) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Responsável') ?></th>
            <td><?= h($erp->responsavel) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Telefone') ?></th>
            <td><?= h($erp->telefone) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Email') ?></th>
            <td><?= h($erp->email) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Endereco') ?></th>
            <td><?= h($erp->endereco) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Logo') ?></th>
            <td><?= h($erp->logo) ?></td>
        </tr>
        <tr>
            <th scope="row">ERP</th>
            <td><?= $this->Custom->get('erp','iderp',$erp->iderp)->nome ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Ativo') ?></th>
            <td><?= $this->Custom->toSimNao($erp->ativo) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Data Criação') ?></th>
            <td><?= h($erp->data_criacao) ?></td>
        </tr>
    </table>
</div>
</div>
