<?php

?>

<div class="row">
	<div class="col-md-4">
		<h6 class="card-title">Abertos por Clientes</h6>
		<?php if(count($abertosempresa) > 0){ ?>
			<table style="font-size:10px;overflow-y: auto;max-height:300px" class="table display table-responsive nowrap table-striped table-bordered scroll-horizontal-vertical2">
				<thead>
					<tr>
						<th>Projeto</th>
						<th>Total de Chamados <i class="fa fa-sort-up"></i></th>
					</tr>
				</thead>
				<tbody>
					<?php
						
						foreach($abertosempresa as $abertosempresa){
							echo "<tr>";
							echo "<td>".$abertosempresa->empresa."</td>";
							echo "<td>".$this->Custom->toNumber($abertosempresa->total)."</td>";
							echo "</tr>";
						}
					?>
				</tbody>
			</table>
		<?php }else{echo "Sem dados.";} ?>
	</div>

	<div class="col-md-4">
		<h6 class="card-title">Abertos por Produto</h6>
		<?php 
		$pkCount = (is_array($abertosproduto) ? count($abertosproduto) : 1);
		
		if($pkCount > 0){ ?>
			<div id="pizzaabertosproduto" style="width:100%" class="height-300 echart-container"></div>
			<!-- <table style="font-size:10px;overflow-y: auto;max-height:400px" class="table display table-responsive nowrap table-striped table-bordered scroll-horizontal-vertical2">
				<thead>
					<tr>
						<th>Produto</th>
						<th>Total de Chamados <i class="fa fa-sort-up"></i></th>
					</tr>
				</thead>
				<tbody>
					<?php
						
						foreach($abertosproduto as $abertosproduto){
							echo "<tr>";
							echo "<td>".$abertosproduto->produto."</td>";
							echo "<td>".$this->Custom->toNumber($abertosproduto->total)."</td>";
							echo "</tr>";
						}
					?>
				</tbody>
			</table> -->
		<?php }else{echo "Sem dados.";} ?>
	</div>

	<div class="col-md-4">
		<h6 class="card-title">Encerrados no Mês</h6>
		<?php if(count($encerradosusuario) > 0){ ?>
			<div id="pizzaencerrados" style="width:100%" class="height-300 echart-container"></div>
			<!-- <table style="font-size:10px;overflow-y: auto;max-height:400px" class="table display table-responsive nowrap table-striped table-bordered scroll-horizontal-vertical2">
				<thead>
					<tr>
						<th>Atendente</th>
						<th>Total de Chamados <i class="fa fa-sort-up"></i></th>
					</tr>
				</thead>
				<tbody>
					<?php
						
						foreach($encerradosusuario as $encerradosusuario){
							echo "<tr>";
							echo "<td>".$encerradosusuario->nome."</td>";
							echo "<td>".$this->Custom->toNumber($encerradosusuario->total)."</td>";
							echo "</tr>";
						}
					?>
				</tbody>
			</table> -->
		<?php }else{echo "Sem dados.";} ?>
	</div>

</div>

<div class="row">
	<div class="col-md-4">
		<h6 class="card-title">Abertos por Projeto</h6>
		<?php if(count($abertosprojeto) > 0){ ?>
			<table style="font-size:10px;overflow-y: auto;max-height:300px" class="table display table-responsive nowrap table-striped table-bordered scroll-horizontal-vertical2">
				<thead>
					<tr>
						<th>Projeto</th>
						<th>Total de Chamados <i class="fa fa-sort-up"></i></th>
					</tr>
				</thead>
				<tbody>
					<?php
						
						foreach($abertosprojeto as $abertosprojeto){
							echo "<tr>";
							echo "<td>".$abertosprojeto->projeto."</td>";
							echo "<td>".$this->Custom->toNumber($abertosprojeto->total)."</td>";
							echo "</tr>";
						}
					?>
				</tbody>
			</table>
		<?php }else{echo "Sem dados.";} ?>
	</div>

	<div class="col-md-4">
		<h6 class="card-title">Intercorrências</h6>
		<?php if(count($intercorrencias) > 0){ ?>
			<table style="font-size:10px;overflow-y: auto;max-height:300px" class="table display table-responsive nowrap table-striped table-bordered scroll-horizontal-vertical2">
				<thead>
					<tr>
						<th>Atendente</th>
						<th>Total<i class="fa fa-sort-up"></i></th>
					</tr>
				</thead>
				<tbody>
					<?php
						
						foreach($intercorrencias as $intercorrencias){
							echo "<tr>";
							echo "<td>".$intercorrencias->nome."</td>";
							echo "<td>".$this->Custom->toNumber($intercorrencias->total)."</td>";
							echo "</tr>";
						}
					?>
				</tbody>
			</table>
		<?php }else{echo "Sem dados.";} ?>
	</div>
</div>

<script>
//graficos de pizza
setTimeout(function() { 
	pizzaEncerrados();
}, 100);
setTimeout(function() { 
	pizzaAbertosproduto();
}, 100);

function pizzaEncerrados() {
	var json = <?=$jsonencerradosusuario?>;
	var data = [];
	var valorOutros = 0;
	for(i = 0; i < json.nome.length; i++){
		if(i < 6){
			var name = json.nome[i];
			if(!name){
				name = '(sem nome)';
			}
			if(name.length > 20){
				name = name.substring(0,19);
			}
			data[i] = {name: name, value: json.total[i]};
		}else{
			valorOutros = valorOutros + json.total[i];
			data[6] = {name: 'Outros', value: valorOutros};
		}
		
	}

	// Initialize chart
	// ------------------------------
	var myChart = echarts.init(document.getElementById('pizzaencerrados'));

	// Chart Options
	// ------------------------------
	chartOptions = {
		// Add tooltip
		tooltip: {
			trigger: 'item',
			formatter: "{a} <br/>{b}: {c} ({d}%)"
		},

		// Add legend
		legend: {
			orient: 'horizontal',
			x: 'left',
			data: data
		},

		// Enable drag recalculate
		calculable: true,

		// Add series
		series: [{
			name: 'Atendente',
			type: 'pie',
			radius: '50%',
			center: ['50%', '44.5%'],

			label: {
                normal: {
                    formatter: '{per|{d}%}  ',
                    rich: {
                       
                        per: {
                            color: '#eee',
                            backgroundColor: '#334455',
                            padding: [2, 4],
                            borderRadius: 2
                        }
                    }
                }
            },
			data: data
			,itemStyle: {
                emphasis: {
                    shadowBlur: 10,
                    shadowOffsetX: 0,
                    shadowColor: 'rgba(0, 0, 0, 0.5)'
                }
            }
		}]
	};

	// Apply options
	// ------------------------------

	myChart.setOption(chartOptions);


	// Resize chart
	// ------------------------------

	$(function () {

		// Resize chart on menu width change and window resize
		$(window).on('resize', resize);
		$(".menu-toggle").on('click', resize);

		// Resize function
		function resize() {
			setTimeout(function() {

				// Resize chart
				myChart.resize();
			}, 200);
		}
	});
}

function pizzaAbertosproduto() {
	var json = <?=$jsonabertosproduto?>;
	var data = [];
	var valorOutros = 0;
	for(i = 0; i < json.produto.length; i++){
		if(i < 6){
			var name = json.produto[i];
			if(!name){
				name = '(sem nome)';
			}
			if(name.length > 20){
				name = name.substring(0,19);
			}
			data[i] = {name: name, value: json.total[i]};
		}else{
			valorOutros = valorOutros + json.total[i];
			data[6] = {name: 'Outros', value: valorOutros};
		}
		
	}

	// Initialize chart
	// ------------------------------
	var myChart = echarts.init(document.getElementById('pizzaabertosproduto'));

	// Chart Options
	// ------------------------------
	chartOptions = {
		// Add tooltip
		tooltip: {
			trigger: 'item',
			formatter: "{a} <br/>{b}: {c} ({d}%)"
		},

		// Add legend
		legend: {
			orient: 'horizontal',
			x: 'left',
			data: data
		},

		// Enable drag recalculate
		calculable: true,

		// Add series
		series: [{
			name: 'Produto',
			type: 'pie',
            radius: ['40%', '55%'],
            center: ['50%', '52.5%'],
            avoidLabelOverlap: false,

			label: {
                normal: {
                    formatter: '{per|{d}%}  ',
                    rich: {
                       
                        per: {
                            color: '#eee',
                            backgroundColor: '#334455',
                            padding: [2, 4],
                            borderRadius: 2
                        }
                    }
                }
            },
			data: data
			,itemStyle: {
                emphasis: {
                    shadowBlur: 10,
                    shadowOffsetX: 0,
                    shadowColor: 'rgba(0, 0, 0, 0.5)'
                }
            }
		}]
	};

	// Apply options
	// ------------------------------

	myChart.setOption(chartOptions);


	// Resize chart
	// ------------------------------

	$(function () {

		// Resize chart on menu width change and window resize
		$(window).on('resize', resize);
		$(".menu-toggle").on('click', resize);

		// Resize function
		function resize() {
			setTimeout(function() {

				// Resize chart
				myChart.resize();
			}, 200);
		}
	});
}


</script>

<script>
	$('.table td').css('padding','5px');
	$('.table th').css('padding','5px');
</script>