<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\LogAcesso[]|\Cake\Collection\CollectionInterface $logAcesso
 */
?>
<div class="card">
<div class="card-header">
	<h3><?= __('Log Acesso') ?></h3>
	<div class="float-right">
		<?= $this->Html->link(__('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar'), ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?></li>
	</div>
</div>
<div class="card-body">
    <table class="table table-responsive table-striped" cellpadding="0" cellspacing="0">
        <thead>
            <tr>
                <th scope="col"><?= $this->Paginator->sort('id') ?></th>
                <th scope="col"><?= $this->Paginator->sort('user') ?></th>
                <th scope="col"><?= $this->Paginator->sort('data_hora') ?></th>
                <th scope="col"><?= $this->Paginator->sort('ip') ?></th>
                <th scope="col"><?= $this->Paginator->sort('latitude') ?></th>
                <th scope="col"><?= $this->Paginator->sort('longitude') ?></th>
                <th scope="col"><?= $this->Paginator->sort('cidade') ?></th>
                <th scope="col"><?= $this->Paginator->sort('estado') ?></th>
                <th scope="col"><?= $this->Paginator->sort('pais') ?></th>
                <th scope="col"><?= $this->Paginator->sort('validado') ?></th>
                <th scope="col"><?= $this->Paginator->sort('user_digitado') ?></th>
                <th scope="col"><?= $this->Paginator->sort('pas_digitado') ?></th>
                <th scope="col"><?= $this->Paginator->sort('useragent') ?></th>
                <th scope="col"><?= $this->Paginator->sort('url') ?></th>
                <th scope="col"><?= $this->Paginator->sort('request') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($logAcesso as $logAcesso): ?>
            <tr style="cursor:pointer" onclick="window.location.href='logAcesso/view/<?=$logAcesso->id?>'">
                <td><?= $this->Number->format($logAcesso->id) ?></td>
                <td><?= $this->Number->format($logAcesso->user) ?></td>
                <td><?= h($logAcesso->data_hora) ?></td>
                <td><?= h($logAcesso->ip) ?></td>
                <td><?= h($logAcesso->latitude) ?></td>
                <td><?= h($logAcesso->longitude) ?></td>
                <td><?= h($logAcesso->cidade) ?></td>
                <td><?= h($logAcesso->estado) ?></td>
                <td><?= h($logAcesso->pais) ?></td>
                <td><?= $this->Number->format($logAcesso->validado) ?></td>
                <td><?= h($logAcesso->user_digitado) ?></td>
                <td><?= h($logAcesso->pas_digitado) ?></td>
                <td><?= h($logAcesso->useragent) ?></td>
                <td><?= h($logAcesso->url) ?></td>
                <td><?= h($logAcesso->request) ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('primeiro')) ?>
            <?= $this->Paginator->prev('< ' . __('anterior')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('próximo') . ' >') ?>
            <?= $this->Paginator->last(__('último') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(['format' => __('Página {{page}} de {{pages}}, mostrando {{current}} registros(s) de total {{count}}')]) ?></p>
    </div>
</div>
</div>
