<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\LogAcesso $logAcesso
 */
?>
<div class="card">
<div class="card-header">
	<h3>LogAcesso <?= h($logAcesso->id) ?></h3>
	<div class="float-right">
		<?= $this->Html->link('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar', ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-bars" aria-hidden="true"></i> Listar', ['action' => 'index'], ['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-edit fa-2" aria-hidden="true"></i>  Editar', ['action' => 'edit', $logAcesso->id], ['class'=>'btn btn-primary','escape'=>false]) ?> 
		<?= $this->Form->postLink('&nbsp;<i class="fa fa-trash fa-2" aria-hidden="true"></i>  Deletar', ['action' => 'delete', $logAcesso->id], ['confirm' => __('Deseja deletar # {0}?', $logAcesso->id),'class'=>'btn btn-primary', 'escape'=>false]) ?>
	</div>
</div>
<div class="card-body">
    <table class="vertical-table table-responsive table">
        <tr>
            <th scope="row"><?= __('Ip') ?></th>
            <td><?= h($logAcesso->ip) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Latitude') ?></th>
            <td><?= h($logAcesso->latitude) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Longitude') ?></th>
            <td><?= h($logAcesso->longitude) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Cidade') ?></th>
            <td><?= h($logAcesso->cidade) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Estado') ?></th>
            <td><?= h($logAcesso->estado) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Pais') ?></th>
            <td><?= h($logAcesso->pais) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('User Digitado') ?></th>
            <td><?= h($logAcesso->user_digitado) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Pas Digitado') ?></th>
            <td><?= h($logAcesso->pas_digitado) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Useragent') ?></th>
            <td><?= h($logAcesso->useragent) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Url') ?></th>
            <td><?= h($logAcesso->url) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Request') ?></th>
            <td><?= h($logAcesso->request) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Id') ?></th>
            <td><?= $this->Number->format($logAcesso->id) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('User') ?></th>
            <td><?= $this->Number->format($logAcesso->user) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Validado') ?></th>
            <td><?= $this->Number->format($logAcesso->validado) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Data Hora') ?></th>
            <td><?= h($logAcesso->data_hora) ?></td>
        </tr>
    </table>
</div>
</div>
