<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Modulo $modulo
 */
?>
<div class="card">
<div class="card-header">
	<h3>Modulo <?= h($modulo->idmodulo) ?></h3>
	<div class="float-right">
		<?= $this->Html->link('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar', ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-bars" aria-hidden="true"></i> Listar', ['action' => 'index'], ['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-edit fa-2" aria-hidden="true"></i>  Editar', ['action' => 'edit', $modulo->idmodulo], ['class'=>'btn btn-primary','escape'=>false]) ?> 
		<?= $this->Form->postLink('&nbsp;<i class="fa fa-trash fa-2" aria-hidden="true"></i>  Deletar', ['action' => 'delete', $modulo->idmodulo], ['confirm' => __('Deseja deletar # {0}?', $modulo->idmodulo),'class'=>'btn btn-primary', 'escape'=>false]) ?>
	</div>
</div>
<div class="card-body">
    <table class="vertical-table table-responsive table">
        <tr>
            <th scope="row"><?= __('Chave') ?></th>
            <td><?= h($modulo->chave) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Nome') ?></th>
            <td><?= h($modulo->nome) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Descricao') ?></th>
            <td><?= h($modulo->descricao) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Label Link') ?></th>
            <td><?= h($modulo->label_link) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Link') ?></th>
            <td><?= h($modulo->link) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Tipo Menu') ?></th>
            <td><?= h($modulo->tipo_menu) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Ativo') ?></th>
            <td><?= $this->Custom->toSimNao($modulo->ativo) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Ordem Menu') ?></th>
            <td><?= $this->Number->format($modulo->ordem_menu) ?></td>
        </tr>
    </table>
</div>
</div>
