<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Modulousuario[]|\Cake\Collection\CollectionInterface $modulousuario
 */
?>
<div class="card">
<div class="card-header">
	<h3><?= __('Módulo Usuário') ?></h3>
	<div class="float-right">
		<?= $this->Html->link(__('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar'), ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?></li>
	</div>
</div>
<div class="card-body">
    <table class="table table-responsive table-striped" cellpadding="0" cellspacing="0">
        <thead>
            <tr>
                <th scope="col">Id</th>
                <th scope="col">Módulo</th>
                <th scope="col">Usuário</th>
                <th scope="col"><?= $this->Paginator->sort('usuario_criacao') ?></th>
                <th scope="col"><?= $this->Paginator->sort('data_criacao') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($modulousuario as $modulousuario): ?>
            <tr style="cursor:pointer" onclick="window.location.href='modulousuario/view/<?=$modulousuario->idmodulousuario?>'">
                <td><?= $this->Number->format($modulousuario->idmodulousuario) ?></td>
                <td><?= $modulousuario->idmodulo." - ".$this->Custom->get('Modulo','idmodulo',$modulousuario->idmodulo)->nome ?></td>
                <td><?= $modulousuario->idusuario ." - ". $this->Custom->get('usuario','idusuario',$modulousuario->idusuario)->nome ?></td>
                <td><?= $modulousuario->usuario_criacao." - ".$this->Custom->get('usuario','idusuario',$modulousuario->usuario_criacao)->nome ?></td>
                <td><?= h($modulousuario->data_criacao) ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('primeiro')) ?>&nbsp;&nbsp;
            <?= $this->Paginator->prev('< ' . __('anterior')) ?>&nbsp;&nbsp;
            <?= $this->Paginator->numbers() ?>&nbsp;&nbsp;
            <?= $this->Paginator->next(__('próximo') . ' >') ?>&nbsp;&nbsp;
            <?= $this->Paginator->last(__('último') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(['format' => __('Página {{page}} de {{pages}}, mostrando {{current}} registros(s) de total {{count}}')]) ?></p>
    </div>
</div>
</div>
