<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Parametro $parametro
 */
?>
<div class="card">
<div class="card-header">
	<h3>Parâmetro <?= h($parametro->idparametro) ?></h3>
	<div class="float-right">
		<?= $this->Html->link('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar', ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-bars" aria-hidden="true"></i> Listar', ['action' => 'index'], ['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-edit fa-2" aria-hidden="true"></i>  Editar', ['action' => 'edit', $parametro->idparametro], ['class'=>'btn btn-primary','escape'=>false]) ?> 
		<?= $this->Form->postLink('&nbsp;<i class="fa fa-trash fa-2" aria-hidden="true"></i>  Deletar', ['action' => 'delete', $parametro->idparametro], ['confirm' => __('Deseja deletar # {0}?', $parametro->idparametro),'class'=>'btn btn-primary', 'escape'=>false]) ?>
	</div>
</div>
<div class="card-body">
    <table class="vertical-table table-responsive table">
        <tr>
            <th scope="row"><?= __('Chave') ?></th>
            <td><?= h($parametro->chave) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Descricao') ?></th>
            <td><?= h($parametro->descricao) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Valor') ?></th>
            <td><?= h($parametro->valor) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Idparametro') ?></th>
            <td><?= $this->Number->format($parametro->idparametro) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Ativo') ?></th>
            <td><?= $this->Custom->toSimNao($parametro->ativo) ?></td>
        </tr>
    </table>
</div>
</div>
