<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Perfil[]|\Cake\Collection\CollectionInterface $perfil
 */
?>
<div class="card">
<div class="card-header">
	<h3><?= __('Perfil') ?></h3>
	<div class="float-right">
		<?= $this->Html->link(__('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar'), ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?></li>
	</div>
</div>
<div class="card-body">
    <table class="table table-responsive table-striped" cellpadding="0" cellspacing="0">
        <thead>
            <tr>
                <th scope="col">Id</th>
                <th scope="col"><?= $this->Paginator->sort('perfil') ?></th>
                <th scope="col"><?= $this->Paginator->sort('descricao') ?></th>
                <th scope="col"><?= $this->Paginator->sort('pagina_inicial') ?></th>
                <th scope="col"><?= $this->Paginator->sort('ativo') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($perfil as $perfil): ?>
            <tr style="cursor:pointer" onclick="window.location.href='perfil/view/<?=$perfil->idperfil?>'">
                <td><?= $this->Number->format($perfil->idperfil) ?></td>
                <td><?= h($perfil->perfil) ?></td>
                <td><?= h($perfil->descricao) ?></td>
                <td><?= h($perfil->pagina_inicial) ?></td>
                <td><?= $this->Custom->toSimNao($perfil->ativo) ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('primeiro')) ?>
            <?= $this->Paginator->prev('< ' . __('anterior')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('próximo') . ' >') ?>
            <?= $this->Paginator->last(__('último') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(['format' => __('Página {{page}} de {{pages}}, mostrando {{current}} registros(s) de total {{count}}')]) ?></p>
    </div>
</div>
</div>
