<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Produto $produto
 */
?>
<div class="card">
<div class="card-header">
		<h3>Editar Produto <?=$produto->idproduto?></h3>
		<div class="float-right">
			<?= $this->Html->link('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar', ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?>
			<?= $this->Html->link('&nbsp;<i class="fa fa-bars" aria-hidden="true"></i> Listar', ['action' => 'index'], ['class'=>'btn btn-primary','escape'=>false]) ?>
			<?= $this->Html->link('&nbsp;<i class="fa fa-eye fa-2" aria-hidden="true"></i>  Ver', ['action' => 'view', $produto->idproduto], ['class'=>'btn btn-primary','escape'=>false]) ?> 
			<?= $this->Form->postLink('&nbsp;<i class="fa fa-trash fa-2" aria-hidden="true"></i>  Deletar', ['action' => 'delete', $produto->idproduto], ['confirm' => __('Deseja deletar # {0}?', $produto->idproduto),'class'=>'btn btn-primary', 'escape'=>false]) ?>
		</div>
</div>
	
<div class="card-body">
    <?= $this->Form->create($produto) ?>
        <?php
            echo $this->Form->control('nome',['class'=>'form-control']);
            echo $this->Form->control('descricao',['class'=>'form-control', 'type'=>'textarea', 'label'=>'Descrição']);
            echo $this->Custom->selectSimNao('ativo',$produto->ativo,true);
            echo $this->Form->control('grupo',['class'=>'form-control']);
            echo $this->Form->control('subgrupo',['class'=>'form-control']);
            echo $this->Form->control('valor',['class'=>'form-control']);
        ?>
    <br><br>
    <?= $this->Form->button(__('Enviar'),['class'=>'btn btn-primary']) ?>
    <?= $this->Form->end() ?>
</div>
</div>
