<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Produto[]|\Cake\Collection\CollectionInterface $produto
 */
?>
<div class="card">
<div class="card-header">
	<h3><?= __('Produto') ?></h3>
	<div class="float-right">
		<?= $this->Html->link(__('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar'), ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?></li>
	</div>
</div>
<div class="card-body">
    <table class="table table-responsive table-striped" cellpadding="0" cellspacing="0">
        <thead>
            <tr>
                <th scope="col">Grupo</th>
                <th scope="col">Subgrupo</th>
                <th scope="col">Nome</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($produto as $produto): ?>
            <tr style="cursor:pointer" onclick="window.location.href='produto/view/<?=$produto->idproduto?>'">
                <td><?= h($produto->grupo) ?></td>
                <td><?= h($produto->subgrupo) ?></td>
                <td><?= h($produto->nome) ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
</div>
