<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Projeto $projeto
 */
?>
<div class="card">
<div class="card-header">
		<h3>Criar Projeto</h3>
		<div class="float-right">
			<?= $this->Html->link('&nbsp;<i class="fa fa-bars" aria-hidden="true"></i> Listar', ['action' => 'index'], ['class'=>'btn btn-primary','escape'=>false]) ?>
		</div>
</div>
	
<div class="card-body">
    <?= $this->Form->create($projeto) ?>
        <?php
            echo $this->Form->control('nome',['class'=>'form-control']);
			echo "<label>Objetivo</label>";
            echo $this->Form->textarea('descricao',['class'=>'form-control']);
            echo $this->Form->control('patrocinador',['class'=>'form-control']);
            echo $this->Form->control('data_inicio', ['type'=>'text','class'=>'form-control col-md-3','label'=>'Data Início', 'data-mask'=>'00/00/0000']);
            echo $this->Form->control('data_fim', ['type'=>'text','class'=>'form-control col-md-3','label'=>'Data Fim', 'data-mask'=>'00/00/0000']);
            echo $this->Form->control('horasprevistas',['class'=>'form-control col-md-3','label'=>'Horas Previstas', 'data-mask'=>'000.00', 'data-mask-selectonfocus'=>'true']);
        ?>
		<label>Situação</label>
		<select name="situacao" class="form-control">
			<option>1 - Análise</option>
			<option>2 - Pendente de Aprovação</option>
			<option>3 - Aprovado</option>
			<option>4 - Suspenso</option>
			<option>5 - Cancelado</option>
		</select>

		<label>Fase</label>
		<select name="fase" class="form-control">
			<option>1 - Orçamentação</option>
			<option>2 - Pendente</option>
			<option>3 - Iniciação</option>
			<option>4 - Planejamento</option>
			<option>5 - Execução</option>
			<option>6 - Monitoramento e Controle</option>
			<option>7 - Encerramento</option>
			<option>8 - Pausado</option>
		</select>
			
		<label>Líder de Projeto</label>
		<select name="idusuariolider" class="form-control">
			<option value="">Nenhum</option>
			<?php 
				foreach($usuarios as $usuario){
					echo '<option value="'.$usuario->idusuario.'">'.$usuario->nome.'</option>';
				}
			?>
		</select>
		<label>Empresa</label>
		<select name="idempresa" class="form-control">
			<option value="">Nenhum</option>
			<?php 
				foreach($empresas as $empresa){
					echo '<option value="'.$empresa->idempresa.'">'.$empresa->nome.'</option>';
				}
			?>
		</select>
    <br><br>
    <?= $this->Form->button(__('Enviar'),['class'=>'btn btn-primary']) ?>
    <?= $this->Form->end() ?>
</div>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.13.4/jquery.mask.min.js"></script>