<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Projeto $projeto
 */
?>
<div class="card">
<div class="card-header">
		<h3>Editar Projeto <?=$projeto->idprojeto?></h3>
		<div class="float-right">
			<?= $this->Html->link('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar', ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?>
			<?= $this->Html->link('&nbsp;<i class="fa fa-bars" aria-hidden="true"></i> Listar', ['action' => 'index'], ['class'=>'btn btn-primary','escape'=>false]) ?>
			<?= $this->Html->link('&nbsp;<i class="fa fa-eye fa-2" aria-hidden="true"></i>  Ver', ['action' => 'view', $projeto->idprojeto], ['class'=>'btn btn-primary','escape'=>false]) ?> 
		</div>
</div>
	
<div class="card-body">
    <?= $this->Form->create($projeto) ?>
        <?php
            echo $this->Form->control('nome',['class'=>'form-control']);
			echo "<label>Objetivo</label>";
            echo $this->Form->textarea('descricao',['class'=>'form-control']);
            echo $this->Form->control('patrocinador',['class'=>'form-control']);
            echo $this->Form->control('data_inicio', ['empty' => true]);
            echo $this->Form->control('data_fim', ['empty' => true]);
            echo $this->Form->control('horasprevistas',['class'=>'form-control col-md-3','label'=>'Horas Previstas']);
        ?>

		<label>Situação</label>
		<select name="situacao" class="form-control">
			<option <?=($projeto->situacao=="1 - Análise"?"selected":"")?>>1 - Análise</option>
			<option <?=($projeto->situacao=="2 - Pendente de Aprovação"?"selected":"")?>>2 - Pendente de Aprovação</option>
			<option <?=($projeto->situacao=="3 - Aprovado"?"selected":"")?>>3 - Aprovado</option>
			<option <?=($projeto->situacao=="4 - Suspenso"?"selected":"")?>>4 - Suspenso</option>
			<option <?=($projeto->situacao=="5 - Cancelado"?"selected":"")?>>5 - Cancelado</option>
		</select>

		<label>Fase</label>
		<select name="fase" class="form-control">
			<option <?=($projeto->fase=="1 - Orçamentação"?"selected":"")?>>1 - Orçamentação</option>
			<option <?=($projeto->fase=="2 - Pendente"?"selected":"")?>>2 - Pendente</option>
			<option <?=($projeto->fase=="3 - Iniciação"?"selected":"")?>>3 - Iniciação</option>
			<option <?=($projeto->fase=="4 - Planejamento"?"selected":"")?>>4 - Planejamento</option>
			<option <?=($projeto->fase=="5 - Execução"?"selected":"")?>>5 - Execução</option>
			<option <?=($projeto->fase=="6 - Monitoramento e Controle"?"selected":"")?>>6 - Monitoramento e Controle</option>
			<option <?=($projeto->fase=="7 - Encerramento"?"selected":"")?>>7 - Encerramento</option>
			<option <?=($projeto->fase=="8 - Pausado"?"selected":"")?>>8 - Pausado</option>
		</select>
			
		<label>Líder de Projeto</label>
		<select name="idusuariolider" class="form-control">
			<option value="">Nenhum</option>
			<?php 
				foreach($usuarios as $usuario){
					$selected = ($projeto->idusuariolider==$usuario->idusuario?"selected":"");
					echo "<option value='".$usuario->idusuario."' $selected>".$usuario->nome."</option>";
				}
			?>
		</select>
		<label>Empresa</label>
		<select name="idempresa" class="form-control">
			<option value="">Nenhum</option>
			<?php 
				foreach($empresas as $empresa){
					$selected = ($projeto->idempresa==$empresa->idempresa?"selected":"");
					echo "<option value='".$empresa->idempresa."' $selected>".$empresa->nome."</option>";
				}
			?>
		</select>
    <br><br>
    <?= $this->Form->button(__('Enviar'),['class'=>'btn btn-primary']) ?>
    <?= $this->Form->end() ?>
</div>
</div>
