<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Projeto[]|\Cake\Collection\CollectionInterface $projeto
 */
?>

<style type="text/css">
    .scrolling-wrapper {
      display: flex;
      flex-wrap: nowrap;
      -webkit-overflow-scrolling: touch; 
  }
  .animate{
    transform: translate3d(0,0,0,);
    opacity: 0.5;
}

</style>
<div class="row">
    <div class="col-md-6" id="divaparecer"></div>
    <div class="col-md-12" id="divesconder" data-anime="left">
<div class="card">
    <div class="card-header">
     <h3><?= __('Projetos') ?></h3>
     <div class="float-right">
        <button onclick="abrircriar()" type="button" class="btn btn-primary"><i class="fa fa-plus"></i> Criar</button>
    </div>
</div>
<div class="card-body">

    <form method="POST">
        <div class="row">

            <div class="col-md-3">
                <b>Líder do Projeto:</b>
                <select name="idusuariolider" class="form-control">
                    <option value="-1">.: TODOS :.</option>
                    <?php 
                    foreach($usuarios as $usuario){
                        $selected = ($idusuariolider==$usuario->idusuario?"selected":"");
                        echo "<option value='".$usuario->idusuario."' $selected>".$usuario->nome."</option>";
                    }
                    ?>
                </select>
            </div>

            <div class="col-md-3">
                <b>Empresa:</b>
                <select name="idempresa" class="form-control">
                    <option value="-1">.: TODOS :.</option>
                    <?php 
                    foreach($empresas as $empresa){
                        $selected = ($idempresa==$empresa->idempresa?"selected":"");
                        echo "<option value='".$empresa->idempresa."' $selected>".$empresa->nome."</option>";
                    }
                    ?>
                </select>
            </div>
            
            <div class="col-md-3">
                <br>
                <button class="btn btn-primary" type="submit" >Enviar</button>
            </div>
        </div>
    </form>
    <br><br>

    <div class="row">

        <div style="overflow: auto;max-height:500px;">
            <div class="scrolling-wrapper">

                <div id="div1" class="col-md-3" style="background: #FFFFFF;padding-top:5px; min-width: 250px">
                    <h5><a href="javascript:void(0);" onclick="ToggleBox();"><i class="fa fa-minus-square" aria-hidden="true"></i></a>  Em Orçamentação (<?=$totalorcamentacao?>)</h5>
                    <ul style="font-size:10px;padding:0px">
                        <?php foreach($orcamentacao as $projetopainel){?>
                            <hr>
                            <div class="pull-right" style="margin-top: -10px;">
                                <?= $this->Html->link('<i class="fa fa-arrow-right" aria-hidden="true"></i>', ['action' => 'fasependente',$projetopainel->idprojeto],['class'=>'btn btn-primary btn-sm','escape'=>false]) ?>
                                <div style="margin-top: 2px;"></div>
                                <?= $this->Html->link('<i class="fa fa-pause" aria-hidden="true"></i>', ['action' => 'fasepausado',$projetopainel->idprojeto],['class'=>'btn btn-warning btn-sm','escape'=>false]) ?>
                                <div style="margin-top: 2px;"></div>
                                <button onclick="addComent(<?=$projetopainel->idprojeto?>)" type="button" class="btn btn-sm" data-toggle="modal" data-target=".bs-example-modal-sm" style="background-color: #4287f5; color: #ffffff;"><i class="fa fa-comment" aria-hidden="true" style="font-size: 10px"></i></button>

                            </div>
                            <li title="<?=$projetopainel->descricao?>" style="cursor:pointer" onclick="window.open('projeto/view/<?=$projetopainel->idprojeto?>')">

                                <b>
                                    <?=$projetopainel->nome?> - 
                                    <?php
                                    $date=date_create($projetopainel->data_criacao);
                                    echo date_format($date,"d/m/Y H:i:s");
                                    ?>
                                </b>
                                <br>

                                <?=$this->Custom->truncate2($projetopainel->descricao)?>
                                <br> 
                                <b>Qtd. Chamados:</b> <?= $projetopainel->qtdchamados ?>
                                <br>
                                <b>Patrocinador:</b> <?=$projetopainel->patrocinador?>
                                <br>
                                <b>Empresa:</b> <?=($projetopainel->idempresa)?$this->Custom->get('empresa','idempresa',$projetopainel->idempresa)->nome:''?>
                                <br>
                                <b>Líder:</b> <?=($projetopainel->idusuariolider)?$this->Custom->get('usuario','idusuario',$projetopainel->idusuariolider)->nome:''?>
                            </li>
                        <?php } ?>
                    </ul>
                </div>

                <div id="div2" class="col-md-3" style="background: rgb(242, 222, 222);padding-top:5px; min-width: 250px">
                    <h5><a href="javascript:void(0);" onclick="ToggleBox2();"><i class="fa fa-minus-square" aria-hidden="true"></i></a> Pendente (<?=$totalpendentes?>)</h5>

                    <ul style="font-size:10px;padding:0px">
                        <?php foreach($pendentes as $projetopainel){?>
                            <hr>
                            <div class="pull-right" style="margin-top: -10px;">
                                <?= $this->Html->link('<i class="fa fa-arrow-right" aria-hidden="true"></i>', ['action' => 'faseiniciacao',$projetopainel->idprojeto],['class'=>'btn btn-primary btn-sm','escape'=>false]) ?>
                                <div style="margin-top: 2px;"></div>
                                <?= $this->Html->link('<i class="fa fa-arrow-left" aria-hidden="true"></i>', ['action' => 'faseorcamentacao',$projetopainel->idprojeto],['class'=>'btn btn-primary btn-sm','escape'=>false]) ?>
                                <div style="margin-top: 2px;"></div>
                                <?= $this->Html->link('<i class="fa fa-pause" aria-hidden="true"></i>', ['action' => 'fasepausado',$projetopainel->idprojeto],['class'=>'btn btn-warning btn-sm','escape'=>false]) ?>
                                <div style="margin-top: 2px;"></div>
                                <button onclick="addComent(<?=$projetopainel->idprojeto?>)" type="button" class="btn btn-sm" data-toggle="modal" data-target=".bs-example-modal-sm" style="background-color: #4287f5; color: #ffffff;"><i class="fa fa-comment" aria-hidden="true" style="font-size: 10px"></i></button>

                            </div>
                            <li title="<?=$projetopainel->descricao?>" style="cursor:pointer" onclick="window.open('projeto/view/<?=$projetopainel->idprojeto?>')">

                                <b>
                                    <?=$projetopainel->nome?> - 
                                    <?php
                                    $date=date_create($projetopainel->data_criacao);
                                    echo date_format($date,"d/m/Y H:i:s");
                                    ?>
                                </b>
                                <br>

                                <?=$this->Custom->truncate2($projetopainel->descricao)?>
                                <br> 
                                <b>Qtd. Chamados:</b> <?= $projetopainel->qtdchamados ?>
                                <br>
                                <b>Patrocinador:</b> <?=$projetopainel->patrocinador?>
                                <br>
                                <b>Empresa:</b> <?=($projetopainel->idempresa)?$this->Custom->get('empresa','idempresa',$projetopainel->idempresa)->nome:''?>
                                <br>
                                <b>Líder:</b> <?=($projetopainel->idusuariolider)?$this->Custom->get('usuario','idusuario',$projetopainel->idusuariolider)->nome:''?>
                            </li>
                        <?php } ?>
                    </ul>
                </div>

                <div id="div3" class="col-md-3" style="background: rgb(178, 224, 247);padding-top:5px; min-width: 250px">
                    <h5><a href="javascript:void(0);" onclick="ToggleBox3();"><i class="fa fa-minus-square" aria-hidden="true"></i></a> Em Iniciação (<?=$totaliniciacao?>)</h5>
                    <ul style="font-size:10px;padding:0px">
                        <?php foreach($iniciacao as $projetopainel){?>
                            <hr>
                            <div class="pull-right" style="margin-top: -10px;">
                                <?= $this->Html->link('<i class="fa fa-arrow-right" aria-hidden="true"></i>', ['action' => 'faseplanejamento',$projetopainel->idprojeto],['class'=>'btn btn-primary btn-sm','escape'=>false]) ?>
                                <div style="margin-top: 2px;"></div>
                                <?= $this->Html->link('<i class="fa fa-arrow-left" aria-hidden="true"></i>', ['action' => 'fasependente',$projetopainel->idprojeto],['class'=>'btn btn-primary btn-sm','escape'=>false]) ?>
                                <div style="margin-top: 2px;"></div>
                                <?= $this->Html->link('<i class="fa fa-pause" aria-hidden="true"></i>', ['action' => 'fasepausado',$projetopainel->idprojeto],['class'=>'btn btn-warning btn-sm','escape'=>false]) ?>
                                <div style="margin-top: 2px;"></div>
                                <button onclick="addComent(<?=$projetopainel->idprojeto?>)" type="button" class="btn btn-sm" data-toggle="modal" data-target=".bs-example-modal-sm" style="background-color: #4287f5; color: #ffffff;"><i class="fa fa-comment" aria-hidden="true" style="font-size: 10px"></i></button>

                            </div>
                            <li title="<?=$projetopainel->descricao?>" style="cursor:pointer" onclick="window.open('projeto/view/<?=$projetopainel->idprojeto?>')">

                                <b>
                                    <?=$projetopainel->nome?> - 
                                    <?php
                                    $date=date_create($projetopainel->data_criacao);
                                    echo date_format($date,"d/m/Y H:i:s");
                                    ?>
                                </b>
                                <br>

                                <?=$this->Custom->truncate2($projetopainel->descricao)?>
                                <br> 
                                <b>Qtd. Chamados:</b> <?= $projetopainel->qtdchamados ?>
                                <br>
                                <b>Patrocinador:</b> <?=$projetopainel->patrocinador?>
                                <br>
                                <b>Empresa:</b> <?=($projetopainel->idempresa)?$this->Custom->get('empresa','idempresa',$projetopainel->idempresa)->nome:''?>
                                <br>
                                <b>Líder:</b> <?=($projetopainel->idusuariolider)?$this->Custom->get('usuario','idusuario',$projetopainel->idusuariolider)->nome:''?>
                            </li>
                        <?php } ?>
                    </ul>
                </div>

                <div id="div4" class="col-md-3" style="background: rgb(255, 245, 199);padding-top:5px; min-width: 250px">
                    <h5><a href="javascript:void(0);" onclick="ToggleBox4();"><i class="fa fa-minus-square" aria-hidden="true"></i></a> Em Planejamento (<?=$totalplanejamento?>)</h5>
                    <ul style="font-size:10px;padding:0px">
                        <?php foreach($planejamento as $projetopainel){?>
                            <hr>
                            <div class="pull-right" style="margin-top: -10px;">
                                <?= $this->Html->link('<i class="fa fa-arrow-right" aria-hidden="true"></i>', ['action' => 'faseexecucao',$projetopainel->idprojeto],['class'=>'btn btn-primary btn-sm','escape'=>false]) ?>
                                <div style="margin-top: 2px;"></div>
                                <?= $this->Html->link('<i class="fa fa-arrow-left" aria-hidden="true"></i>', ['action' => 'faseiniciacao',$projetopainel->idprojeto],['class'=>'btn btn-primary btn-sm','escape'=>false]) ?>
                                <div style="margin-top: 2px;"></div>
                                <?= $this->Html->link('<i class="fa fa-pause" aria-hidden="true"></i>', ['action' => 'fasepausado',$projetopainel->idprojeto],['class'=>'btn btn-warning btn-sm','escape'=>false]) ?>
                                <div style="margin-top: 2px;"></div>
                                <button onclick="addComent(<?=$projetopainel->idprojeto?>)" type="button" class="btn btn-sm" data-toggle="modal" data-target=".bs-example-modal-sm" style="background-color: #4287f5; color: #ffffff;"><i class="fa fa-comment" aria-hidden="true" style="font-size: 10px"></i></button>

                            </div>
                            <li title="<?=$projetopainel->descricao?>" style="cursor:pointer" onclick="window.open('projeto/view/<?=$projetopainel->idprojeto?>')">

                                <b>
                                    <?=$projetopainel->nome?> - 
                                    <?php
                                    $date=date_create($projetopainel->data_criacao);
                                    echo date_format($date,"d/m/Y H:i:s");
                                    ?>
                                </b>
                                <br>

                                <?=$this->Custom->truncate2($projetopainel->descricao)?>
                                <br> 
                                <b>Qtd. Chamados:</b> <?= $projetopainel->qtdchamados ?>
                                <br>
                                <b>Patrocinador:</b> <?=$projetopainel->patrocinador?>
                                <br>
                                <b>Empresa:</b> <?=($projetopainel->idempresa)?$this->Custom->get('empresa','idempresa',$projetopainel->idempresa)->nome:''?>
                                <br>
                                <b>Líder:</b> <?=($projetopainel->idusuariolider)?$this->Custom->get('usuario','idusuario',$projetopainel->idusuariolider)->nome:''?>
                            </li>
                        <?php } ?>
                    </ul>
                </div>

                <div id="div5" class="col-md-3" style="background: rgb(216, 252, 179);padding-top:5px; min-width: 250px">
                    <h5><a href="javascript:void(0);" onclick="ToggleBox5();"><i class="fa fa-minus-square" aria-hidden="true"></i></a> Em Execução (<?=$totalexecucao?>)</h5>
                    <ul style="font-size:10px;padding:0px">
                        <?php foreach($execucao as $projetopainel){?>
                            <hr>
                            <div class="pull-right" style="margin-top: -10px;">
                                <?= $this->Html->link('<i class="fa fa-arrow-right" aria-hidden="true"></i>', ['action' => 'fasemonitoramento',$projetopainel->idprojeto],['class'=>'btn btn-primary btn-sm','escape'=>false]) ?>
                                <div style="margin-top: 2px;"></div>
                                <?= $this->Html->link('<i class="fa fa-arrow-left" aria-hidden="true"></i>', ['action' => 'faseorplanejamento',$projetopainel->idprojeto],['class'=>'btn btn-primary btn-sm','escape'=>false]) ?>
                                <div style="margin-top: 2px;"></div>
                                <?= $this->Html->link('<i class="fa fa-pause" aria-hidden="true"></i>', ['action' => 'fasepausado',$projetopainel->idprojeto],['class'=>'btn btn-warning btn-sm','escape'=>false]) ?>
                                <div style="margin-top: 2px;"></div>
                                <button onclick="addComent(<?=$projetopainel->idprojeto?>)" type="button" class="btn btn-sm" data-toggle="modal" data-target=".bs-example-modal-sm" style="background-color: #4287f5; color: #ffffff;"><i class="fa fa-comment" aria-hidden="true" style="font-size: 10px"></i></button>

                            </div>
                            <li title="<?=$projetopainel->descricao?>" style="cursor:pointer" onclick="window.open('projeto/view/<?=$projetopainel->idprojeto?>')">
                                <div class="progress mt-1 mb-0" style="height: 12px;margin:0px !important">
                                    <div class="progress-bar bg-primary" role="progressbar" style="margin-right:5px;width: <?=$projetopainel->status?>%" aria-valuenow="<?=$projetopainel->status?>" aria-valuemin="0" aria-valuemax="100">
                                        <?=$projetopainel->status?>%
                                    </div>
                                </div>
                                <b>
                                    <?=$projetopainel->nome?> - 
                                    <?php
                                    $date=date_create($projetopainel->data_criacao);
                                    echo date_format($date,"d/m/Y H:i:s");
                                    ?>
                                </b>
                                <br>
                                <?=$this->Custom->truncate2($projetopainel->descricao)?>
                                <br> 
                                <b>Qtd. Chamados:</b> <?= $projetopainel->qtdchamados ?>
                                <br>
                                <b>Patrocinador:</b> <?=$projetopainel->patrocinador?>
                                <br>
                                <b>Empresa:</b> <?=($projetopainel->idempresa)?$this->Custom->get('empresa','idempresa',$projetopainel->idempresa)->nome:''?>
                                <br>
                                <b>Líder:</b> <?=($projetopainel->idusuariolider)?$this->Custom->get('usuario','idusuario',$projetopainel->idusuariolider)->nome:''?>
                            </li>
                        <?php } ?>
                    </ul>
                </div>

                <div id="div6" class="col-md-3" style="background:rgb(223, 240, 216);padding-top:5px; min-width: 250px">
                    <h5><a href="javascript:void(0);" onclick="ToggleBox6();"><i class="fa fa-minus-square" aria-hidden="true"></i></a> 6 - Monit. e Controle (<?=$totalmonitoramento?>)</h5>
                    <ul style="font-size:10px;padding:0px">
                        <?php foreach($monitoramento as $projetopainel){?>
                            <hr>
                            <div class="pull-right" style="margin-top: -10px;">
                                <?= $this->Html->link('<i class="fa fa-arrow-right" aria-hidden="true"></i>', ['action' => 'faseencerramento',$projetopainel->idprojeto],['class'=>'btn btn-primary btn-sm','escape'=>false]) ?>
                                <div style="margin-top: 2px;"></div>
                                <?= $this->Html->link('<i class="fa fa-arrow-left" aria-hidden="true"></i>', ['action' => 'faseexecucao',$projetopainel->idprojeto],['class'=>'btn btn-primary btn-sm','escape'=>false]) ?>
                                <div style="margin-top: 2px;"></div>
                                <?= $this->Html->link('<i class="fa fa-pause" aria-hidden="true"></i>', ['action' => 'fasepausado',$projetopainel->idprojeto],['class'=>'btn btn-warning btn-sm','escape'=>false]) ?>
                                <div style="margin-top: 2px;"></div>
                                <button onclick="addComent(<?=$projetopainel->idprojeto?>)" type="button" class="btn btn-sm" data-toggle="modal" data-target=".bs-example-modal-sm" style="background-color: #4287f5; color: #ffffff;"><i class="fa fa-comment" aria-hidden="true" style="font-size: 10px"></i></button>

                            </div>
                            <li title="<?=$projetopainel->descricao?>" style="cursor:pointer" onclick="window.open('projeto/view/<?=$projetopainel->idprojeto?>')">

                                <b>
                                    <?=$projetopainel->nome?> - 
                                    <?php
                                    $date=date_create($projetopainel->data_criacao);
                                    echo date_format($date,"d/m/Y H:i:s");
                                    ?>
                                </b>
                                <br>
                                <?=$this->Custom->truncate2($projetopainel->descricao)?>
                                <br>
                                <b>Qtd. Chamados:</b> <?= $projetopainel->qtdchamados ?>
                                <br>
                                <b>Patrocinador:</b> <?=$projetopainel->patrocinador?>
                                <br>
                                <b>Empresa:</b> <?=($projetopainel->idempresa)?$this->Custom->get('empresa','idempresa',$projetopainel->idempresa)->nome:''?>
                                <br>
                                <b>Líder:</b> <?=($projetopainel->idusuariolider)?$this->Custom->get('usuario','idusuario',$projetopainel->idusuariolider)->nome:''?>
                            </li>
                        <?php } ?>
                    </ul>
                </div>

                <div id="div7" class="col-md-3" style="background:rgb(171, 235, 155);padding-top:5px; min-width: 250px">
                    <h5><a href="javascript:void(0);" onclick="ToggleBox7();"><i class="fa fa-minus-square" aria-hidden="true"></i></a> Encerrados (<?=$totalencerramento?>)</h5>
                    <ul style="font-size:10px;padding:0px">
                        <?php foreach($encerramento as $projetopainel){?>
                            <hr>
                            <li title="<?=$projetopainel->descricao?>" style="cursor:pointer" onclick="window.open('projeto/view/<?=$projetopainel->idprojeto?>')">

                                <b>
                                    <?=$projetopainel->nome?> - 
                                    <?php
                                    $date=date_create($projetopainel->data_criacao);
                                    echo date_format($date,"d/m/Y H:i:s");
                                    ?>
                                </b>
                                <br>
                                <?=$this->Custom->truncate2($projetopainel->descricao)?>
                                <br>
                                <b>Qtd. Chamados:</b> <?= $projetopainel->qtdchamados ?>
                                <br>
                                <b>Patrocinador:</b> <?=$projetopainel->patrocinador?>
                                <br>
                                <b>Empresa:</b> <?=($projetopainel->idempresa)?$this->Custom->get('empresa','idempresa',$projetopainel->idempresa)->nome:''?>
                                <br>
                                <b>Líder:</b> <?=($projetopainel->idusuariolider)?$this->Custom->get('usuario','idusuario',$projetopainel->idusuariolider)->nome:''?>
                            </li>
                        <?php } ?>
                    </ul>
                </div>

                <div id="div8" class="col-md-3" style="background:rgb(252, 228, 167);padding-top:5px; min-width: 250px">
                    <h5><a href="javascript:void(0);" onclick="ToggleBox8();"><i class="fa fa-minus-square" aria-hidden="true"></i></a> Pausados (<?=$totalpausados?>)</h5>
                    <ul style="font-size:10px;padding:0px">
                        <?php foreach($pausados as $projetopainel){?>
                            <hr>
                            <li title="<?=$projetopainel->descricao?>" style="cursor:pointer" onclick="window.open('projeto/view/<?=$projetopainel->idprojeto?>')">

                                <b>
                                    <?=$projetopainel->nome?> - 
                                    <?php
                                    $date=date_create($projetopainel->data_criacao);
                                    echo date_format($date,"d/m/Y H:i:s");
                                    ?>
                                </b>
                                <br>
                                <?=$this->Custom->truncate2($projetopainel->descricao)?>
                                <br>
                                <b>Qtd. Chamados:</b> <?= $projetopainel->qtdchamados ?>
                                <br>
                                <b>Patrocinador:</b> <?=$projetopainel->patrocinador?>
                                <br>
                                <b>Empresa:</b> <?=($projetopainel->idempresa)?$this->Custom->get('empresa','idempresa',$projetopainel->idempresa)->nome:''?>
                                <br>
                                <b>Líder:</b> <?=($projetopainel->idusuariolider)?$this->Custom->get('usuario','idusuario',$projetopainel->idusuariolider)->nome:''?>
                            </li>
                        <?php } ?>
                    </ul>
                </div>

            </div>
        </div>
    </div>

    <div class="modal fade bs-example-modal-sm" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
      <div class="modal-dialog modal-sm" role="document">
        <div class="modal-content">
            <div style="margin:50px">
              <form action="" method="POST" enctype="multipart/form-data">
                <input type="hidden" name="projetoidmodal" id="projetoidmodal" value="" />
                <textarea placeholder="observação" class="form-control" name="observacao" maxlength="8000"></textarea>
                <div style="margin-top:5px; margin-bottom: 15px; ">
                    <a data-toggle="collapse" href="#collapseExample" aria-expanded="false" aria-controls="collapseExample">
                      <i class="fa fa-plus-circle" aria-hidden="true"></i> <spam data-toggle="tooltip" data-placement="top" title="Campo expresso em horas. Ex.: 01h:30m equivale a 01.50h">Adicionar Horas Trabalhadas</spam>
                  </a>
                  <div class="collapse" id="collapseExample">
                      <div class="well">
                        <div class="form-group">
                            <input type="text" name="horastrabalhadas" class="form-control col-md-6" data-mask="00.00" data-mask-selectonfocus="true" >
                        </div>
                    </div>
                </div>
            </div>
            <input type="hidden" name="MAX_FILE_SIZE" value="10485760" />
            <input name='arquivo' type='file'/>
            <br><br>
            <?= $this->Form->button(__('Cadastrar observação'),['class'=>'btn btn-primary']) ?>
        </form>
    </div>
</div>
</div>
</div>



<br><br>
<div class="row">
    <div class="col-md-12">
        <h5>Todos os Projetos</h5>

        <table style="font-size:11px" class="table table-responsive table-striped datatable" cellpadding="0" cellspacing="0">
            <thead>
                <tr>
                    <th scope="col"></th>
                    <th scope="col">Nome</th>
                    <th scope="col">Concluído</th>
                    <th scope="col">Fase</th>
                    <th scope="col">Empresa</th>
                    <th scope="col">Data Criação</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($projeto as $projeto): ?>
                    <tr style="cursor:pointer" onclick="window.location.href='projeto/view/<?=$projeto->idprojeto?>'">
                        <td><?= $projeto->idprojeto ?></td>
                        <td><?= h($projeto->nome) ?></td>
                        <td>
                            <?php $sql = "SELECT 
                                CASE WHEN COUNT(idchamado) = 0 THEN 1 ELSE COUNT(idchamado) END as qtdchamados
                                ,(SELECT COUNT(idchamado) from chamado where idchamadostatus in (5,8) and idprojeto = $projeto->idprojeto) as qtdfinalizados
                                from chamado where idprojeto = $projeto->idprojeto";

                                $percentual = $this->Custom->query($sql)[0];
                                $totpercentual = ($percentual->qtdfinalizados/$percentual->qtdchamados)*100;
                                echo round($totpercentual,2);?>%
                        </td>
                        <td><?= h($projeto->fase) ?></td>
                        <td><?= $this->Custom->get('empresa','idempresa',$projeto->idempresa)->nome ?></td>
                        <td><?= h($projeto->data_criacao) ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>

    </div>
</div>
</div>
</div>
</div>
</div>


<script>
    $('td').css('padding','3px');

    function addComent(id) {
     $('#projetoidmodal').val(id);
 }
</script>

<script>
    function abrircriar(){
    // $("#divesconder").fadeTo("slow", 0.5);
    $("#divesconder").css({"opacity": 0, "transform": "translate3d(100px, 0, 0)", "transition": ".3s"});
    setTimeout(function() { 
        $('#divesconder').attr('class', 'col-md-6 animate');
    }, 100);
    setTimeout(function() { 
        $('#divesconder').removeAttr('style');
    }, 300);
    
    $('#divaparecer').load("./projeto/add",function(){
       $('#divaparecer').hide().fadeIn('slow');
   });

}
</script>

<script type="text/javascript">
    function ToggleBox()
    {
        $("#div1").slideToggle("slow"); 

    }

    function ToggleBox2()
    {
        $("#div2").slideToggle("slow");
    }

    function ToggleBox3()
    {
        $("#div3").slideToggle("slow");
    }

    function ToggleBox4()
    {
        $("#div4").slideToggle("slow");
    }

    function ToggleBox5()
    {
        $("#div5").slideToggle("slow");
    }

    function ToggleBox6()
    {
        $("#div6").slideToggle("slow");
    }

    function ToggleBox7()
    {
        $("#div7").slideToggle("slow");
    }

    function ToggleBox8()
    {
        $("#div8").slideToggle("slow");
    }


</script>

<script>
setTimeout(function() { 
    $(".datatable").DataTable({
        "order": [[ 0, "desc" ]],
        responsive: false,
        retrieve: false,
        paging : true,
        scroll : false,
        searching: true,
        fixedHeader: {
          header: true,
          footer: false
        },
        language: {
                url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
                decimal: ",",
                thousands: "."
            },
            buttons: [
                {
                  extend: 'copy',
                  text: 'Copiar'
                },
                {
                  extend: 'print',
                  text: 'Imprimir',
                  messageTop: 'Relatório: ',
                },
                {
                  extend: 'excel',
                  text: 'Excel',
                  messageTop: 'Relatório:',
                },
                {
                  extend: 'pdf',
                  text: 'PDF',
                  messageTop: 'Relatório: ',
                }
            ],
            dom: 'Bfrtip'
    });
}, 500);
$('.datatable td').css('padding','3px');
</script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.13.4/jquery.mask.min.js"></script>

