<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Projeto $projeto
 */
?>
<div class="card">
<div class="card-header">
	<div class="float-left">
    </div>
	<div class="float-right">
    <?= $this->Html->link('&nbsp;<i class="fa fa-plus-circle fa-2" aria-hidden="true"></i> Criar Chamado', ['controller'=>'chamado','action' => 'addchamadoprojeto', $projeto->idprojeto],['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar', ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-bars" aria-hidden="true"></i> Listar', ['action' => 'index'], ['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-edit fa-2" aria-hidden="true"></i>  Editar', ['action' => 'edit', $projeto->idprojeto], ['class'=>'btn btn-primary','escape'=>false]) ?> 
		<?= $this->Form->postLink('&nbsp;<i class="fa fa-trash fa-2" aria-hidden="true"></i>  Deletar', ['action' => 'delete', $projeto->idprojeto], ['confirm' => __('Deseja deletar # {0}?', $projeto->idprojeto),'class'=>'btn btn-primary', 'escape'=>false]) ?>
	</div>
</div>


    <div class="card-body">
        <div class="row">
           <div class="col-lg-6 col-xl-2 col-sm-6 col-12 border-right-blue-grey border-right-lighten-5 p-0 m-1">
            <div class="d-flex align-items-start ">
              <span class="card-icon warning d-flex justify-content-center">
                <i class="icon p-1 icon-clock customize-icon font-large-2 p-1"></i>
              </span>
              <div class="stats-amount">
                <h3 class="heading-text text-bold-600"><?=$projeto->horasprevistas ? $projeto->horasprevistas : "0.00" ?></h3>
                <p class="sub-heading">Horas <br>Projeto</p>
              </div>
              
            </div>
          </div>
         <div class="col-lg-6 col-xl-2 col-sm-6 col-12 border-right-blue-grey border-right-lighten-5 p-0 m-1">
            <div class="d-flex align-items-start ">
              <span class="card-icon primary d-flex justify-content-center">
                <i class="icon p-1 icon-clock customize-icon font-large-2 p-1"></i>
              </span>
              <div class="stats-amount">
                <h3 class="heading-text text-bold-600"><?=$horasprevistaschamados ? $horasprevistaschamados : "0.00" ?></h3>
                <p class="sub-heading">Horas <br>Previstas</p>
              </div>
              
            </div>
          </div>
          <div class="col-lg-6 col-xl-2 col-sm-6 col-12 border-right-blue-grey border-right-lighten-5 p-0 m-1">
            <div class="d-flex align-items-start ">
              <span class="card-icon success d-flex justify-content-center">
                <i class="icon p-1 icon-clock customize-icon font-large-2 p-1"></i>
              </span>
              <div class="stats-amount">
                <h3 class="heading-text text-bold-600"><?=$totalhoras?></h3>
                <p class="sub-heading">Horas <br>Realizadas</p>
              </div>
              
            </div>
          </div>
          <div class="col-lg-6 col-xl-2 col-sm-6 col-12 border-right-blue-grey border-right-lighten-5 p-0 m-1">
            <div class="d-flex align-items-start ">
              <span class="card-icon primary d-flex justify-content-center">
                <i class="icon p-1 icon-cup customize-icon font-large-2 p-1"></i>
              </span>
              <div class="stats-amount">
                <h3 class="heading-text text-bold-600"><?=$qtdchamados?></h3>
                <p class="sub-heading">Quantidade <br>Atividades</p>
              </div>
              
            </div>
          </div>
          <div class="col-lg-6 col-xl-2 col-sm-6 col-12 p-0 m-1">
            <div class="d-flex align-items-start">
              <span class="card-icon warning d-flex justify-content-center">
                <i class="icon p-1 icon-graph customize-icon font-large-2 p-1"></i>
              </span>
              <div class="stats-amount">
                <h3 class="heading-text text-bold-600"><?=round($totpercentual,2)?>%</h3>
                <p class="sub-heading"> Percentual <br>Concluído</p>
              </div>
              
            </div>
          </div>
        </div>
      

	<div class="row">
	<div class="col-md-6">
	<h4>Projeto <?= h($projeto->idprojeto) ?></h4>
    <table class="table-responsive table">
        <tr><td><b><?= __('Nome') ?></b><br><?= h($projeto->nome) ?></td>
        </tr>
        <tr><td><b><?= __('Objetivo') ?></b><br><?= $this->Custom->textoLink(nl2br($projeto->descricao)) ?></td>
        </tr>
        <tr><td><b><?= __('Patrocinador') ?></b><br><?= h($projeto->patrocinador) ?></td>
        </tr>
        <tr><td><b><?= __('Situação') ?></b><br><?= h($projeto->situacao) ?></td>
        </tr>
        <tr><td><b><?= __('Fase') ?></b><br><?= h($projeto->fase) ?></td>
        </tr>
        <tr><td><b>Líder de Projeto</b><br><?= $this->Custom->get('usuario','idusuario',$projeto->idusuariolider)->nome ?></td>
        </tr>
        <tr><td><b>Empresa</b><br><?= $this->Custom->get('empresa','idempresa',$projeto->idempresa)->nome ?></td>
        </tr>
        <tr><td><b><?= __('Data Início') ?></b><br><?= h($projeto->data_inicio) ?></td>
        </tr>
        <tr><td><b><?= __('Data Fim') ?></b><br><?= h($projeto->data_fim) ?></td>
        </tr>
        <tr><td><b><?= __('Data Criação') ?></b><br><?= h($projeto->data_criacao) ?></td>
        </tr>
    </table>
	</div>
	
	<div class="col-md-6" style="overflow-y: auto; height: 700px;">
	<h4>Observações</h4>
<!-- 	<form action="" method="POST" enctype="multipart/form-data">
	<textarea placeholder="observação" class="form-control" name="observacao" maxlength="8000"></textarea>
	<br>
	<?= $this->Form->button(__('Cadastrar observação'),['class'=>'btn btn-primary']) ?>
</form> -->
		<form action="" method="POST" enctype="multipart/form-data">
        <textarea placeholder="observação" class="form-control" name="observacao" maxlength="8000"></textarea>
        <div style="margin-top:5px; margin-bottom: 15px; ">
            <a data-toggle="collapse" href="#collapseExample" aria-expanded="false" aria-controls="collapseExample">
              <i class="fa fa-plus-circle" aria-hidden="true"></i> <spam data-toggle="tooltip" data-placement="top" title="Campo expresso em horas. Ex.: 01h:30m equivale a 01.50h">Adicionar Horas Trabalhadas</spam>
            </a>
            <div class="collapse" id="collapseExample">
              <div class="well">
                <div class="form-group">
                <input type="text" name="horastrabalhadas" class="form-control col-md-6" data-mask="00.00" data-mask-selectonfocus="true" >
                </div>
              </div>
            </div>
        </div>
        <input type="hidden" name="MAX_FILE_SIZE" value="10485760" />
                <input name='arquivo' type='file'/>
        <br><br>
        <?= $this->Form->button(__('Cadastrar observação'),['class'=>'btn btn-primary']) ?>
    </form>

	<br><br>
	<table class="table-responsive table">
		<?php foreach($projetoobs as $item){?>
			<tr>
				<td style="text-align:justify">
					<i class="fa fa-user"></i><b> <?=$this->Custom->get('usuario','idusuario',$item->idusuario)->nome?></b><br>
					<?=$item->data_criacao?>
					<br>
					<i class="fa fa-comment"></i> 
					<?=$this->Custom->textoLink(nl2br($item->observacao."<br>"))?>
					

                    <?php if($item->horastrabalhadas > 0){
                        echo $item->horastrabalhadas . " Horas trabalhadas<br>";

                     } ?>
                    
                    <?php
                        $tmp = explode(".",$item->arquivo);
                        $extensao = end($tmp);
                            if(strlen($item->arquivo)>0 && (in_array($extensao, ['jpg','jpeg','png','gif','JPG','JPEG','PNG','GIF']))){ ;?>
                                <a target="_BLANK" href="<?=$this->request->base?>/../arquivos/flygestor/<?=$projeto->idprojeto.'/'.$item->arquivo?>">
                                <img style="width:100%" src="<?=$this->request->base?>/../arquivos/flygestor/<?=$projeto->idprojeto.'/'.$item->arquivo?>">
                            <i class="fa fa-download" aria-hidden="true"></i> <span><i><?=$item->arquivo?><i></span></a><br>
                                <?php } else if (strlen($item->arquivo)>0){ ?>
                                   <a target="_BLANK" href="<?=$this->request->base?>/../arquivos/flygestor/<?=$projeto->idprojeto.'/'.$item->arquivo?>">
                                <i class="fa fa-download" aria-hidden="true"></i> <span><i><?=$item->arquivo?><i></span></a> <br>
                                <?php } ?>
                             
					
				</td>
				<?php if($item->log != 1){ ?>
				<td>
					<?= $this->Html->link('&nbsp;<i class="fa fa-edit fa-2" aria-hidden="true"></i>', ['controller'=>'projetoobs','action' => 'edit', $item->idprojetoobs], ['class'=>'btn btn-primary btn-sm','escape'=>false]) ?> 
					<?= $this->Form->postLink('&nbsp;<i class="fa fa-trash fa-2" aria-hidden="true"></i>', ['controller'=>'projetoobs','action' => 'delete', $item->idprojetoobs], ['confirm' => __('Deseja deletar # {0}?', $item->idprojetoobs),'class'=>'btn btn-danger btn-sm', 'escape'=>false]) ?>
				</td>
				<?php } ?>
			</tr>
		<?php } ?>
	</table>
	
	
	</div>
	</div>
	
<br><br>
<div class="row">
    <div class="col-md-12">
	
	<h4>Chamados (<?= $chamado->count() ?>)</h4>
	<table style="font-size:11px" class="table table-responsive table-striped datatable" cellpadding="0" cellspacing="0">
        <thead>
            <tr>
                <th scope="col">Cod.</th>
				        <th scope="col">Empresa</th>
                <th scope="col">Atendente</th>
                <th scope="col">Assunto</th>
                <th scope="col">Status</th>
                <th scope="col">Percentual</th>
				        <th scope="col">Data Prevista</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($chamado as $chamado): ?>
            <tr style="cursor:pointer" onclick="window.open('../../chamado/view/<?=$chamado->idchamado?>')">
                <td><?= $this->Number->format($chamado->idchamado) ?></td>
                <td><?php 
					if(strlen($chamado->idempresa) > 0){
						echo $this->Custom->get('empresa','idempresa',$chamado->idempresa)->nome;
					}
				?></td>
				<td><?php echo ($chamado->idusuario_atendimento)?$this->Custom->get('usuario','idusuario',$chamado->idusuario_atendimento)->nome:''?></td>
                <td><?= h($chamado->assunto) ?></td>
                <td><?php 
                    if(strlen($chamado->idchamadostatus) > 0){
                        echo $chamado->idchamadostatus." - ".$this->Custom->get('chamadostatus','idchamadostatus',$chamado->idchamadostatus)->descricao;
                    }
                ?></td>
                <td><?= $chamado->percentual ?>%</td>
                <td><?= h($chamado->data_prevista) ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
</div>
</div>

<script>
setTimeout(function() { 
    $(".datatable").DataTable({
        "ordering": true,
        responsive: false,
        retrieve: false,
        paging : true,
        scroll : false,
        searching: true,
        fixedHeader: {
          header: true,
          footer: false
        },
        language: {
                url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
                decimal: ",",
                thousands: "."
            },
            buttons: [
                {
                  extend: 'copy',
                  text: 'Copiar'
                },
                {
                  extend: 'print',
                  text: 'Imprimir',
                  messageTop: 'Relatório: ',
                },
                {
                  extend: 'excel',
                  text: 'Excel',
                  messageTop: 'Relatório:',
                },
                {
                  extend: 'pdf',
                  text: 'PDF',
                  messageTop: 'Relatório: ',
                }
            ],
            dom: 'Bfrtip'
    });
}, 500);
$('.datatable td').css('padding','3px');
</script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.13.4/jquery.mask.min.js"></script>