<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Projetoob[]|\Cake\Collection\CollectionInterface $projetoobs
 */
?>
<div class="card">
<div class="card-header">
	<h3><?= __('Projetoobs') ?></h3>
	<div class="float-right">
		<?= $this->Html->link(__('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar'), ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?></li>
	</div>
</div>
<div class="card-body">
    <table class="table table-responsive table-striped" cellpadding="0" cellspacing="0">
        <thead>
            <tr>
                <th scope="col"><?= $this->Paginator->sort('idprojetoobs') ?></th>
                <th scope="col"><?= $this->Paginator->sort('idprojeto') ?></th>
                <th scope="col"><?= $this->Paginator->sort('idusuario') ?></th>
                <th scope="col"><?= $this->Paginator->sort('observacao') ?></th>
                <th scope="col"><?= $this->Paginator->sort('data_criacao') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($projetoobs as $projetoob): ?>
            <tr style="cursor:pointer" onclick="window.location.href='projetoob/view/<?=$projetoob->idprojetoobs?>'">
                <td><?= $this->Number->format($projetoob->idprojetoobs) ?></td>
                <td><?= $this->Number->format($projetoob->idprojeto) ?></td>
                <td><?= $this->Number->format($projetoob->idusuario) ?></td>
                <td><?= h($projetoob->observacao) ?></td>
                <td><?= h($projetoob->data_criacao) ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('primeiro')) ?>
            <?= $this->Paginator->prev('< ' . __('anterior')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('próximo') . ' >') ?>
            <?= $this->Paginator->last(__('último') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(['format' => __('Página {{page}} de {{pages}}, mostrando {{current}} registros(s) de total {{count}}')]) ?></p>
    </div>
</div>
</div>
