<?php
  $this->layout = false;
  
  $date = new DateTime();
  $dataHora = $date->format('d/m/Y H:i:s');
  $dataTraco = $date->format('d-m-Y');
  $dataBarra = $date->format('d/m/Y');
  $session = $this->request->session();
  $totalRegistros = count($arr);
  $usuario = $session->read('login.usuario')->nome;
  
?>
	<table style="font-size:12px">
		<tr>
			
			<td>
				<b>Relatório:</b> <?=$nomeRelatorio?>
				<br>
				<b>Emissão:</b> <?=$dataHora?>
				<br>
				<b>Usuário:</b> <?=$usuario?>
				<br>
				<b>Período:</b> <?=$periodo?>
				<br>
				<b>Total de registros:</b> <?=$totalRegistros?>
				
			</td>
		</tr>
	</table>
	<?php if(isset($arrResumo) && count($arrResumo) > 0){?>
	<div class="card-subtitle line-on-side text-muted text-center font-medium-1 mx-2 my-1 primary">
		<span>Resumo</span>
	</div>
	
	<table style="font-size:10px" class="table table-responsive table-striped table-bordered" id="datatable1">
		<thead>
			<tr>
				<th></th>
				<?php
					foreach ($colunasResumo as $key=>$item){
						echo "<th>$item</th>";
					}
				?>
			</tr>
		</thead>
		<tbody>
			<?php
				$counterColuna = 0;
				foreach ($arrResumo as $key=>$item){
					$item = (array) $item;
					$onclick = "";
					if($idregistroResumo == null){
						echo "<tr>";
					}else{
						echo "<tr style='cursor:pointer'>";
						$onclick = "onclick='window.open(\"$linkRegistroResumo".$item[$idregistroResumo]."\")'";
					}
					
					echo "<td style='padding:7px;text-align:right'>".($key+1)."</td>";
					$counterColuna = 0;
					foreach($item as $subkey=>$subitem){
						//terminar com _ pula o registro
						if($this->Custom->endsWith($subkey,"_")){
							continue;
						}
						echo "<td $onclick style='white-space: nowrap;padding:7px'>".$this->Custom->format($formatResumo[$counterColuna],$subitem)."</td>";
						
						$counterColuna++;
					}
					echo "</tr>";
				}
			?>
		</tbody>
	</table>
	<?php } //fim if resumo?>
	
	<?php if(count($arr) > 0){ ?>
	<table style="font-size:10px" class="table table-responsive table-striped table-bordered" id="datatable2">
		<thead>
			<tr>
			<th></th>
			<?php 
				foreach($colunas as $key=>$item){
					echo "<th>".$item."</th>";
				}
			?>
			</tr>
		</thead>
		<tbody>
		<?php
			$counterColuna = 0;
			foreach ($arr as $key=>$item){
				
				$item = (array) $item;
				$onclick = "";
				if($idregistro == null){
					echo "<tr>";
				}else{
					echo "<tr style='cursor:pointer'>";
					$onclick = "onclick='window.open(\"$linkRegistro".$item[$idregistro]."\")'";
				}
				
				echo "<td style='padding:7px;text-align:right'>".($key+1)."</td>";
				$counterColuna = 0;
				foreach($item as $subkey=>$subitem){
					//terminar com _ pula o registro
					if($this->Custom->endsWith($subkey,"_")){
						continue;
					}
					echo "<td $onclick style='padding:7px'>".$this->Custom->format($format[$counterColuna],$subitem)."</td>";
					
					$counterColuna++;
					
				}
				echo "</tr>";
			}
		?>
		</tbody>
	</table>
	<?php } //fim if detalhado?>
	

	
	<script>
		$("#datatable1").DataTable({
			responsive: true,
			retrieve: false,
			paging : true,
			scroll : true,
			fixedHeader: {
			  header: true,
			  footer: false
			},
			language: {
				url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
				decimal: ",",
				thousands: "."
			},
			buttons: [
				{
				  extend: 'copy',
				  text: 'Copiar'
				},
				{
				  extend: 'print',
				  text: 'Imprimir',
				  messageTop: 'Relatório: <?=$nomeRelatorio?> <?=$periodo?>  \n Usuário: <?=$usuario?> \n Emitido em: <?=$dataHora?>',
				},
				{
				  extend: 'excel',
				  text: 'Excel',
				  messageTop: 'Relatório: <?=$nomeRelatorio?> <?=$periodo?>  \n Usuário: <?=$usuario?> \n Emitido em: <?=$dataHora?>',
				},
				{
				  extend: 'pdf',
				  text: 'PDF',
				  messageTop: 'Relatório: <?=$nomeRelatorio?> <?=$periodo?>  \n Usuário: <?=$usuario?> \n Emitido em: <?=$dataHora?>',
				}
			],
			dom: 'Bfrtip'
		});
		
		var datatable2 = $("#datatable2").DataTable({
			responsive: true,
			retrieve: false,
			paging : true,
			scroll : true,
			fixedHeader: {
			  header: true,
			  footer: false
			},
			language: {
				url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
				decimal: ",",
				thousands: "."
			},
			dom: 'Bfrtip',
			buttons: [
				{
				  extend: 'copy',
				  text: 'Copiar'
				},
				{
				  extend: 'print',
				  text: 'Imprimir',
				  messageTop: 'Relatório: <?=$nomeRelatorio?> <?=$periodo?>  \n Usuário: <?=$usuario?> \n Emitido em: <?=$dataHora?>'
				},
				{
				  extend: 'excel',
				  filename: 'Flygestor - <?=$nomeRelatorio?> <?=$periodo?>',
				  text: 'Excel',
				   messageTop: '<?=$nomeRelatorio?> <?=$periodo?> | Usuário: <?=$usuario?> | Emitido em: <?=$dataHora?> | Total de registros: <?=$totalRegistros?>'
				},
				{
				  extend: 'pdf',
				  //Name the pdf
				  filename: 'Flygestor - <?=$nomeRelatorio?> <?=$dataTraco?>',
				  text: 'PDF',
				  orientation:'landscape',
				  title:'FlyGestor',
				  pageSize:'A4',
				  messageTop: 'Relatório: <?=$nomeRelatorio?> <?=$periodo?>  \n Usuário: <?=$usuario?> \n Emitido em: <?=$dataHora?> \n Total de registros: <?=$totalRegistros?>',
				  messageBottom:'Flygestor - <?=$nomeRelatorio?> <?=$periodo?> | Usuário: <?=$usuario?> | Emitido em: <?=$dataHora?> | Total de registros: <?=$totalRegistros?>'
				  ,customize: function(doc) {
					  doc.defaultStyle.fontSize = 8;
					  doc.styles.tableHeader.fontSize = 8;
				  } 
				}
			]  
		});
	</script>
	
	<script>
	jQuery.fn.dataTable.Api.register( 'sum()', function ( ) {
		return this.flatten().reduce( function ( a, b ) {
			if ( typeof a === 'string' ) {
				a = a.replace('.','');
				a = a.replace(',','.');
				a = a.replace(/[^\d.-]/g, '') * 1;
			}
			if ( typeof b === 'string' ) {
				b = b.replace('.','');
				b = b.replace(',','.');
				b = b.replace(/[^\d.-]/g, '') * 1;
			}
	 
			return a + b;
		}, 0 );
	} );
		

	
	for(i = 0;i < $('#datatable2 th').length; i++){
		$("#selectcoluna").append('<option value="'+i+'">'+$('#datatable2 th')[i].innerHTML+'</option>');
	}
	</script>
