<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Release $release
 */
?>
<div class="card">
    <div class="card-header">
    		<h3>Add chamados</h3>
    		<div class="float-right">
    			<?= $this->Html->link('&nbsp;<i class="fa fa-bars fa-2" aria-hidden="true"></i> Listar', ['action' => 'view',$release->idrelease],['class'=>'btn btn-primary','escape'=>false]) ?>
    		</div>
    </div>
    	
    <div class="card-body">
        <h5>Chamados </h5>
        <?= $this->Form->create(null) ?>
    <table style="font-size:10px" class="table table-responsive table-striped datatable" cellpadding="0" cellspacing="0">
        <thead>
            <tr>
                <th scope="col"></th>
                <th scope="col">Cód</th>
                <th scope="col">Empresa</th>
                <th scope="col">Projeto</th>
                <th scope="col">Atendente</th>
                <th scope="col">Assunto</th>
                <th scope="col">Status</th>
                <!-- <th scope="col">Percentual</th> -->
                <th scope="col">Data Prevista</th>
                <th scope="col">Horas Previstas</th>
                <th></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($chamado as $chamado): ?>
            <tr>
                <td>
                    <input type="checkbox" class="form-control" name="check[]" value="<?=$chamado->idchamado?>">
                    
                </td>
                <td><?= $this->Number->format($chamado->idchamado) ?></td>
                <td><?php 
                    if(strlen($chamado->idempresa) > 0){
                        echo $chamado->idempresa." - ".$this->Custom->get('empresa','idempresa',$chamado->idempresa)->nome;
                    }
                ?></td>
                <td><?php 
                    if(strlen($chamado->idprojeto) > 0){
                        echo $chamado->idprojeto." - ".$this->Custom->get('projeto','idprojeto',$chamado->idprojeto)->nome;
                    }
                ?></td>
                <td><?php 
                    if(strlen($chamado->idusuario_atendimento) > 0){
                        echo $chamado->idusuario_atendimento." - ".$this->Custom->get('usuario','idusuario',$chamado->idusuario_atendimento)->nome;
                    }
                ?></td>
                <td><?= h($chamado->assunto) ?></td>
                <td><?php 
                    if(strlen($chamado->idchamadostatus) > 0){
                        echo $chamado->idchamadostatus." - ".$this->Custom->get('chamadostatus','idchamadostatus',$chamado->idchamadostatus)->descricao;
                    }
                ?></td>
                <!-- <td><?= $chamado->percentual ?>%</td> -->
                <td><?= h($chamado->data_prevista) ?></td>
                <td><?= h($chamado->horasprevistas) ?></td>
                <td><?= $this->Html->link('<i class="fa fa-eye" aria-hidden="true"></i>', ['controller'=>'chamado','action' => 'view',$chamado->idchamado],['class'=>'btn btn-sm','escape'=>false, 'data-toggle'=>'tooltip','data-placement'=>'top','title'=>'Abrir','target'=>'_BLANK','style'=>'background-color: #1976d2; color:#FFFFFF']) ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <button type="submit" class="btn btn-primary">Enviar</button>
    
    </div>
</div>

<script>
setTimeout(function() { 
    $(".datatable").DataTable({
        "ordering": false,
        responsive: false,
        retrieve: false,
        paging : true,
        scroll : false,
        searching: true,
        fixedHeader: {
          header: true,
          footer: false
        },
        language: {
                url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
                decimal: ",",
                thousands: "."
            }
            
            
    });
}, 500);
$('.datatable td').css('padding','3px');
</script>