<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Release[]|\Cake\Collection\CollectionInterface $releases
 */
?>
<div class="card">
<div class="card-header">
	<h3><?= __('Releases') ?></h3>
	<div class="float-right">
		<?= $this->Html->link(__('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar'), ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?></li>
	</div>
</div>
<div class="card-body">
    <table class="table table-responsive table-striped" cellpadding="0" cellspacing="0">
        <thead>
            <tr>
                <th scope="col">Cód.</th>
                <th scope="col">Número</th>
                <th scope="col">Produto</th>
                <th scope="col">Previsão de Entrega</th>
                <th scope="col">Situação</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($releases as $release): ?>
            <tr style="cursor:pointer" onclick="window.location.href='releases/view/<?=$release->idrelease?>'">
                <td><?= $this->Number->format($release->idrelease) ?></td>
                <td><?= h($release->numero) ?></td>
                <td><?= ($release->idproduto)?$this->Custom->get('produto','idproduto',$release->idproduto)->nome:'' ?></td>
                <td><?= h($release->previsaoentrega) ?></td>
                <td><?= h($release->situacao) ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('primeiro')) ?>
            <?= $this->Paginator->prev('< ' . __('anterior')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('próximo') . ' >') ?>
            <?= $this->Paginator->last(__('último') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(['format' => __('Página {{page}} de {{pages}}, mostrando {{current}} registros(s) de total {{count}}')]) ?></p>
    </div>
</div>
</div>
