<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Release $release
 */
?>
<div class="card">
<div class="card-header">
	<h3>Release <?= h($release->idrelease) ?></h3>
	<div class="float-right">
		<?= $this->Html->link('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Add Chamados', ['action' => 'addchamados',$release->idrelease],['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-bars" aria-hidden="true"></i> Listar', ['action' => 'index'], ['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-edit fa-2" aria-hidden="true"></i>  Editar', ['action' => 'edit', $release->idrelease], ['class'=>'btn btn-primary','escape'=>false]) ?> 
		<?= $this->Form->postLink('&nbsp;<i class="fa fa-trash fa-2" aria-hidden="true"></i>  Deletar', ['action' => 'delete', $release->idrelease], ['confirm' => __('Deseja deletar # {0}?', $release->idrelease),'class'=>'btn btn-primary', 'escape'=>false]) ?>
	</div>
</div>
<div class="card-body">
    <table class="vertical-table table-responsive table">
        <tr>
            <th scope="row"><?= __('Situação') ?></th>
            <td><?= h($release->situacao) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Cód.') ?></th>
            <td><?= $this->Number->format($release->idrelease) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Número') ?></th>
            <td><?= h($release->numero) ?></td>
        </tr>
         <tr>
            <th scope="row"><?= __('Produto') ?></th>
            <td><?= h($release->idproduto)?$this->Custom->get('produto','idproduto',$release->idproduto)->nome:'' ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Previsão de entrega') ?></th>
            <td><?= h($release->previsaoentrega) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Data Criação') ?></th>
            <td><?= h($release->data_criacao) ?></td>
        </tr>
    </table>

    <br>
    <hr>
    <br>

    <h5>Chamados</h5>
    <table style="font-size:10px" class="table table-responsive table-striped datatable" cellpadding="0" cellspacing="0">
        <thead>
            <tr>
                <th scope="col">Cód</th>
                <th scope="col">Empresa</th>
                <th scope="col">Projeto</th>
                <th scope="col">Atendente</th>
                <th scope="col">Assunto</th>
                <th scope="col">Status</th>
                <!-- <th scope="col">Percentual</th> -->
                <th scope="col">Data Prevista</th>
                <th scope="col">Horas Previstas</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($chamado as $chamado): ?>
            <tr style="cursor:pointer" onclick="window.open('../../chamado/view/<?=$chamado->idchamado?>')">
                <td><?= $this->Number->format($chamado->idchamado) ?></td>
                <td><?php 
                    if(strlen($chamado->idempresa) > 0){
                        echo $chamado->idempresa." - ".$this->Custom->get('empresa','idempresa',$chamado->idempresa)->nome;
                    }
                ?></td>
                <td><?php 
                    if(strlen($chamado->idprojeto) > 0){
                        echo $chamado->idprojeto." - ".$this->Custom->get('projeto','idprojeto',$chamado->idprojeto)->nome;
                    }
                ?></td>
                <td><?php 
                    if(strlen($chamado->idusuario_atendimento) > 0){
                        echo $chamado->idusuario_atendimento." - ".$this->Custom->get('usuario','idusuario',$chamado->idusuario_atendimento)->nome;
                    }
                ?></td>
                <td><?= h($chamado->assunto) ?></td>
                <td><?= h($chamado->status) ?></td>
                <!-- <td><?= $chamado->percentual ?>%</td> -->
                <td><?= h($chamado->data_prevista) ?></td>
                <td><?= h($chamado->horasprevistas) ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
</div>

<script>
setTimeout(function() { 
    $(".datatable").DataTable({
        "ordering": false,
        responsive: false,
        retrieve: false,
        paging : true,
        scroll : false,
        searching: true,
        fixedHeader: {
          header: true,
          footer: false
        },
        language: {
                url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
                decimal: ",",
                thousands: "."
            },
            buttons: [
                {
                  extend: 'copy',
                  text: 'Copiar'
                },
                {
                  extend: 'print',
                  text: 'Imprimir',
                  messageTop: 'Relatório: ',
                },
                {
                  extend: 'excel',
                  text: 'Excel',
                  messageTop: 'Relatório:',
                },
                {
                  extend: 'pdf',
                  text: 'PDF',
                  messageTop: 'Relatório: ',
                }
            ],
            dom: 'Bfrtip'
    });
}, 500);
$('.datatable td').css('padding','3px');
</script>
