<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Texto[]|\Cake\Collection\CollectionInterface $texto
 */
?>
<div class="card">
<div class="card-header">
	<h3><?= __('Texto') ?></h3>
	<div class="float-right">
		<?= $this->Html->link(__('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar'), ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?></li>
	</div>
</div>
<div class="card-body">
    <table class="table table-responsive table-striped" cellpadding="0" cellspacing="0">
        <thead>
            <tr>
                <th scope="col"><?= $this->Paginator->sort('idtexto') ?></th>
                <th scope="col"><?= $this->Paginator->sort('chave') ?></th>
                <th scope="col"><?= $this->Paginator->sort('titulo') ?></th>
                <th scope="col"><?= $this->Paginator->sort('descricao') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($texto as $texto): ?>
            <tr style="cursor:pointer" onclick="window.location.href='texto/view/<?=$texto->idtexto?>'">
                <td><?= $this->Number->format($texto->idtexto) ?></td>
                <td><?= h($texto->chave) ?></td>
                <td><?= h($texto->titulo) ?></td>
                <td><?= h($texto->descricao) ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('primeiro')) ?>
            <?= $this->Paginator->prev('< ' . __('anterior')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('próximo') . ' >') ?>
            <?= $this->Paginator->last(__('último') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(['format' => __('Página {{page}} de {{pages}}, mostrando {{current}} registros(s) de total {{count}}')]) ?></p>
    </div>
</div>
</div>
