<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Texto $texto
 */
?>
<div class="card">
<div class="card-header">
	<h3>Texto <?= h($texto->idtexto) ?></h3>
	<div class="float-right">
		<?= $this->Html->link('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar', ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-bars" aria-hidden="true"></i> Listar', ['action' => 'index'], ['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-edit fa-2" aria-hidden="true"></i>  Editar', ['action' => 'edit', $texto->idtexto], ['class'=>'btn btn-primary','escape'=>false]) ?> 
		<?= $this->Form->postLink('&nbsp;<i class="fa fa-trash fa-2" aria-hidden="true"></i>  Deletar', ['action' => 'delete', $texto->idtexto], ['confirm' => __('Deseja deletar # {0}?', $texto->idtexto),'class'=>'btn btn-primary', 'escape'=>false]) ?>
	</div>
</div>
<div class="card-body">
    <table class="vertical-table table-responsive table">
        <tr>
            <th scope="row"><?= __('Chave') ?></th>
            <td><?= h($texto->chave) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Titulo') ?></th>
            <td><?= h($texto->titulo) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Descricao') ?></th>
            <td><?= h($texto->descricao) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Idtexto') ?></th>
            <td><?= $this->Number->format($texto->idtexto) ?></td>
        </tr>
    </table>
</div>
</div>
