<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Todo $todo
 */
?>
<div class="card">
<div class="card-header">
		<h3>Editar Todo <?=$todo->id?></h3>
		<div class="float-right">
			<?= $this->Html->link('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar', ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?>
			<?= $this->Html->link('&nbsp;<i class="fa fa-bars" aria-hidden="true"></i> Listar', ['action' => 'index'], ['class'=>'btn btn-primary','escape'=>false]) ?>
			<?= $this->Html->link('&nbsp;<i class="fa fa-eye fa-2" aria-hidden="true"></i>  Ver', ['action' => 'view', $todo->id], ['class'=>'btn btn-primary','escape'=>false]) ?> 
			<?= $this->Form->postLink('&nbsp;<i class="fa fa-trash fa-2" aria-hidden="true"></i>  Deletar', ['action' => 'delete', $todo->id], ['confirm' => __('Deseja deletar # {0}?', $todo->id),'class'=>'btn btn-primary', 'escape'=>false]) ?>
		</div>
</div>
	
<div class="card-body">
    <?= $this->Form->create($todo) ?>
        <?php
            echo $this->Form->control('descricao',['class'=>'form-control']);
            echo $this->Form->control('idchamado',['class'=>'form-control']);
            echo $this->Form->control('idusuario',['class'=>'form-control']);
            echo $this->Form->control('concluido',['class'=>'form-control']);
            echo $this->Form->control('data_criacao', ['empty' => true]);
        ?>
    <br><br>
    <?= $this->Form->button(__('Enviar'),['class'=>'btn btn-primary']) ?>
    <?= $this->Form->end() ?>
</div>
</div>
