<?php

?>
<!-- Font Awesome 5.6 -->
<link href="https://use.fontawesome.com/releases/v5.6.3/css/all.css" rel="stylesheet" />

      <div class="card">
        <h5 class="card-header bg-primary text-white">
          Tarefas
        </h5>

        <div class="card-body">
          <div class="input-group mb-3">
            <input type="text" id="search" class="form-control" placeholder="Pesquisar Tarefa">
            <div class="input-group-append">
              <span class="input-group-text"> <i class="fas fa-search"></i> </span>
            </div>
          </div>
          <div class="progress">
            <div class="progress-bar" id="progress-bar" role="progressbar" style="width: <?=$percentual?>%;" aria-valuenow="<?=$percentual?>" aria-valuemin="0" aria-valuemax="100"><?=$concluido?>/<?=$total?> (<?=$percentual?>%)</div>
          </div>
          <ul class="list-group mb-3">
            <?php foreach ($todo as $item) { ?>
                <li class="list-group-item <?=$item->concluido == 1 ? 'done' : ''?>">
                    <i class="far fa-square done-icon"></i>
                    <i class="far fa-check-square done-icon"></i>
                    <span class="todo-text" id="<?=$item->id?>"><?=$item->descricao?></span>
                    <i class="far fa-trash-alt"></i>
                </li>
            <?php } // end foreach ?>
          </ul>
          <!-- <button id="clearBtn" type="button" class="btn btn-dark btn-sm">Deletar Todos</button> -->
        </div>
        <div class="card-footer">
          <form id="form">
            <div class="input-group">
              <input type="text" class="form-control" id="todo" placeholder="Adicionar nova tarefa">
              <div class="input-group-append">
                <button type="submit" class="btn btn-primary"><i class="fas fa-plus"></i> Add
                </button>
              </div>
            </div>
          </form>
        </div>
      </div>

      <script>





function updateDiv(){
$( "#progress-bar" ).load(window.location.href + "#progress-bar" );
}

</script>

<script>
// Define all UI variable
var todoList = document.querySelector('.list-group');
var form = document.querySelector('#form');
var todoInput = document.querySelector('#todo');
var clearBtn = document.querySelector('#clearBtn');
var search = document.querySelector('#search');

// Load all event listners
allEventListners();


// Functions of all event listners
function allEventListners() {
    // Add todo event
    form.addEventListener('submit', addTodo);
    // Remove and complete todo event
    todoList.addEventListener('click', removeTodo);
    // Clear or remove all todos
    // clearBtn.addEventListener('click', clearTodoList);
    // Search todo event
    search.addEventListener('keyup', searchTodo);
}


// Add todo item function
function addTodo(e) {
    if (todoInput.value !== '') {
        // Create li element
        const li = document.createElement('li');
        // Add class
        li.className = 'list-group-item';
        // Add complete and remove icon
        li.innerHTML = `<i class="far fa-square done-icon"></i>
                        <i class="far fa-check-square done-icon"></i>
                        <i class="far fa-trash-alt"></i>`;
        // Create span element
        const span = document.createElement('span');
        // Add class
        span.className = 'todo-text';
        // Create text node and append to span
        span.appendChild(document.createTextNode(todoInput.value));
        // Append span to li
        li.appendChild(span);
        // Append li to ul (todoList)
        todoList.appendChild(li);

        var url   = window.location.pathname.split("view/");
        var id = url[1]
        console.log(id);

        $.ajax({
        method: "POST",
        url: "../../todo/addajax/"+id,
        data: { description: todoInput.value  }
        })
        updateDiv();

        // Clear input
        todoInput.value = '';
    } else {
        alert('Adicione uma descrição');
    }

    e.preventDefault();


}


// Remove and complete todo item function
function removeTodo(e) {
    // Remove todo
    if (e.target.classList.contains('fa-trash-alt')) {
        if (confirm('Deseja remover?')) {
            e.target.parentElement.remove();

        let id = e.target.parentElement.children[2].getAttribute('id');

        var xhttp = new XMLHttpRequest();
        xhttp.onreadystatechange = function() {
            if (xhttp.readyState === XMLHttpRequest.DONE && xhttp.status === 200) {
            // Typical action to be performed when the document is ready:
            }
        };
        xhttp.open("POST", "../../todo/deletar/"+id, true);
        xhttp.send();
        updateDiv();
        }
    }

    // Complete todo
    if (e.target.classList.contains('todo-text')) {
        e.target.parentElement.classList.toggle('done');
    }
    if (e.target.classList.contains('done-icon')) {
        e.target.parentElement.classList.toggle('done');

        let id = e.target.parentElement.children[2].getAttribute('id');

        var xhttp = new XMLHttpRequest();
        xhttp.onreadystatechange = function() {
            if (xhttp.readyState === XMLHttpRequest.DONE && xhttp.status === 200) {
            // Typical action to be performed when the document is ready:
            }
        };
        xhttp.open("POST", "../../todo/concluido/"+id, true);
        xhttp.send();
        updateDiv();
    }
}


// Clear or remove all todos function
function clearTodoList() {
    todoList.innerHTML = '';
}


// Search todo function
function searchTodo(e) {
    const text = e.target.value.toLowerCase();
    const allItem = document.querySelectorAll('.list-group-item');
    for (let task of allItem) {
        const item = task.textContent;
        if (item.toLowerCase().indexOf(text) != -1) {
            task.style.display = 'flex';
        } else {
            task.style.display = 'none';
        }
    };
}
</script>

<style>
.card {
    box-shadow: 0px 0px 3px 1px #ddd;
}

.list-group-item {
    padding: .5rem .75rem;
    border: 1px solid rgba(0, 0, 0, .07);
    display: flex;
    align-items: center;
}

.list-group-item:first-child {
    border-radius: 0;
}

.list-group-item:last-child {
    border-radius: 0;
}

.list-group-item i.fa-square {
    flex-grow: 0;
    cursor: pointer;
    order: 1;
}

.list-group-item i.fa-check-square {
    display: none;
}

.list-group-item i.fa-trash-alt {
    flex-grow: 0;
    cursor: pointer;
    color: #dc3545;
    order: 3;
}

.list-group-item i.fa-trash-alt:hover {
    color: #af1e2c;
}

.list-group-item .todo-text {
    flex-grow: 1;
    margin: 0 10px;
    order: 2;
}

.list-group-item.done i.fa-check-square {
    flex-grow: 0;
    cursor: pointer;
    color: #28a745;
    display: block;
}

.list-group-item.done i.fa-square {
    display: none;
}

.list-group-item.done .todo-text {
    text-decoration: line-through;
    color: #888;
}

</style>
