<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Todo $todo
 */
?>
<div class="card">
<div class="card-header">
	<h3>Todo <?= h($todo->id) ?></h3>
	<div class="float-right">
		<?= $this->Html->link('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar', ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-bars" aria-hidden="true"></i> Listar', ['action' => 'index'], ['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-edit fa-2" aria-hidden="true"></i>  Editar', ['action' => 'edit', $todo->id], ['class'=>'btn btn-primary','escape'=>false]) ?> 
		<?= $this->Form->postLink('&nbsp;<i class="fa fa-trash fa-2" aria-hidden="true"></i>  Deletar', ['action' => 'delete', $todo->id], ['confirm' => __('Deseja deletar # {0}?', $todo->id),'class'=>'btn btn-primary', 'escape'=>false]) ?>
	</div>
</div>
<div class="card-body">
    <table class="vertical-table table-responsive table">
        <tr>
            <th scope="row"><?= __('Descricao') ?></th>
            <td><?= h($todo->descricao) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Id') ?></th>
            <td><?= $this->Number->format($todo->id) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Idchamado') ?></th>
            <td><?= $this->Number->format($todo->idchamado) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Idusuario') ?></th>
            <td><?= $this->Number->format($todo->idusuario) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Concluido') ?></th>
            <td><?= $this->Number->format($todo->concluido) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Data Criacao') ?></th>
            <td><?= h($todo->data_criacao) ?></td>
        </tr>
    </table>
</div>
</div>
