<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Usuario $usuario
 */
?>
<div class="card">
<div class="card-header">
	<h3>Usuário <?= h($usuario->idusuario) ?></h3>
	<div class="float-right">
		<?= $this->Html->link('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar', ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-bars" aria-hidden="true"></i> Listar', ['action' => 'index'], ['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-eye fa-2" aria-hidden="true"></i>  Ver', ['action' => 'view', $usuario->idusuario], ['class'=>'btn btn-primary','escape'=>false]) ?> 
		<?= $this->Form->postLink('&nbsp;<i class="fa fa-trash fa-2" aria-hidden="true"></i>  Deletar', ['action' => 'delete', $usuario->idusuario], ['confirm' => __('Deseja deletar # {0}?', $usuario->idusuario),'class'=>'btn btn-primary', 'escape'=>false]) ?>
	</div>
</div>
<div class="card-body">
    <?= $this->Form->create($usuario) ?>
			<label>Empresa</label>
			<select name="idempresa" class="form-control">
				<option value="" disabled>Escolha a empresa </option>
				<?php 
					$selected = "";
					foreach($empresas as $emp){ ?>
					<?php if($emp->idempresa == $usuario->idempresa){$selected = "selected";}else{$selected = "";}?>
					<option value="<?=$emp->idempresa?>" <?=$selected?>><?=$emp->nome?></option>
				<?php } ?>
			</select>
			<label>Perfil</label>
			<select name="idperfil" class="form-control">
				<option value="" disabled>Escolha o perfil </option>
				<?php 
					$selected = "";
					foreach($perfis as $perfil){ ?>
					<?php if($perfil->idperfil == $usuario->idperfil){$selected = "selected";}else{$selected = "";}?>
					<option value="<?=$perfil->idperfil?>" <?=$selected?>><?=$perfil->perfil?></option>
				<?php } ?>
			</select>
			<label>Perfil CRM</label>
			<select name="idperfilcrm[]" multiple class="form-control">
				<option value="" disabled selected>Escolha o perfil CRM </option>
				<?php 
					$selected = "";
				foreach($perfis_crm as $perfilcrm){ ?>
					<option value="<?=$perfilcrm->idperfil_crm?>" <?=in_array($perfilcrm->idperfil_crm, $perfis_cadastrados) ? 'selected' : ''?>> <?=$perfilcrm->nome?></option>
				<?php } ?>
			</select>
			<?php
            echo $this->Form->control('nome',['class'=>'form-control']);
            echo $this->Form->control('cpf',['class'=>'form-control']);
            echo $this->Form->control('senha',['class'=>'form-control']);
            echo $this->Form->control('email',['class'=>'form-control']);
            echo $this->Form->control('telefone',['class'=>'form-control']);
            echo $this->Custom->selectSimNao('ativo',$usuario->ativo,true);
            echo "<label>Responsável</label>";
            echo $this->Custom->selectSimNao('responsavel',$usuario->responsavel,false);
            echo $this->Form->control('bancodehoras',['class'=>'form-control']);
        ?>
	<br><br>
    <?= $this->Form->button(__('Enviar'),['class'=>'btn btn-primary']) ?>
    <?= $this->Form->end() ?>
</div>
</div>
