<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Usuario[]|\Cake\Collection\CollectionInterface $usuario
 */
 
?>
<div class="card">
<div class="card-header">
	<h3>Usuários (<?=count($usuario->toArray())?>)</h3>
	<div class="float-right">
		<?= $this->Html->link('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar', ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?>
	</div>
</div>
<div class="card-body">
    <table class="table table-responsive table-striped" cellpadding="0" cellspacing="0">
        <thead>
            <tr>
                <th scope="col"></th>
                <th scope="col">Nome</th>
				<th scope="col">Empresa</th>
                <th scope="col">CPF</th>
				<th scope="col">Perfil</th>
                <th scope="col">Ativo</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($usuario as $usuario): ?>
            <tr >
				<td><a class="btn btn-primary btn-sm" target="_blank" href="usuario/view/<?=$usuario->idusuario?>">
					<i class="fa fa-eye"></i> Ver
				</td>
                <td style="white-space:nowrap"><?= h($usuario->nome).' ('.$usuario->idusuario.')' ?></td>
				<td><?=$this->Custom->get('empresa','idempresa',$usuario->idempresa)->nome?></td>
                <td><?= h($usuario->cpf) ?></td>
                <td><?=$this->Custom->get('Perfil','idperfil',$usuario->idperfil)->perfil?></td>
				<td><?= $this->Custom->toSimNao($usuario->ativo) ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
</div>
<script>
	$('td').css('padding','5px');
</script>
