<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Usuario $usuario
 */
?>
<div class="card">
<div class="card-header">
	<h3>Usuário <?= h($usuario->idusuario) ?></h3>
	<div class="float-right">
		<?php
			if($usuario->idempresa != 1)
			echo $this->Html->link('&nbsp;<i class="fa fa-exchange fa-2" aria-hidden="true"></i> Logar', ['action' => 'login', $usuario->idusuario],['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar', ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-bars" aria-hidden="true"></i> Listar', ['action' => 'index'], ['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-edit fa-2" aria-hidden="true"></i>  Editar', ['action' => 'edit', $usuario->idusuario], ['class'=>'btn btn-primary','escape'=>false]) ?> 
		<?= $this->Form->postLink('&nbsp;<i class="fa fa-trash fa-2" aria-hidden="true"></i>  Deletar', ['action' => 'delete', $usuario->idusuario], ['confirm' => __('Deseja deletar # {0}?', $usuario->idusuario),'class'=>'btn btn-primary', 'escape'=>false]) ?>
	</div>
</div>
<div class="card-body">
    <table class="vertical-table table-responsive table">
        <tr>
            <th scope="row"><?= __('Nome') ?></th>
            <td><?= h($usuario->nome) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('CPF') ?></th>
            <td><?= h($usuario->cpf) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Senha') ?></th>
            <td><?= h($usuario->senha) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Email') ?></th>
            <td><?= h($usuario->email) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Telefone') ?></th>
            <td><?= h($usuario->telefone) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Perfil') ?></th>
            <td><?=$this->Custom->get('Perfil','idperfil',$usuario->idperfil)->perfil?></td>
        </tr>
        <tr>
            <th scope="row">Empresa</th>
            <td><?=$this->Custom->get('empresa','idempresa',$usuario->idempresa)->nome?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Ativo') ?></th>
            <td><?= $this->Custom->toSimNao($usuario->ativo) ?></td>
        </tr>
		<tr>
            <th scope="row"><?= __('Usuário Criação') ?></th>
            <td><?=$usuario->usuario_criacao ." - ". $this->Custom->get('usuario','idusuario',$usuario->usuario_criacao)->nome ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Data Criação') ?></th>
            <td><?= h($usuario->data_criacao) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Responsável') ?></th>
            <td><?= $this->Custom->toSimNao($usuario->responsavel) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Banco de Horas') ?></th>
            <td><?= h($usuario->bancodehoras) ?></td>
        </tr>
    </table>
	<br><br>
	<h3>Módulos do usuário</h3>
	<div class="float-right">
		<?= $this->Html->link('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Cadastrar', ['controller'=>'modulousuario','action' => 'add',$idusuario],['target'=>'_BLANK','class'=>'btn btn-primary','escape'=>false]) ?>
	</div>
	<table class="table table-responsive table-striped" cellpadding="0" cellspacing="0">
        <thead>
            <tr>
				<th scope="col">Cód.</th>
                <th scope="col">Módulo</th>
                <th scope="col">Descrição</th>
				<th></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($modulosusuario as $item): ?>
			<?php
				$modulo = $this->Custom->get('modulo','idmodulo',$item->idmodulo);
			?>
            <tr>
                <td><?=$modulo->idmodulo?></td>
				<td><?=$modulo->nome?></td>
				<td><?=$modulo->descricao?></td>
				<td><?= $this->Form->postLink('&nbsp;<i class="fa fa-trash fa-2" aria-hidden="true"></i>', ['controller'=>'modulousuario','action' => 'delete', $item->idmodulousuario], ['confirm' => __('Deseja deletar # {0}?', $item->idmodulousuario),'class'=>'btn btn-danger', 'escape'=>false]) ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <?php if (!empty($empresas)) {?>
	<br><br>
    <hr>
	<h3>Empresa do CRM</h3>
	<div class="float-right">
		<?= $this->Html->link('&nbsp;<i class="fa fa-edit fa-2" aria-hidden="true"></i> Vincular/Mudar', ['controller'=>'empresacrm','action' => 'edit',$idusuario],['target'=>'_BLANK','class'=>'btn btn-primary','escape'=>false]) ?>
	</div>
    <h4>Empresa Vinculada: <?=$empresa[0]->razaosocial?></h4>
    <?php } ?>

	<br><br>
    <hr>
	<h3>Bloqueio de Filiais</h3>
	<div class="float-right">
		<?= $this->Html->link('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Cadastrar', ['controller'=>'bloqueiousuariofilial','action' => 'add',$idusuario],['target'=>'_BLANK','class'=>'btn btn-primary','escape'=>false]) ?>
	</div>
	<table class="table table-responsive table-striped" cellpadding="0" cellspacing="0">
        <thead>
            <tr>
                <th scope="col">Código no ERP da Filial</th>
                <th scope="col">Data</th>
				<th></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($bloqueiousuariofilial as $item): ?>
            <tr>
                <td><?=$item->coderpfilial?></td>
				<td><?=$item->data_criacao?></td>
				<td><?= $this->Form->postLink('&nbsp;<i class="fa fa-trash fa-2" aria-hidden="true"></i>', ['controller'=>'bloqueiousuariofilial','action' => 'delete', $item->idbloqueiousuariofilial], ['confirm' => __('Deseja deletar # {0}?', $item->idbloqueiousuariofilial),'class'=>'btn btn-danger', 'escape'=>false]) ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
</div>
