<script>
function linha2(iddiv, json) {
	var myChart = echarts.init(document.getElementById(iddiv));

	// Chart Options
	// ------------------------------
	chartOptions = {

		// Setup grid
		grid: {
			x: 40,
			x2: 40,
			y: 45,
			y2: 25
		},

		// Add Tooltip
		tooltip : {
			trigger: 'axis'
		},

		// Add Legend
		legend: {
			data:['NOVOS LEADS EM: <?=$this->Custom->toDate($datainicio)." - ".$this->Custom->toDate($datafim)?>']
		},

		// Add custom colors
		color: ['#F98E76'],

		// Enable drag recalculate
		calculable : true,

		// Horizontal Axiz
		xAxis : [
			{
				name : 'Tabela',
				nameLocation : 'center',
				nameGap : 5,
				type : 'category',
				boundaryGap : false,
				data : json.dia
			}
		],

		// Vertical Axis
		yAxis : [
			{
				name : 'R$',
				type : 'value',
				axisLabel : {
					formatter: '{value}'
				},
				nameGap:0
			}
		],

		// Add Series
		series : [
			{
				name:'Leads',
				type:'line',
				data:json.qtd
			}
		]
	};

	// Apply options
	// ------------------------------

	myChart.setOption(chartOptions);


	// Resize chart
	// ------------------------------

	$(function () {

		// Resize chart on menu width change and window resize
		$(window).on('resize', resize);
		$(".menu-toggle").on('click', resize);

		// Resize function
		function resize() {
			setTimeout(function() {

				// Resize chart
				myChart.resize();
			}, 200);
		}
	});
}

</script>
<script>
	function marcarlead(el){
		var empresaid=el.getAttribute('empresaid');
		
		var qtd     =parseInt($('#qtd'+empresaid).text());
		var valor   =parseFloat($('#valor'+empresaid).text().replace('.','').replace(',','.'));
		var unidades=parseInt($('#unidades'+empresaid).text());
		
		if(el.checked){
			qtd = qtd + parseInt(el.getAttribute('qtd'));
			valor = valor + parseFloat(el.getAttribute('valor'));
			unidades = unidades + parseInt(el.getAttribute('unidades'));
		}else{
			qtd = qtd - parseInt(el.getAttribute('qtd'));
			valor = valor - parseFloat(el.getAttribute('valor'));
			unidades = unidades - parseInt(el.getAttribute('unidades'));
		}
		
		$('#valor'+empresaid).text(valor.toFixed(2).replace('.',','));
		$('#qtd'+empresaid).text(qtd);
		$('#unidades'+empresaid).text(unidades);
	}
</script>
