<div class="row">
    <div class="col-md-12">
        <h4><?=$table_title?></h4>
    </div>
    <div class="col-md-12 mt-1">
        <table class="table table-responsive datatable table-stripped" id="<?=$id?>">
            <thead>
                <?php foreach ($headers as $item):?>
                <th><?=$item?></th>
                <?php endforeach; ?>
            </thead>
            <tbody>
                <?php foreach ($data as $item): ?>
                <?php if ($onclick_funcao == '') { ?>
                    <tr>
                <?php } else { ?>
                    <tr onclick="<?=$onclick_funcao?>(<?=$item->{$onclick_parametro}?>)" <?= $mouse_over ? "style='cursor:pointer'" : '' ?> >
                <?php } ?>
                    <?php for ($i = 0; $i < count($columns); $i++): ?>
                    <td class="<?=$align[$i]?>"> <?= $this->Custom->format($format[$i],$item->{$columns[$i]}) ?> </td>
                    <?php endfor; ?>
                </tr>
                <?php endforeach; ?>
            </tbody>
            <tfoot>
                <th>Total:</th>
                <?php for ($i = 1; $i < count($align); $i++) : ?>
                    <th class="<?=$align[$i]?>"></th>
                <?php endfor; ?>
            </tfoot>
        </table>
    </div>
</div>

<script>
var debug = ''
    $(document).ready(
        function () {
            $('#<?=$id?>').DataTable({
                responsive: false,
                retrieve: false,
                destroy: true,
                paging : true,
                scroll : true,
                pageLength: <?=$pageLength?>,
                fixedHeader: {
                    header: true,
                    footer: false
                },
                language: {
                    url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
                    decimal: ",",
                    thousands: "."
                },
                dom: 'Bfrtip',
                <?php if ($export) { ?>
                buttons: [
                    {
                        extend: 'copy',
                        text: 'Copiar'
                    },
                    {
                        extend: 'print',
                        text: 'Imprimir',
                        messageTop: 'Relatório: <?=$nomeRelatorio?>  \n Emitido em: <?=Date('d/m/Y')?> \n Por: <?=$usuario?>'
                    },
                    {
                        extend: 'excel',
                        filename: '<?=$sistema?> - <?=$nomeRelatorio?>',
                        text: 'Excel',
                        messageTop: '<?=$nomeRelatorio?> | Emitido em: <?=Date('d/m/Y')?> | Por: <?=$usuario?> | Total de registros (Sem os Filtros): '+ $("#datatable").DataTable().rows({search:'applied'}).count()
                    },
                    {
                        extend: 'pdf',
                        filename: '<?=$sistema?> - <?=$nomeRelatorio?> <?=Date('d-m-Y')?>',
                        text: 'PDF',
                        orientation:'landscape',
                        title:'<?=$sistema?>',
                        pageSize:'A4',
                        footer: true,
                        messageTop: 'Relatório: <?=$nomeRelatorio?> \n Emitido em: <?=Date('d/m/Y')?> \n Por: <?=$usuario?> \n Total de registros (Sem os Filtros): '+ $("#datatable").DataTable().rows({search:'applied'}).count(),
                        customize: function (doc) {
                            var table = $("#<?=$id?>").DataTable()
                            let rows = table.rows({search:'applied'}).count()
                            debug = doc
                            for (i = 0; i <= rows; i++) {
                                <?php foreach ($pdf_rightalign as $item): ?>
                                doc.content[2].table.body[i][<?=$item?>].alignment = 'right';
                                <?php endforeach; ?>
                            };
                        }
                    }
                ],
            <?php } else { ?>
                buttons: [],
                <?php } ?>
                "footerCallback": function ( row, data, start, end, display ) {
                    var totalcolums = [<?=implode(',',$posicoes_soma)?>];

                    var api = this.api(), data;
                    var intVal = function (i) {
                        if(typeof i === 'string'){
                            i = i.toString();
                            i = i.replace('<span style=\"color:red\">', '');
                            i = i.replace('</span>', '');
                        }

                        return typeof i === 'string' ?
                        i.replace(/\./g, '').replace(/\,/g, '.') * 1 :
                        typeof i === 'number' ?
                        i : 0;
                    };

                    for(i=0;i<totalcolums.length;i++){
                        var col = api .column( totalcolums[i], {filter:'applied'} ).data().reduce( function (a, b) {return intVal(a) + intVal(b);}, 0 );
                        col = col.toLocaleString('pt-BR',{minimumFractionDigits: 2, maximumFractionDigits: 2});
                        col = col < 0 ? '<span style=\"color:red\">'+col+'</span>' : col;
                        $( api.column( totalcolums[i] ).footer() ).html(col);
                    }
                }
            })
        }
    )
</script>