<div class="row mt-1">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h4>Centros de Custo da Filial: <strong><?=$empresa->razaosocial?></strong></h4>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-12">
                        <table class="table table-responsive datatablecentro table-stripped table-bordered" id="centroscusto">
                            <thead>
                                <th><button type="button" onclick="adicionarCentroCusto()" style="border-radius:5px;" class="btn btn-primary btn-sm"><i class="fa fa-plus-circle" aria-hidden="true"></i></buton></th>
                                <th>Id</th>
                                <th>Ordem</th>
                                <th>Nome</th>
                                <th>Ativo</th>
                            </thead>
                            <tbody>
                                <?php foreach ($centroscusto as $item): ?>
                                <tr>
                                    <td style="width: 85px">
                                        <a target="_BLANK" style="color:#fff" onclick="editarCentroCusto(<?=$item->centrocustoid?>)" class="btn btn-primary btn-sm"><i class="fa fa-edit" aria-hidden="true"></i></a>
                                        <a class='btn btn-danger btn-sm' style="color:#fff" onclick="alertcentrocusto(<?=$item->centrocustoid?>)"><i class="fa fa-trash fa-2" aria-hidden="true"></i></a>
                                    </td>
                                    <td><?=$item->centrocustoid?></td>
                                    <td><?=$item->ordem?></td>
                                    <td style="width: 155px"><?=$item->nome?></td>
                                    <td><?=$this->Custom->toSimNao($item->ativo)?></td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    function alertcentrocusto(id){
		Swal.fire({
		title: 'Deseja excluir Centro Custo?',
		showCancelButton: true,
		confirmButtonText: `Confirmar`,
		cancelButtonText: `Cancelar`
		}).then((result) => {
		if (result.isConfirmed) {
			console.log(id);
			$.get('<?=$this->request->getAttribute('base').'/flystart/cfg/centrocusto/delete/'?>'+id);
			window.setTimeout('location.reload()', 1000);
		} 
		})
	}
    function adicionarCentroCusto() {
        $('.modal-body').html('<div style="text-align:center"><i class="fa fa-refresh fa-spin"></i></div>');
        $('#modal').modal('show').find('.modal-body').load('<?=$this->request->getAttribute('base').'/flystart/cfg/centrocusto/add'?>',function(responseText, textStatus, req){
            if (textStatus == "error") {
                alert('Sua consulta retornou um número muito grande de registros. Tente um período menor.');
                $('[data-dismiss="modal"]').click();
            }
        });
        $('#loading').hide();

        $('button[data-dismiss="modal"]').on('click', function(e){
            $('.modal-body').html("");
        });
    }
    function editarCentroCusto(id) {
        $('.modal-body').html('<div style="text-align:center"><i class="fa fa-refresh fa-spin"></i></div>');
        $('#modal').modal('show').find('.modal-body').load('<?=$this->request->getAttribute('base').'/flystart/cfg/centrocusto/edit'?>/'+id,function(responseText, textStatus, req){
            if (textStatus == "error") {
                alert('Sua consulta retornou um número muito grande de registros. Tente um período menor.');
                $('[data-dismiss="modal"]').click();
            }
        });
        $('#loading').hide();

        $('button[data-dismiss="modal"]').on('click', function(e){
            $('.modal-body').html("");
        });
    }

    $(document).ready(function(){
        $('.datatablecentro').DataTable({
		    paging : true,
		    scroll : true,
            language: {
                url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
                decimal: ",",
                thousands: "."
            },
            dom: 'Bfrtip',
            aaSorting: [],
            buttons: [
                {
                    extend: 'copy',
                    text: 'Copiar'
                },
                {
                    extend: 'print',
                    text: 'Imprimir',
                    messageTop: 'Centros de Custo da Filial <?=$empresa->razaosocial?> \n Emitido em: <?=Date('d/m/Y h:i:s')?>'
                },
                {
                    extend: 'excel',
                    filename: 'FlyStart - Centros de Custo da Filial <?=$empresa->razaosocial?>',
                    text: 'Excel',
                    messageTop: 'Centros de Custo da Filial <?=$empresa->razaosocial?> \n Emitido em: <?=Date('d/m/Y h:i:s')?>'
                },
                {
                    extend: 'pdf',
                    filename: 'FlyStart - Centros de Custo da Filial <?=$empresa->razaosocial?>',
                    text: 'PDF',
                    orientation:'landscape',
                    title:'FlyGestor',
                    pageSize:'A4',
                    messageTop: 'Centros de Custo da Filial <?=$empresa->razaosocial?> \n Emitido em: <?=Date('d/m/Y h:i:s')?>'
                }
            ]  
        })
    })
</script>