<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Grauinteressecontato[]|\Cake\Collection\CollectionInterface $grauinteressecontato
 */
?>
<div class="card">
<div class="card-header">
	<h3><?= __('Grauinteressecontato') ?></h3>
	<div class="float-right">
		<?= $this->Html->link(__('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar'), ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?></li>
	</div>
</div>
<div class="card-body">
    <table class="table table-responsive table-striped" cellpadding="0" cellspacing="0">
        <thead>
            <tr>
                <th scope="col"><?= $this->Paginator->sort('grauinteressecontatoid') ?></th>
                <th scope="col"><?= $this->Paginator->sort('nome') ?></th>
                <th scope="col"><?= $this->Paginator->sort('descricao') ?></th>
                <th scope="col"><?= $this->Paginator->sort('peso') ?></th>
                <th scope="col"><?= $this->Paginator->sort('empresaid') ?></th>
                <th scope="col"><?= $this->Paginator->sort('data_criacao') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($grauinteressecontato as $grauinteressecontato): ?>
            <tr style="cursor:pointer" onclick="window.location.href='grauinteressecontato/view/<?=$grauinteressecontato->grauinteressecontatoid?>'">
                <td><?= $this->Number->format($grauinteressecontato->grauinteressecontatoid) ?></td>
                <td><?= h($grauinteressecontato->nome) ?></td>
                <td><?= h($grauinteressecontato->descricao) ?></td>
                <td><?= $this->Number->format($grauinteressecontato->peso) ?></td>
                <td><?= $this->Number->format($grauinteressecontato->empresaid) ?></td>
                <td><?= h($grauinteressecontato->data_criacao) ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('primeiro')) ?>
            <?= $this->Paginator->prev('< ' . __('anterior')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('próximo') . ' >') ?>
            <?= $this->Paginator->last(__('último') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(['format' => __('Página {{page}} de {{pages}}, mostrando {{current}} registros(s) de total {{count}}')]) ?></p>
    </div>
</div>
</div>
