<?php
  $date = new DateTime();
  $dataHora = $date->format('d/m/Y H:i:s');
  $dataTraco = $date->format('d-m-Y');
  $dataBarra = $date->format('d/m/Y');
  $session = $this->request->session();
  $totalRegistros = count($statusfunil);
  $usuario = $session->read('login.usuario')->nome;

  $nomeRelatorio="Status Contato Funil";
?>
<div class="card">
<div class="card-header">
	<h3><?= __('Status Contato') ?></h3>
	<div class="float-right">
		<?= $this->Html->link(__('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar'), ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?></li>
	</div>
</div>
<div class="card-body">
    <table id="datatable2" style="font-size:13px;" class="table table-responsive table-striped" cellpadding="0" cellspacing="0">
        <thead>
            <tr>
                <th scope="col">Funil</th>
                <th scope="col">Status Contatos</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($statusfunil as $status): ?>
            <tr style="cursor:pointer" onclick="window.location.href='statuscontato/list/<?= $status->idfunil ?>'">
                <td><?= $status->descricao ?></td>
                <td><?= $status->statuscontato ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

</div>
</div>
<script>
	$('table td').css('padding','3px');
	$('table th').css('padding','5px');
	
	
	
	var datatable2 = $("#datatable2").DataTable({
		responsive: true,
		retrieve: false,
		paging : true,
		scroll : true,
		fixedHeader: {
		  header: true,
		  footer: false
		},
		language: {
			url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
			decimal: ",",
			thousands: "."
		},
		dom: 'Bfrtip',
		buttons: [
			{
			  extend: 'copy',
			  text: 'Copiar'
			},
			{
			  extend: 'print',
			  text: 'Imprimir',
			  messageTop: 'Relatório: <?=$nomeRelatorio?>  \n Usuário: <?=$usuario?> \n Emitido em: <?=$dataHora?>'
			},
			{
			  extend: 'excel',
			  filename: 'Flygestor - <?=$nomeRelatorio?>',
			  text: 'Excel',
			   messageTop: '<?=$nomeRelatorio?> | Usuário: <?=$usuario?> | Emitido em: <?=$dataHora?> | Total de registros: <?=$totalRegistros?>'
			},
			{
			  extend: 'pdf',
			  //Name the pdf
			  filename: 'Flygestor - <?=$nomeRelatorio?> <?=$dataTraco?>',
			  text: 'PDF',
			  orientation:'landscape',
			  title:'FlyGestor',
			  pageSize:'A4',
			  messageTop: 'Relatório: <?=$nomeRelatorio?>  \n Usuário: <?=$usuario?> \n Emitido em: <?=$dataHora?> \n Total de registros: <?=$totalRegistros?>',
			  messageBottom:'Flygestor - <?=$nomeRelatorio?> | Usuário: <?=$usuario?> | Emitido em: <?=$dataHora?> | Total de registros: <?=$totalRegistros?>'
			  ,customize: function(doc) {
				  doc.defaultStyle.fontSize = 8;
				  doc.styles.tableHeader.fontSize = 8;
				  //console.log(doc.content[2]);

				var iColumns = $('#datatable2 thead th').length;
				var rowCount = datatable2.rows().data().length; 
				for (i = 0; i < rowCount; i++) {
					if(i == 0){continue;}
					for(j = 0; j < iColumns; j++){
						if(j <= 1){continue;}
						doc.content[2].table.body[i][j].alignment = 'right';
					}
				}

			  }  
			}
		]  
	});
	
</script>
