<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Statuscontato[]|\Cake\Collection\CollectionInterface $statuscontato
 */
?>
<div class="card">
<div class="card-header">
	<h3><?= __('Status Contato') ?></h3>
	<div class="float-right">
		<?= $this->Html->link(__('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar'), ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?></li>
        <?= $this->Html->link('&nbsp;<i class="fa fa-bars" aria-hidden="true"></i> Listar Status Funil', ['action' => 'index'], ['class'=>'btn btn-primary','escape'=>false]) ?>
    </div>
</div>
<div class="card-body">
    <table class="table table-responsive table-striped" cellpadding="0" cellspacing="0">
        <thead>
            <tr>
                <th scope="col"><?= $this->Paginator->sort('statuscontatoid',['label'=>'Cód']) ?></th>
                <th scope="col"><?= $this->Paginator->sort('nome') ?></th>
                <th scope="col"><?= $this->Paginator->sort('descricao',['label'=>'Descrição']) ?></th>
                <th scope="col"><?= $this->Paginator->sort('ordem') ?></th>
				<th scope="col"><?= $this->Paginator->sort('sucesso') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($statuscontato as $statuscontato): ?>
            <tr style="cursor:pointer" onclick="window.location.href='<?=$this->request->getAttribute("base") ?>/flystart/cfg/statuscontato/edit/<?=$statuscontato->statuscontatoid?>'">
                <td><?= $this->Number->format($statuscontato->statuscontatoid) ?></td>
                <td><?= h($statuscontato->nome) ?></td>
                <td><?= h($statuscontato->descricao) ?></td>
                <td><?= $this->Number->format($statuscontato->ordem) ?></td>
				<td><?= $this->Custom->toSimNao($statuscontato->sucesso) ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('primeiro')) ?>&nbsp;&nbsp;
            <?= $this->Paginator->prev('< ' . __('anterior')) ?>&nbsp;&nbsp;
            <?= $this->Paginator->numbers() ?>&nbsp;&nbsp;
            <?= $this->Paginator->next(__('próximo') . ' >') ?>&nbsp;&nbsp;
            <?= $this->Paginator->last(__('último') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(['format' => __('Página {{page}} de {{pages}}, mostrando {{current}} registros(s) de total {{count}}')]) ?></p>
    </div>
</div>
</div>
