<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Tipocliente[]|\Cake\Collection\CollectionInterface $tipocliente
 */
?>
<div class="card">
<div class="card-header">
	<h3><?= __('Tipo Cliente') ?></h3>
	<div class="float-right">
		<?= $this->Html->link(__('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar'), ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?></li>
	</div>
</div>
<div class="card-body">
    <table class="table table-responsive table-striped" cellpadding="0" cellspacing="0">
        <thead>
            <tr>
                <th scope="col"><?= $this->Paginator->sort('tipoclienteid',['label'=>'Cód']) ?></th>
                <th scope="col"><?= $this->Paginator->sort('nome') ?></th>
                <th scope="col"><?= $this->Paginator->sort('descricao',['label'=>'Descrição']) ?></th>
                <th scope="col"><?= $this->Paginator->sort('ordem') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($tipocliente as $tipocliente): ?>
            <tr style="cursor:pointer" onclick="window.location.href='tipocliente/view/<?=$tipocliente->tipoclienteid?>'">
                <td><?= ($tipocliente->tipoclienteid) ?></td>
                <td><?= h($tipocliente->nome) ?></td>
                <td><?= h($tipocliente->descricao) ?></td>
                <td><?= $this->Number->format($tipocliente->ordem) ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('primeiro')) ?>&nbsp;&nbsp;
            <?= $this->Paginator->prev('< ' . __('anterior')) ?>&nbsp;&nbsp;
            <?= $this->Paginator->numbers() ?>&nbsp;&nbsp;
            <?= $this->Paginator->next(__('próximo') . ' >') ?>&nbsp;&nbsp;
            <?= $this->Paginator->last(__('último') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(['format' => __('Página {{page}} de {{pages}}, mostrando {{current}} registros(s) de total {{count}}')]) ?></p>
    </div>
</div>
</div>
