<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Tipocliente $tipocliente
 */
?>
<div class="card">
<div class="card-header">
	<h3>Tipocliente <?= h($tipocliente->tipoclienteid) ?></h3>
	<div class="float-right">
		<?= $this->Html->link('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar', ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-bars" aria-hidden="true"></i> Listar', ['action' => 'index'], ['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-edit fa-2" aria-hidden="true"></i>  Editar', ['action' => 'edit', $tipocliente->tipoclienteid], ['class'=>'btn btn-primary','escape'=>false]) ?> 
		<?= $this->Form->postLink('&nbsp;<i class="fa fa-trash fa-2" aria-hidden="true"></i>  Deletar', ['action' => 'delete', $tipocliente->tipoclienteid], ['confirm' => __('Deseja deletar # {0}?', $tipocliente->tipoclienteid),'class'=>'btn btn-primary', 'escape'=>false]) ?>
	</div>
</div>
<div class="card-body">
    <table class="vertical-table table-responsive table">
        <tr>
            <th scope="row"><?= __('Nome') ?></th>
            <td><?= h($tipocliente->nome) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Descricao') ?></th>
            <td><?= h($tipocliente->descricao) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Tipoclienteid') ?></th>
            <td><?= $this->Number->format($tipocliente->tipoclienteid) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Ordem') ?></th>
            <td><?= $this->Number->format($tipocliente->ordem) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Pessoaidcadastro') ?></th>
            <td><?= $this->Number->format($tipocliente->pessoaidcadastro) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Empresaid') ?></th>
            <td><?= $this->Number->format($tipocliente->empresaid) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Data Criacao') ?></th>
            <td><?= h($tipocliente->data_criacao) ?></td>
        </tr>
    </table>
</div>
</div>
